/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ReusableLatchTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(ReusableLatchTest.class);

    @Test
    public void testLatchWithParameterizedDown() throws Exception {
        ReusableLatch latch = new ReusableLatch(1000);
        latch.countDown(5000);
        ReusableLatchTest.assertTrue((boolean)latch.await(1000L));
        ReusableLatchTest.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testLatchOnSingleThread() throws Exception {
        int i;
        ReusableLatch latch = new ReusableLatch();
        for (i = 1; i <= 100; ++i) {
            latch.countUp();
            Assert.assertEquals((long)i, (long)latch.getCount());
        }
        for (i = 100; i > 0; --i) {
            Assert.assertEquals((long)i, (long)latch.getCount());
            latch.countDown();
            Assert.assertEquals((long)(i - 1), (long)latch.getCount());
        }
        latch.await();
    }

    @Test
    public void testLatchOnMultiThread() throws Exception {
        int i;
        int i2;
        final ReusableLatch latch = new ReusableLatch();
        latch.countUp();
        int numberOfThreads = 100;
        int numberOfAdds = 100;
        CountDownLatch latchReady = new CountDownLatch(100);
        CountDownLatch latchStart = new CountDownLatch(1);
        class ThreadAdd
        extends Thread {
            private final CountDownLatch latchReady;
            private final CountDownLatch latchStart;

            ThreadAdd(CountDownLatch latchReady, CountDownLatch latchStart) {
                this.latchReady = latchReady;
                this.latchStart = latchStart;
            }

            @Override
            public void run() {
                try {
                    this.latchReady.countDown();
                    this.latchStart.await();
                    for (int i = 0; i < 100; ++i) {
                        latch.countUp();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        ThreadAdd[] threadAdds = new ThreadAdd[100];
        class ThreadWait
        extends Thread {
            private volatile boolean waiting = true;

            ThreadWait() {
            }

            @Override
            public void run() {
                try {
                    if (!latch.await(5000L)) {
                        log.error((Object)"Latch timed out");
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                this.waiting = false;
            }
        }
        ThreadWait[] waits = new ThreadWait[100];
        for (i2 = 0; i2 < 100; ++i2) {
            threadAdds[i2] = new ThreadAdd(latchReady, latchStart);
            threadAdds[i2].start();
            waits[i2] = new ThreadWait();
            waits[i2].start();
        }
        latchReady.await();
        latchStart.countDown();
        for (i2 = 0; i2 < 100; ++i2) {
            threadAdds[i2].join();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            Assert.assertTrue((boolean)waits[i2].waiting);
        }
        Assert.assertEquals((long)10001L, (long)latch.getCount());
        latchReady = new CountDownLatch(100);
        latchStart = new CountDownLatch(1);
        class ThreadDown
        extends Thread {
            private final CountDownLatch latchReady;
            private final CountDownLatch latchStart;

            ThreadDown(CountDownLatch latchReady, CountDownLatch latchStart) {
                this.latchReady = latchReady;
                this.latchStart = latchStart;
            }

            @Override
            public void run() {
                try {
                    this.latchReady.countDown();
                    this.latchStart.await();
                    for (int i = 0; i < 100; ++i) {
                        latch.countDown();
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        ThreadDown[] down = new ThreadDown[100];
        for (i = 0; i < 100; ++i) {
            down[i] = new ThreadDown(latchReady, latchStart);
            down[i].start();
        }
        latchReady.await();
        latchStart.countDown();
        for (i = 0; i < 100; ++i) {
            down[i].join();
        }
        Assert.assertEquals((long)1L, (long)latch.getCount());
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)waits[i].waiting);
        }
        latch.countDown();
        for (i = 0; i < 100; ++i) {
            waits[i].join();
        }
        Assert.assertEquals((long)0L, (long)latch.getCount());
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)waits[i].waiting);
        }
    }

    @Test
    public void testReuseLatch() throws Exception {
        final ReusableLatch latch = new ReusableLatch(5);
        for (int i = 0; i < 5; ++i) {
            latch.countDown();
        }
        latch.countUp();
        class ThreadWait
        extends Thread {
            private volatile boolean waiting = false;
            private volatile Exception e;
            private final CountDownLatch readyLatch = new CountDownLatch(1);

            ThreadWait() {
            }

            @Override
            public void run() {
                this.waiting = true;
                this.readyLatch.countDown();
                try {
                    if (!latch.await(1000L)) {
                        log.error((Object)"Latch timed out!", (Throwable)new Exception("trace"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    this.e = e;
                }
                this.waiting = false;
            }
        }
        ThreadWait t = new ThreadWait();
        t.start();
        t.readyLatch.await();
        Assert.assertEquals((Object)true, (Object)t.waiting);
        latch.countDown();
        t.join();
        Assert.assertEquals((Object)false, (Object)t.waiting);
        Assert.assertNull((Object)t.e);
        latch.countUp();
        t = new ThreadWait();
        t.start();
        t.readyLatch.await();
        Assert.assertEquals((Object)true, (Object)t.waiting);
        latch.countDown();
        t.join();
        Assert.assertEquals((Object)false, (Object)t.waiting);
        Assert.assertNull((Object)t.e);
        Assert.assertTrue((boolean)latch.await(1000L));
        Assert.assertEquals((long)0L, (long)latch.getCount());
        latch.countDown();
        Assert.assertEquals((long)0L, (long)latch.getCount());
    }
}

