/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.jts.orbspecific;

import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jta.utils.jts.StatusConverter;
import com.arjuna.ats.internal.jts.ORBManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationHelper;
import org.omg.CosTransactions.SynchronizationOperations;
import org.omg.CosTransactions.SynchronizationPOATie;
import org.omg.PortableServer.Servant;

public class SynchronizationImple
implements SynchronizationOperations {
    private jakarta.transaction.Synchronization _theSynch;
    private Synchronization _theReference;
    private Servant _thePOATie;
    private ClassLoader _theClassLoader;

    public SynchronizationImple(jakarta.transaction.Synchronization ptr) {
        this._theSynch = ptr;
        this._theReference = null;
        this._theClassLoader = this.getContextClassLoader();
    }

    public final Synchronization getSynchronization() {
        if (this._theReference == null) {
            this._thePOATie = this.getPOATie();
            ORBManager.getPOA().objectIsReady(this._thePOATie);
            this._theReference = SynchronizationHelper.narrow(ORBManager.getPOA().corbaReference(this._thePOATie));
        }
        return this._theReference;
    }

    @Override
    public void before_completion() throws SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("SynchronizationImple.before_completion - Class: " + this._theSynch.getClass() + " HashCode: " + this._theSynch.hashCode() + " toString: " + this._theSynch));
        }
        if (this._theSynch != null) {
            ClassLoader origClassLoader = this.getContextClassLoader();
            try {
                this.setContextClassLoader(this._theClassLoader);
                this._theSynch.beforeCompletion();
            }
            catch (Exception e) {
                jtaxLogger.logger.trace((Object)("SynchronizationImple.before_completion failed - toString: " + this._theSynch), (Throwable)e);
                throw new UNKNOWN();
            }
            finally {
                this.setContextClassLoader(origClassLoader);
            }
        } else {
            throw new UNKNOWN();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void after_completion(Status status) throws SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("SynchronizationImple.after_completion - Class: " + this._theSynch.getClass() + " HashCode: " + this._theSynch.hashCode() + " toString: " + this._theSynch));
        }
        if (this._theSynch == null) throw new UNKNOWN();
        int s = StatusConverter.convert(status);
        ClassLoader origClassLoader = this.getContextClassLoader();
        try {
            this.setContextClassLoader(this._theClassLoader);
            this._theSynch.afterCompletion(s);
            if (this._theReference == null) return;
            ORBManager.getPOA().shutdownObject(this._thePOATie);
            return;
        }
        catch (Exception e) {
            jtaxLogger.logger.trace((Object)("SynchronizationImple.after_completion failed - toString: " + this._theSynch), (Throwable)e);
            if (this._theReference == null) throw new UNKNOWN();
            ORBManager.getPOA().shutdownObject(this._thePOATie);
            throw new UNKNOWN();
        }
        finally {
            this.setContextClassLoader(origClassLoader);
        }
    }

    protected Servant getPOATie() {
        return new SynchronizationPOATie(this);
    }

    private ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

