/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics.deployment;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricCollector;
import org.wildfly.extension.metrics.MetricRegistration;
import org.wildfly.extension.metrics.MetricRegistry;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics.MicroProfileVendorMetricRegistry;

public class DeploymentMetricService
implements Service {
    private final Resource rootResource;
    private final ManagementResourceRegistration managementResourceRegistration;
    private PathAddress deploymentAddress;
    private final Supplier<MetricCollector> metricCollector;
    private Supplier<Executor> managementExecutor;
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;
    private final String prefix;
    private MetricRegistration registration;

    public static void install(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Resource rootResource, ManagementResourceRegistration managementResourceRegistration, boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        PathAddress deploymentAddress = DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(deploymentUnit.getServiceName().append(new String[]{"microprofile-metrics"}));
        Supplier metricCollector = sb.requires(MicroProfileMetricsSubsystemDefinition.WILDFLY_COLLECTOR);
        Supplier managementExecutor = sb.requires(ServerService.EXECUTOR_CAPABILITY.getCapabilityServiceName());
        sb.requires(DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName()));
        sb.setInstance((Service)new DeploymentMetricService(rootResource, managementResourceRegistration, deploymentAddress, metricCollector, managementExecutor, exposeAnySubsystem, exposedSubsystems, prefix)).install();
    }

    private DeploymentMetricService(Resource rootResource, ManagementResourceRegistration managementResourceRegistration, PathAddress deploymentAddress, Supplier<MetricCollector> metricCollector, Supplier<Executor> managementExecutor, boolean exposeAnySubsystem, List<String> exposedSubsystems, String prefix) {
        this.rootResource = rootResource;
        this.managementResourceRegistration = managementResourceRegistration;
        this.deploymentAddress = deploymentAddress;
        this.metricCollector = metricCollector;
        this.managementExecutor = managementExecutor;
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext startContext) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    DeploymentMetricService.this.registration = new MetricRegistration((MetricRegistry)new MicroProfileVendorMetricRegistry());
                    DeploymentMetricService.this.metricCollector.get().collectResourceMetrics(DeploymentMetricService.this.rootResource, (ImmutableManagementResourceRegistration)DeploymentMetricService.this.managementResourceRegistration, address -> DeploymentMetricService.this.deploymentAddress.append(address), DeploymentMetricService.this.exposeAnySubsystem, DeploymentMetricService.this.exposedSubsystems, DeploymentMetricService.this.prefix, DeploymentMetricService.this.registration);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw t;
                }
                startContext.complete();
            }
        };
        try {
            this.managementExecutor.get().execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            startContext.asynchronous();
        }
    }

    public void stop(StopContext stopContext) {
        this.registration.unregister();
    }

    private static PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)((String)deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME)));
        }
        return DeploymentMetricService.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }
}

