/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.utils.actors.ActorListener;
import org.apache.activemq.artemis.utils.actors.ProcessorBase;
import org.jboss.logging.Logger;

public class ThresholdActor<T>
extends ProcessorBase<Object> {
    private static final Logger logger = Logger.getLogger(ThresholdActor.class);
    private static final AtomicIntegerFieldUpdater<ThresholdActor> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ThresholdActor.class, "size");
    private volatile int size = 0;
    private static final AtomicIntegerFieldUpdater<ThresholdActor> SCHEDULED_FLUSH_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ThresholdActor.class, "scheduledFlush");
    private volatile int scheduledFlush = 0;
    private static final Object FLUSH = new Object();
    private final int maxSize;
    private final ToIntFunction<T> sizeGetter;
    private final ActorListener<T> listener;
    private final Runnable overThreshold;
    private final Runnable clearThreshold;

    public ThresholdActor(Executor parent, ActorListener<T> listener, int maxSize, ToIntFunction<T> sizeGetter, Runnable overThreshold, Runnable clearThreshold) {
        super(parent);
        this.listener = listener;
        this.maxSize = maxSize;
        this.sizeGetter = sizeGetter;
        this.overThreshold = overThreshold;
        this.clearThreshold = clearThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doTask(Object task) {
        if (task == FLUSH) {
            this.clearThreshold.run();
            SCHEDULED_FLUSH_UPDATER.set(this, 0);
            return;
        }
        Object theTask = task;
        int estimateSize = this.sizeGetter.applyAsInt(theTask);
        try {
            this.listener.onMessage(theTask);
        }
        finally {
            if (estimateSize > 0) {
                SIZE_UPDATER.getAndAdd(this, -estimateSize);
            } else if (logger.isDebugEnabled()) {
                logger.debug("element " + theTask + " returned an invalid size over the Actor during release");
            }
        }
    }

    public void act(T message) {
        int sizeEstimate = this.sizeGetter.applyAsInt(message);
        if (sizeEstimate > 0) {
            int size = SIZE_UPDATER.addAndGet(this, this.sizeGetter.applyAsInt(message));
            if (size > this.maxSize) {
                this.flush();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("element " + message + " returned an invalid size over the Actor");
        }
        this.task(message);
    }

    public void flush() {
        if (SCHEDULED_FLUSH_UPDATER.compareAndSet(this, 0, 1)) {
            this.overThreshold.run();
            this.task(FLUSH);
        }
    }
}

