/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import io.grpc.BinaryLog;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends ServerBuilder<T>>
extends ServerBuilder<T> {
    protected AbstractServerImplBuilder() {
    }

    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    protected abstract ServerBuilder<?> delegate();

    public T directExecutor() {
        this.delegate().directExecutor();
        return this.thisT();
    }

    public T executor(@Nullable Executor executor) {
        this.delegate().executor(executor);
        return this.thisT();
    }

    public T addService(ServerServiceDefinition service) {
        this.delegate().addService(service);
        return this.thisT();
    }

    public T addService(BindableService bindableService) {
        this.delegate().addService(bindableService);
        return this.thisT();
    }

    public T intercept(ServerInterceptor interceptor) {
        this.delegate().intercept(interceptor);
        return this.thisT();
    }

    public T addTransportFilter(ServerTransportFilter filter) {
        this.delegate().addTransportFilter(filter);
        return this.thisT();
    }

    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate().addStreamTracerFactory(factory);
        return this.thisT();
    }

    public T fallbackHandlerRegistry(@Nullable HandlerRegistry fallbackRegistry) {
        this.delegate().fallbackHandlerRegistry(fallbackRegistry);
        return this.thisT();
    }

    public T useTransportSecurity(File certChain, File privateKey) {
        this.delegate().useTransportSecurity(certChain, privateKey);
        return this.thisT();
    }

    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        this.delegate().useTransportSecurity(certChain, privateKey);
        return this.thisT();
    }

    public T decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.delegate().decompressorRegistry(registry);
        return this.thisT();
    }

    public T compressorRegistry(@Nullable CompressorRegistry registry) {
        this.delegate().compressorRegistry(registry);
        return this.thisT();
    }

    public T handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate().handshakeTimeout(timeout, unit);
        return this.thisT();
    }

    public T maxInboundMessageSize(int bytes) {
        this.delegate().maxInboundMessageSize(bytes);
        return this.thisT();
    }

    public T maxInboundMetadataSize(int bytes) {
        this.delegate().maxInboundMetadataSize(bytes);
        return this.thisT();
    }

    public T setBinaryLog(BinaryLog binaryLog) {
        this.delegate().setBinaryLog(binaryLog);
        return this.thisT();
    }

    public Server build() {
        return this.delegate().build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", this.delegate()).toString();
    }

    protected final T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)((Object)thisT);
    }
}

