/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

public abstract class NodeManager
implements ActiveMQComponent {
    private static final Logger LOGGER = Logger.getLogger(NodeManager.class);
    protected final boolean replicatedBackup;
    protected final Object nodeIDGuard = new Object();
    private SimpleString nodeID;
    private UUID uuid;
    private boolean isStarted = false;
    private final Set<LockListener> lockListeners;
    public static final long NULL_NODE_ACTIVATION_SEQUENCE = -1L;
    protected long nodeActivationSequence = -1L;

    public NodeManager(boolean replicatedBackup) {
        this.replicatedBackup = replicatedBackup;
        this.lockListeners = new HashSet<LockListener>();
    }

    public abstract void awaitLiveNode() throws NodeManagerException, InterruptedException;

    public abstract void awaitLiveStatus() throws NodeManagerException, InterruptedException;

    public abstract void startBackup() throws NodeManagerException, InterruptedException;

    public abstract ActivateCallback startLiveNode() throws NodeManagerException, InterruptedException;

    public abstract void pauseLiveServer() throws NodeManagerException;

    public abstract void crashLiveServer() throws NodeManagerException;

    public abstract void releaseBackup() throws NodeManagerException;

    public synchronized void start() throws Exception {
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleString getNodeId() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.nodeID;
        }
    }

    public long readNodeActivationSequence() throws NodeManagerException {
        throw new UnsupportedOperationException("TODO");
    }

    public void writeNodeActivationSequence(long version) throws NodeManagerException {
        throw new UnsupportedOperationException("TODO");
    }

    public abstract SimpleString readNodeId() throws NodeManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeActivationSequence() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.nodeActivationSequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeActivationSequence(long sequence) {
        if (sequence != -1L && sequence < 0L) {
            throw new IllegalArgumentException("activation sequence must be >=0 or NULL_NODE_ACTIVATION_SEQUENCE");
        }
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.nodeActivationSequence = sequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.uuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeID(String nodeID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.nodeID = new SimpleString(nodeID);
            this.uuid = new UUID(1, UUID.stringToBytes((String)nodeID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUUID(UUID generateUUID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.uuid = generateUUID;
            this.nodeID = new SimpleString(this.uuid.toString());
        }
    }

    public abstract boolean isAwaitingFailback() throws NodeManagerException;

    public abstract boolean isBackupLive() throws NodeManagerException;

    public abstract void interrupt();

    public synchronized void stop() throws Exception {
        this.isStarted = false;
        this.lockListeners.clear();
    }

    public void stopBackup() throws NodeManagerException {
        this.releaseBackup();
    }

    protected synchronized void checkStarted() {
        if (!this.isStarted) {
            throw new IllegalStateException("the node manager is supposed to be started");
        }
    }

    protected synchronized void notifyLostLock() {
        if (!this.isStarted) {
            return;
        }
        this.lockListeners.forEach(lockListener -> {
            try {
                lockListener.lostLock();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"On notify lost lock", (Throwable)e);
            }
        });
    }

    public synchronized void registerLockListener(LockListener lockListener) {
        this.lockListeners.add(lockListener);
    }

    public synchronized void unregisterLockListener(LockListener lockListener) {
        this.lockListeners.remove(lockListener);
    }

    public static final class NodeManagerException
    extends RuntimeException {
        public NodeManagerException(String message) {
            super(message);
        }

        public NodeManagerException(Throwable cause) {
            super(cause);
        }

        public NodeManagerException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface LockListener {
        public void lostLock();
    }
}

