/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.patching.installation.AddOn;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.Layer;
import org.jboss.as.patching.installation.PatchableTarget;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.PatchStreamResourceOperationStepHandler;
import org.jboss.dmr.ModelNode;

abstract class ElementProviderAttributeReadHandler
extends PatchStreamResourceOperationStepHandler {
    ElementProviderAttributeReadHandler() {
    }

    @Override
    protected String getPatchStreamName(OperationContext context) {
        PathAddress currentAddress = context.getCurrentAddress();
        PathElement stream = currentAddress.getElement(currentAddress.size() - 2);
        String streamName = "patch-stream".equals(stream.getKey()) ? stream.getValue() : null;
        return streamName;
    }

    @Override
    protected void execute(OperationContext context, ModelNode operation, InstalledIdentity installedIdentity) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        String name = element.getValue();
        PatchableTarget target = this.getProvider(name, installedIdentity);
        ModelNode result = context.getResult();
        this.handle(result, target);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected abstract PatchableTarget getProvider(String var1, InstalledIdentity var2) throws OperationFailedException;

    abstract void handle(ModelNode var1, PatchableTarget var2) throws OperationFailedException;

    static abstract class LayerAttributeReadHandler
    extends ElementProviderAttributeReadHandler {
        LayerAttributeReadHandler() {
            this.acquireWriteLock = false;
        }

        @Override
        protected Layer getProvider(String name, InstalledIdentity identity) throws OperationFailedException {
            Layer target = identity.getLayer(name);
            if (target == null) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.noSuchLayer(name).getLocalizedMessage());
            }
            return target;
        }
    }

    static abstract class AddOnAttributeReadHandler
    extends ElementProviderAttributeReadHandler {
        AddOnAttributeReadHandler() {
        }

        @Override
        protected PatchableTarget getProvider(String name, InstalledIdentity identity) throws OperationFailedException {
            AddOn target = identity.getAddOn(name);
            if (target == null) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.noSuchLayer(name).getLocalizedMessage());
            }
            return target;
        }
    }
}

