/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.IndexedQuery;

final class EmbeddedLuceneQuery<TypeMetadata, T>
extends BaseQuery<T> {
    private final QueryEngine<TypeMetadata> queryEngine;
    private final QueryEngine.RowProcessor rowProcessor;
    private final IckleParsingResult<TypeMetadata> parsingResult;
    private IndexedQuery<T> indexedQuery;

    EmbeddedLuceneQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, Map<String, Object> namedParameters, IckleParsingResult<TypeMetadata> parsingResult, String[] projection, QueryEngine.RowProcessor rowProcessor, long startOffset, int maxResults, boolean local) {
        super(queryFactory, parsingResult.getQueryString(), namedParameters, projection, startOffset, maxResults, local);
        if (rowProcessor != null && (projection == null || projection.length == 0)) {
            throw new IllegalArgumentException("A RowProcessor can only be specified with projections");
        }
        this.queryEngine = queryEngine;
        this.rowProcessor = rowProcessor;
        this.parsingResult = parsingResult;
    }

    public void resetQuery() {
        this.indexedQuery = null;
    }

    private IndexedQuery<T> createIndexedQuery() {
        if (this.indexedQuery == null) {
            this.validateNamedParameters();
            this.indexedQuery = this.queryEngine.buildLuceneQuery(this.parsingResult, this.namedParameters, this.startOffset, this.maxResults, this.isLocal());
            if (this.timeout > 0L) {
                this.indexedQuery.timeout(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
        return this.indexedQuery;
    }

    public List<T> list() {
        return this.execute().list();
    }

    public QueryResult<T> execute() {
        IndexedQuery<T> indexedQuery = this.createIndexedQuery();
        QueryResult<?> result = indexedQuery.execute();
        List collect = result.list().stream().map(this::convertResult).collect(Collectors.toList());
        return new QueryResultImpl(result.hitCount().orElse(-1L), collect);
    }

    public int executeStatement() {
        IndexedQuery<T> indexedQuery = this.createIndexedQuery();
        return indexedQuery.executeStatement();
    }

    public CloseableIterator<T> iterator() {
        return new MappingIterator(this.createIndexedQuery().iterator(), this::convertResult);
    }

    public <K> CloseableIterator<Map.Entry<K, T>> entryIterator() {
        return new MappingIterator(this.createIndexedQuery().entryIterator(), null);
    }

    public int getResultSize() {
        return this.createIndexedQuery().getResultSize();
    }

    public String toString() {
        return "EmbeddedLuceneQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + "}";
    }

    private Object convertResult(Object result) {
        Object[] array;
        if (this.projection == null) {
            return result;
        }
        if (result instanceof Object[]) {
            array = (Object[])result;
        } else if (result instanceof List) {
            List castedRow = (List)result;
            array = castedRow.toArray(new Object[0]);
        } else {
            array = new Object[]{result};
        }
        return this.rowProcessor == null ? array : this.rowProcessor.apply(array);
    }
}

