/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.search.engine.backend.orchestration.spi.SingletonTask;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingMappingContext;
import org.hibernate.search.mapper.orm.common.spi.SessionHelper;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.AgentClusterLinkContextProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxConfigUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingMassIndexerAgentClusterLink;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxPollingMassIndexingInstructions;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class OutboxPollingMassIndexerAgent
implements PojoMassIndexerAgent {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Integer> POLLING_INTERVAL = ConfigurationProperty.forKey((String)"mass_indexer.polling_interval").asIntegerStrictlyPositive().withDefault((Object)100).build();
    private static final ConfigurationProperty<Integer> PULSE_INTERVAL = ConfigurationProperty.forKey((String)"mass_indexer.pulse_interval").asIntegerStrictlyPositive().withDefault((Object)2000).build();
    private static final ConfigurationProperty<Integer> PULSE_EXPIRATION = ConfigurationProperty.forKey((String)"mass_indexer.pulse_expiration").asIntegerStrictlyPositive().withDefault((Object)30000).build();
    private final String name;
    private final ScheduledExecutorService executor;
    private final long pollingInterval;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STOPPED);
    private final OutboxPollingMassIndexerAgentClusterLink clusterLink;
    private final AgentClusterLinkContextProvider clusterLinkContextProvider;
    private final Worker worker;
    private final SingletonTask processingTask;

    private static String name(String tenantId) {
        StringBuilder prefix = new StringBuilder("Mass indexer agent");
        if (tenantId != null) {
            prefix.append(" - Tenant <").append(tenantId).append(">");
        }
        return prefix.toString();
    }

    public static Factory factory(AutomaticIndexingMappingContext mapping, Clock clock, String tenantId, ConfigurationPropertySource configurationSource) {
        Duration pollingInterval = (Duration)POLLING_INTERVAL.getAndTransform(configurationSource, Duration::ofMillis);
        Duration pulseInterval = (Duration)PULSE_INTERVAL.getAndTransform(configurationSource, v -> OutboxConfigUtils.checkPulseInterval(Duration.ofMillis(v.intValue()), pollingInterval));
        Duration pulseExpiration = (Duration)PULSE_EXPIRATION.getAndTransform(configurationSource, v -> OutboxConfigUtils.checkPulseExpiration(Duration.ofMillis(v.intValue()), pulseInterval));
        return new Factory(mapping, clock, tenantId, pollingInterval, pulseInterval, pulseExpiration);
    }

    private OutboxPollingMassIndexerAgent(String name, Factory factory, ScheduledExecutorService executor, AgentRepositoryProvider agentRepositoryProvider, OutboxPollingMassIndexerAgentClusterLink clusterLink) {
        this.name = name;
        this.executor = executor;
        AutomaticIndexingMappingContext mapping = factory.mapping;
        this.pollingInterval = factory.pollingInterval.toMillis();
        String tenantId = factory.tenantId;
        this.clusterLink = clusterLink;
        TransactionHelper transactionHelper = new TransactionHelper(mapping.sessionFactory(), null);
        SessionHelper sessionHelper = new SessionHelper(mapping.sessionFactory(), tenantId);
        this.clusterLinkContextProvider = new AgentClusterLinkContextProvider(transactionHelper, sessionHelper, agentRepositoryProvider);
        this.worker = new Worker();
        this.processingTask = new SingletonTask(name, (SingletonTask.Worker)this.worker, (SingletonTask.Scheduler)new Scheduler(executor), mapping.failureHandler());
    }

    public CompletableFuture<?> start() {
        log.startingOutboxMassIndexerAgent(this.name);
        this.status.set(Status.STARTED);
        this.processingTask.ensureScheduled();
        return this.worker.agentFullyStartedFuture;
    }

    public CompletableFuture<?> preStop() {
        this.status.set(Status.STOPPED);
        return this.processingTask.completion();
    }

    public void stop() {
        log.stoppingOutboxMassIndexerAgent(this.name);
        try (Closer closer = new Closer();){
            closer.push(SingletonTask::stop, (Object)this.processingTask);
            closer.push(ExecutorService::shutdownNow, (Object)this.executor);
            closer.push(OutboxPollingMassIndexerAgent::leaveCluster, (Object)this);
        }
    }

    private void leaveCluster() {
        this.clusterLinkContextProvider.inTransaction(this.clusterLink::leaveCluster);
    }

    private class Scheduler
    implements SingletonTask.Scheduler {
        private final ScheduledExecutorService delegate;

        private Scheduler(ScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        public Future<?> schedule(Runnable runnable) {
            OutboxPollingMassIndexingInstructions instructions = OutboxPollingMassIndexerAgent.this.worker.instructions;
            if (instructions == null) {
                return this.delegate.schedule(runnable, OutboxPollingMassIndexerAgent.this.pollingInterval, TimeUnit.MILLISECONDS);
            }
            return this.delegate.schedule(runnable, instructions.timeInMillisecondsToExpiration(), TimeUnit.MILLISECONDS);
        }
    }

    private class Worker
    implements SingletonTask.Worker {
        private volatile OutboxPollingMassIndexingInstructions instructions;
        private final CompletableFuture<?> agentFullyStartedFuture = new CompletableFuture();

        private Worker() {
        }

        public CompletableFuture<?> work() {
            if (this.instructions != null && this.instructions.isStillValid()) {
                return CompletableFuture.completedFuture(null);
            }
            this.instructions = OutboxPollingMassIndexerAgent.this.clusterLinkContextProvider.inTransaction(OutboxPollingMassIndexerAgent.this.clusterLink::pulse);
            if (this.instructions.considerEventProcessingSuspended) {
                this.agentFullyStartedFuture.complete(null);
            }
            return CompletableFuture.completedFuture(null);
        }

        public void complete() {
            this.ensureScheduled();
        }

        private void ensureScheduled() {
            if (OutboxPollingMassIndexerAgent.this.status.get() == Status.STARTED) {
                OutboxPollingMassIndexerAgent.this.processingTask.ensureScheduled();
            }
        }
    }

    private static enum Status {
        STOPPED,
        STARTED;

    }

    public static class Factory {
        private final AutomaticIndexingMappingContext mapping;
        private final Clock clock;
        private final String tenantId;
        private final Duration pollingInterval;
        private final Duration pulseInterval;
        private final Duration pulseExpiration;

        private Factory(AutomaticIndexingMappingContext mapping, Clock clock, String tenantId, Duration pollingInterval, Duration pulseInterval, Duration pulseExpiration) {
            this.mapping = mapping;
            this.clock = clock;
            this.tenantId = tenantId;
            this.pollingInterval = pollingInterval;
            this.pulseInterval = pulseInterval;
            this.pulseExpiration = pulseExpiration;
        }

        public OutboxPollingMassIndexerAgent create(PojoMassIndexerAgentCreateContext context, AgentRepositoryProvider agentRepositoryProvider) {
            String agentName = OutboxPollingMassIndexerAgent.name(this.tenantId);
            OutboxPollingMassIndexerAgentClusterLink clusterLink = new OutboxPollingMassIndexerAgentClusterLink(agentName, this.mapping.failureHandler(), this.clock, this.pollingInterval, this.pulseInterval, this.pulseExpiration);
            ScheduledExecutorService executor = context.newScheduledExecutor(1, agentName);
            return new OutboxPollingMassIndexerAgent(agentName, this, executor, agentRepositoryProvider, clusterLink);
        }
    }
}

