/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.parsing.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class PropertiesAttributeDefinition
extends MapAttributeDefinition {
    private final Consumer<ModelNode> descriptionContributor = node -> {
        node.get("value-type").set(ModelType.STRING);
        node.get("expressions-allowed").set(new ModelNode(this.isAllowExpression()));
    };
    static final AttributeMarshaller MARSHALLER = new AttributeMarshaller(){

        public boolean isMarshallableAsElement() {
            return true;
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode model, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (model.hasDefined(attribute.getName())) {
                for (Property property : model.get(attribute.getName()).asPropertyList()) {
                    writer.writeStartElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Element.NAME.getLocalName(), property.getName());
                    String content = property.getValue().asString();
                    if (content.indexOf(10) > -1) {
                        writer.writeCharacters(content);
                    } else {
                        char[] chars = content.toCharArray();
                        writer.writeCharacters(chars, 0, chars.length);
                    }
                    writer.writeEndElement();
                }
            }
        }
    };
    static final AttributeParser PARSER = new AttributeParser(){

        public boolean isParseAsElement() {
            return true;
        }

        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof MapAttributeDefinition);
            String name = reader.getAttributeValue(null, "name");
            ((MapAttributeDefinition)attribute).parseAndAddParameterElement(name, reader.getElementText(), operation, reader);
        }
    };

    PropertiesAttributeDefinition(Builder builder) {
        super((MapAttributeDefinition.Builder)builder);
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.descriptionContributor.accept(node);
    }

    public static class Builder
    extends MapAttributeDefinition.Builder<Builder, PropertiesAttributeDefinition> {
        public Builder(String name) {
            super(name);
            this.setRequired(false);
            this.setAllowNullElement(false);
            this.setAttributeMarshaller(MARSHALLER);
            this.setAttributeParser(PARSER);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super((MapAttributeDefinition)basis);
        }

        public PropertiesAttributeDefinition build() {
            if (this.elementValidator == null) {
                this.elementValidator = new ModelTypeValidator(ModelType.STRING, this.isNillable(), this.isAllowExpression());
            }
            return new PropertiesAttributeDefinition(this);
        }
    }
}

