/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.SybaseSqlAstTranslator;
import org.hibernate.dialect.SybaseSqmToSqlAstConverter;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.IntegralTimestampaddFunction;
import org.hibernate.dialect.function.SybaseTruncFunction;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.internal.JTDSCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsNullTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.SmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    protected final boolean jtdsDriver;
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(16, 0);
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;
    private final UniqueDelegate uniqueDelegate = new SkipNullableUniqueDelegate(this);

    public SybaseDialect() {
        this(MINIMUM_VERSION);
    }

    public SybaseDialect(DatabaseVersion version) {
        super(version);
        this.jtdsDriver = true;
    }

    public SybaseDialect(DialectResolutionInfo info) {
        super(info);
        this.jtdsDriver = info.getDriverName() != null && info.getDriverName().contains("jTDS");
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision == 19 && scale == 0) {
                    return jdbcTypeRegistry.getDescriptor(-5);
                }
            }
            case -6: {
                if (!this.jtdsDriver) break;
                return jdbcTypeRegistry.getDescriptor(5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            @Override
            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new SybaseSqmToSqlAstConverter<SelectStatement>(sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.jtdsDriver) {
            jdbcTypeRegistry.addDescriptor(-6, SmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(2011, ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(-9, ClobJdbcType.CLOB_BINDING);
        } else {
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.STREAM_BINDING_EXTRACTING);
        }
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.PRIMITIVE_ARRAY_BINDING);
        typeContributions.contributeJdbcType(ObjectNullAsNullTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsNullTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return this.jtdsDriver ? NationalizationSupport.IMPLICIT : super.getNationalizationSupport();
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.stddevPopSamp_stdevp();
        functionFactory.varPopSamp_varp();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.round_round();
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count_big", "+", "varchar(16384)", false));
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.locate_charindex();
        functionFactory.replace_strReplace();
        functionFactory.everyAny_minMaxCase();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        functionContributions.getFunctionRegistry().register("timestampadd", new IntegralTimestampaddFunction(this, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("trunc", new SybaseTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "str_replace(convert(varchar,?1,102),'.','-')";
                }
                case TIME: {
                    return "convert(varchar,?1,108)";
                }
                case TIMESTAMP: {
                    return "str_replace(convert(varchar,?1,23),'T',' ')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        if (unit == TemporalUnit.EPOCH) {
            return "datediff(second, '1970-01-01 00:00:00', ?2)";
        }
        return "datepart(?1,?2)";
    }

    @Override
    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1,?2,?3)";
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return super.trimPattern(specification, character).replace("replace", "str_replace");
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Sybase");
    }

    @Override
    public boolean supportsStandardCurrentTimestampFunction() {
        return false;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        if (this.jtdsDriver) {
            return NameQualifierSupport.CATALOG;
        }
        return NameQualifierSupport.BOTH;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return this.jtdsDriver ? JTDSCallableStatementSupport.INSTANCE : super.getCallableStatementSupport();
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify " + columnName + " " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }
}

