/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.named.FetchMementoBasic;
import org.hibernate.query.named.ResultMementoEntity;
import org.hibernate.query.results.BasicValuedFetchBuilder;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilderEntityValued;
import org.hibernate.query.results.complete.CompleteResultBuilderEntityJpa;
import org.hibernate.query.results.complete.DelayedFetchBuilderBasicPart;
import org.hibernate.query.results.implicit.ImplicitFetchBuilderBasic;
import org.hibernate.spi.NavigablePath;

public class ResultMementoEntityJpa
implements ResultMementoEntity,
FetchMemento.Parent {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final LockMode lockMode;
    private final FetchMementoBasic discriminatorMemento;
    private final Map<String, FetchMemento> explicitFetchMementoMap;

    public ResultMementoEntityJpa(EntityMappingType entityDescriptor, LockMode lockMode, FetchMementoBasic discriminatorMemento, Map<String, FetchMemento> explicitFetchMementoMap) {
        this.navigablePath = new NavigablePath(entityDescriptor.getEntityName());
        this.entityDescriptor = entityDescriptor;
        this.lockMode = lockMode;
        this.discriminatorMemento = discriminatorMemento;
        this.explicitFetchMementoMap = explicitFetchMementoMap;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ResultBuilderEntityValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        BasicValuedFetchBuilder discriminatorFetchBuilder;
        EntityDiscriminatorMapping discriminatorMapping = this.entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping == null) {
            assert (this.discriminatorMemento == null);
            discriminatorFetchBuilder = null;
        } else {
            discriminatorFetchBuilder = this.discriminatorMemento != null ? (BasicValuedFetchBuilder)this.discriminatorMemento.resolve(this, querySpaceConsumer, context) : new ImplicitFetchBuilderBasic(this.navigablePath, discriminatorMapping);
        }
        HashMap<String, FetchBuilder> explicitFetchBuilderMap = new HashMap<String, FetchBuilder>();
        if (!this.explicitFetchMementoMap.isEmpty()) {
            this.explicitFetchMementoMap.forEach((relativePath, fetchMemento) -> explicitFetchBuilderMap.put((String)relativePath, fetchMemento.resolve(this, querySpaceConsumer, context)));
            boolean isEnhancedForLazyLoading = this.entityDescriptor.getRepresentationStrategy().isBytecodeEnhanced();
            this.entityDescriptor.forEachAttributeMapping(attributeMapping -> {
                if (attributeMapping instanceof BasicValuedModelPart) {
                    Function<String, FetchBuilder> fetchBuilderCreator = k -> new DelayedFetchBuilderBasicPart(this.navigablePath.append((String)k), (BasicValuedModelPart)((Object)attributeMapping), isEnhancedForLazyLoading);
                    explicitFetchBuilderMap.computeIfAbsent(attributeMapping.getFetchableName(), fetchBuilderCreator);
                }
            });
        }
        return new CompleteResultBuilderEntityJpa(this.navigablePath, this.entityDescriptor, this.lockMode, discriminatorFetchBuilder, explicitFetchBuilderMap);
    }
}

