/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

public final class AnnotationHelper {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ValueReadHandleFactory handleFactory;
    private final Map<Class<? extends Annotation>, ValueReadHandle<Annotation[]>> containedAnnotationsHandleCache = new HashMap<Class<? extends Annotation>, ValueReadHandle<Annotation[]>>();

    public AnnotationHelper(ValueReadHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
    }

    public Stream<? extends Annotation> expandRepeatableContainingAnnotation(Annotation containingAnnotationCandidate) {
        Class<? extends Annotation> containingAnnotationCandidateType = containingAnnotationCandidate.annotationType();
        ValueReadHandle containedAnnotationsHandle = this.containedAnnotationsHandleCache.computeIfAbsent(containingAnnotationCandidateType, this::createContainedAnnotationsHandle);
        if (containedAnnotationsHandle != null) {
            try {
                Annotation[] annotationArray = (Annotation[])containedAnnotationsHandle.get(containingAnnotationCandidate);
                return Arrays.stream(annotationArray);
            }
            catch (Throwable e) {
                log.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return Stream.of(containingAnnotationCandidate);
    }

    private ValueReadHandle<Annotation[]> createContainedAnnotationsHandle(Class<? extends Annotation> containingAnnotationCandidateType) {
        Repeatable repeatable;
        Class<?> elementType;
        Method valueMethod;
        try {
            valueMethod = containingAnnotationCandidateType.getDeclaredMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        Class<?> valueMethodReturnType = valueMethod.getReturnType();
        if (valueMethodReturnType.isArray() && Annotation.class.isAssignableFrom(elementType = valueMethodReturnType.getComponentType()) && (repeatable = elementType.getAnnotation(Repeatable.class)) != null && containingAnnotationCandidateType.equals(repeatable.value())) {
            try {
                ValueReadHandle<Annotation[]> result = this.handleFactory.createForMethod(valueMethod);
                return result;
            }
            catch (IllegalAccessException e) {
                log.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return null;
    }
}

