/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;

public class LuceneGeoPointSpatialWithinBoundingBoxPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneGeoPointSpatialWithinBoundingBoxPredicate(Builder builder) {
        super(builder);
    }

    private static class Builder
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<GeoPoint>
    implements SpatialWithinBoundingBoxPredicateBuilder {
        protected GeoBoundingBox boundingBox;

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope, field);
        }

        public void boundingBox(GeoBoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public SearchPredicate build() {
            return new LuceneGeoPointSpatialWithinBoundingBoxPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            return LatLonPoint.newBoxQuery((String)this.absoluteFieldPath, (double)this.boundingBox.bottomRight().latitude(), (double)this.boundingBox.topLeft().latitude(), (double)this.boundingBox.topLeft().longitude(), (double)this.boundingBox.bottomRight().longitude());
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<SpatialWithinBoundingBoxPredicateBuilder, GeoPoint> {
        @Override
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<GeoPoint> field) {
            return new Builder(scope, field);
        }
    }
}

