/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AssociationOverrides;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.ColumnTransformers;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public abstract class AbstractPropertyHolder
implements PropertyHolder {
    private static final Logger log = CoreLogging.logger(AbstractPropertyHolder.class);
    protected AbstractPropertyHolder parent;
    private Map<String, Column[]> holderColumnOverride;
    private Map<String, Column[]> currentPropertyColumnOverride;
    private Map<String, ColumnTransformer> holderColumnTransformerOverride;
    private Map<String, ColumnTransformer> currentPropertyColumnTransformerOverride;
    private Map<String, JoinColumn[]> holderJoinColumnOverride;
    private Map<String, JoinColumn[]> currentPropertyJoinColumnOverride;
    private Map<String, JoinTable> holderJoinTableOverride;
    private Map<String, JoinTable> currentPropertyJoinTableOverride;
    private Map<String, ForeignKey> holderForeignKeyOverride;
    private Map<String, ForeignKey> currentPropertyForeignKeyOverride;
    private final String path;
    private final MetadataBuildingContext context;
    private Boolean isInIdClass;

    AbstractPropertyHolder(String path, PropertyHolder parent, XClass clazzToProcess, MetadataBuildingContext context) {
        this.path = path;
        this.parent = (AbstractPropertyHolder)parent;
        this.context = context;
        this.buildHierarchyColumnOverride(clazzToProcess);
    }

    protected abstract String normalizeCompositePathForLogging(String var1);

    protected abstract String normalizeCompositePath(String var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(XProperty var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(String var1);

    @Override
    public ConverterDescriptor resolveAttributeConverterDescriptor(XProperty property) {
        AttributeConversionInfo info = this.locateAttributeConversionInfo(property);
        if (info != null) {
            if (info.isConversionDisabled()) {
                return null;
            }
            try {
                return this.makeAttributeConverterDescriptor(info);
            }
            catch (Exception e) {
                throw this.buildExceptionFromInstantiationError(info, e);
            }
        }
        log.debugf("Attempting to locate auto-apply AttributeConverter for property [%s:%s]", (Object)this.path, (Object)property.getName());
        return this.context.getMetadataCollector().getConverterRegistry().getAttributeConverterAutoApplyHandler().findAutoApplyConverterForAttribute(property, this.context);
    }

    protected IllegalStateException buildExceptionFromInstantiationError(AttributeConversionInfo info, Exception e) {
        if (Void.TYPE.equals(info.getConverterClass())) {
            return new IllegalStateException("Unable to instantiate AttributeConverter: you left @Convert.converter to its default value void.", e);
        }
        return new IllegalStateException(String.format("Unable to instantiate AttributeConverter [%s]", info.getConverterClass().getName()), e);
    }

    protected ConverterDescriptor makeAttributeConverterDescriptor(AttributeConversionInfo conversion) {
        try {
            return new ClassBasedConverterDescriptor(conversion.getConverterClass(), false, this.context.getBootstrapContext().getClassmateContext());
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to create AttributeConverter instance", e);
        }
    }

    @Override
    public boolean isInIdClass() {
        if (this.isInIdClass != null) {
            return this.isInIdClass;
        }
        if (this.parent != null) {
            return this.parent.isInIdClass();
        }
        return false;
    }

    @Override
    public void setInIdClass(Boolean isInIdClass) {
        this.isInIdClass = isInIdClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected MetadataBuildingContext getContext() {
        return this.context;
    }

    protected void setCurrentProperty(XProperty property) {
        if (property == null) {
            this.currentPropertyColumnOverride = null;
            this.currentPropertyColumnTransformerOverride = null;
            this.currentPropertyJoinColumnOverride = null;
            this.currentPropertyJoinTableOverride = null;
            this.currentPropertyForeignKeyOverride = null;
        } else {
            this.currentPropertyColumnOverride = AbstractPropertyHolder.buildColumnOverride((XAnnotatedElement)property, this.getPath(), this.context);
            if (this.currentPropertyColumnOverride.size() == 0) {
                this.currentPropertyColumnOverride = null;
            }
            this.currentPropertyColumnTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((XAnnotatedElement)property);
            if (this.currentPropertyColumnTransformerOverride.size() == 0) {
                this.currentPropertyColumnTransformerOverride = null;
            }
            this.currentPropertyJoinColumnOverride = AbstractPropertyHolder.buildJoinColumnOverride((XAnnotatedElement)property, this.getPath());
            if (this.currentPropertyJoinColumnOverride.size() == 0) {
                this.currentPropertyJoinColumnOverride = null;
            }
            this.currentPropertyJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((XAnnotatedElement)property, this.getPath());
            if (this.currentPropertyJoinTableOverride.size() == 0) {
                this.currentPropertyJoinTableOverride = null;
            }
            this.currentPropertyForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((XAnnotatedElement)property, this.getPath());
            if (this.currentPropertyForeignKeyOverride.size() == 0) {
                this.currentPropertyForeignKeyOverride = null;
            }
        }
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        Column[] result = this.getExactOverriddenColumn(propertyName);
        if (result == null && result == null && propertyName.contains(".collection&&element.")) {
            result = this.getExactOverriddenColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    @Override
    public ColumnTransformer getOverriddenColumnTransformer(String logicalColumnName) {
        ColumnTransformer override = null;
        if (this.parent != null) {
            override = this.parent.getOverriddenColumnTransformer(logicalColumnName);
        }
        if (override == null && this.currentPropertyColumnTransformerOverride != null) {
            override = this.currentPropertyColumnTransformerOverride.get(logicalColumnName);
        }
        if (override == null && this.holderColumnTransformerOverride != null) {
            override = this.holderColumnTransformerOverride.get(logicalColumnName);
        }
        return override;
    }

    private Column[] getExactOverriddenColumn(String propertyName) {
        Column[] override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenColumn(propertyName);
        }
        if (override == null && this.currentPropertyColumnOverride != null) {
            override = this.currentPropertyColumnOverride.get(propertyName);
        }
        if (override == null && this.holderColumnOverride != null) {
            override = this.holderColumnOverride.get(propertyName);
        }
        return override;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String propertyName) {
        JoinColumn[] result = this.getExactOverriddenJoinColumn(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            result = this.getExactOverriddenJoinColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private JoinColumn[] getExactOverriddenJoinColumn(String propertyName) {
        JoinColumn[] override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenJoinColumn(propertyName);
        }
        if (override == null && this.currentPropertyJoinColumnOverride != null) {
            override = this.currentPropertyJoinColumnOverride.get(propertyName);
        }
        if (override == null && this.holderJoinColumnOverride != null) {
            override = this.holderJoinColumnOverride.get(propertyName);
        }
        return override;
    }

    @Override
    public ForeignKey getOverriddenForeignKey(String propertyName) {
        ForeignKey result = this.getExactOverriddenForeignKey(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            result = this.getExactOverriddenForeignKey(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private ForeignKey getExactOverriddenForeignKey(String propertyName) {
        ForeignKey override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenForeignKey(propertyName);
        }
        if (override == null && this.currentPropertyForeignKeyOverride != null) {
            override = this.currentPropertyForeignKeyOverride.get(propertyName);
        }
        if (override == null && this.holderForeignKeyOverride != null) {
            override = this.holderForeignKeyOverride.get(propertyName);
        }
        return override;
    }

    @Override
    public JoinTable getJoinTable(XProperty property) {
        String propertyName = StringHelper.qualify(this.getPath(), property.getName());
        JoinTable result = this.getOverriddenJoinTable(propertyName);
        if (result == null) {
            result = (JoinTable)property.getAnnotation(JoinTable.class);
        }
        return result;
    }

    public JoinTable getOverriddenJoinTable(String propertyName) {
        JoinTable result = this.getExactOverriddenJoinTable(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            result = this.getExactOverriddenJoinTable(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private JoinTable getExactOverriddenJoinTable(String propertyName) {
        JoinTable override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenJoinTable(propertyName);
        }
        if (override == null && this.currentPropertyJoinTableOverride != null) {
            override = this.currentPropertyJoinTableOverride.get(propertyName);
        }
        if (override == null && this.holderJoinTableOverride != null) {
            override = this.holderJoinTableOverride.get(propertyName);
        }
        return override;
    }

    private void buildHierarchyColumnOverride(XClass element) {
        Map<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        Map<String, ColumnTransformer> columnTransformerOverride = new HashMap<String, ColumnTransformer>();
        Map<String, JoinColumn[]> joinColumnOverride = new HashMap<String, JoinColumn[]>();
        Map<String, JoinTable> joinTableOverride = new HashMap<String, JoinTable>();
        Map<String, ForeignKey> foreignKeyOverride = new HashMap<String, ForeignKey>();
        for (XClass current = element; current != null && !this.context.getBootstrapContext().getReflectionManager().toXClass(Object.class).equals(current); current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(Entity.class) && !current.isAnnotationPresent(MappedSuperclass.class) && !current.isAnnotationPresent(Embeddable.class)) continue;
            Map<String, Column[]> currentOverride = AbstractPropertyHolder.buildColumnOverride((XAnnotatedElement)current, this.getPath(), this.context);
            Map<String, ColumnTransformer> currentTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((XAnnotatedElement)current);
            Map<String, JoinColumn[]> currentJoinOverride = AbstractPropertyHolder.buildJoinColumnOverride((XAnnotatedElement)current, this.getPath());
            Map<String, JoinTable> currentJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((XAnnotatedElement)current, this.getPath());
            Map<String, ForeignKey> currentForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((XAnnotatedElement)current, this.getPath());
            currentOverride.putAll(columnOverride);
            currentTransformerOverride.putAll(columnTransformerOverride);
            currentJoinOverride.putAll(joinColumnOverride);
            currentJoinTableOverride.putAll(joinTableOverride);
            currentForeignKeyOverride.putAll(foreignKeyOverride);
            columnOverride = currentOverride;
            columnTransformerOverride = currentTransformerOverride;
            joinColumnOverride = currentJoinOverride;
            joinTableOverride = currentJoinTableOverride;
            foreignKeyOverride = currentForeignKeyOverride;
        }
        this.holderColumnOverride = columnOverride.size() > 0 ? columnOverride : null;
        this.holderColumnTransformerOverride = columnTransformerOverride.size() > 0 ? columnTransformerOverride : null;
        this.holderJoinColumnOverride = joinColumnOverride.size() > 0 ? joinColumnOverride : null;
        this.holderJoinTableOverride = joinTableOverride.size() > 0 ? joinTableOverride : null;
        this.holderForeignKeyOverride = foreignKeyOverride.size() > 0 ? foreignKeyOverride : null;
    }

    private static Map<String, Column[]> buildColumnOverride(XAnnotatedElement element, String path, MetadataBuildingContext context) {
        HashMap<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        if (element != null) {
            AttributeOverride singleOverride = (AttributeOverride)element.getAnnotation(AttributeOverride.class);
            AttributeOverrides multipleOverrides = (AttributeOverrides)element.getAnnotation(AttributeOverrides.class);
            AttributeOverride[] overrides = singleOverride != null ? new AttributeOverride[]{singleOverride} : (multipleOverrides != null ? multipleOverrides.value() : null);
            if (overrides != null) {
                HashMap<String, ArrayList<Column>> columnOverrideList = new HashMap<String, ArrayList<Column>>();
                for (AttributeOverride depAttr : overrides) {
                    String qualifiedName = StringHelper.qualify(path, depAttr.name());
                    if (columnOverrideList.containsKey(qualifiedName)) {
                        ((List)columnOverrideList.get(qualifiedName)).add(depAttr.column());
                        continue;
                    }
                    columnOverrideList.put(qualifiedName, new ArrayList<Column>(Arrays.asList(depAttr.column())));
                }
                for (Map.Entry entry : columnOverrideList.entrySet()) {
                    columnOverride.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new Column[0]));
                }
            } else if (TimeZoneStorageHelper.useColumnForTimeZoneStorage(element, context)) {
                Column column = AbstractPropertyHolder.createTimestampColumn(element, path, context);
                columnOverride.put(path + ".instant", new Column[]{column});
                Column offsetColumn = AbstractPropertyHolder.createTimeZoneColumn(element, column);
                columnOverride.put(path + ".zoneOffset", new Column[]{offsetColumn});
            }
        }
        return columnOverride;
    }

    private static Column createTimeZoneColumn(XAnnotatedElement element, Column column) {
        TimeZoneColumn timeZoneColumn = (TimeZoneColumn)element.getAnnotation(TimeZoneColumn.class);
        if (timeZoneColumn != null) {
            return new ColumnImpl(timeZoneColumn.name(), false, column.nullable(), timeZoneColumn.insertable(), timeZoneColumn.updatable(), timeZoneColumn.columnDefinition(), timeZoneColumn.table(), 0);
        }
        return new ColumnImpl(column.name() + "_tz", false, column.nullable(), column.insertable(), column.updatable(), "", column.table(), 0);
    }

    private static Column createTimestampColumn(XAnnotatedElement element, final String path, final MetadataBuildingContext context) {
        int precision;
        Column annotatedColumn = (Column)element.getAnnotation(Column.class);
        if (annotatedColumn != null) {
            if (!annotatedColumn.name().isEmpty()) {
                return annotatedColumn;
            }
            precision = annotatedColumn.precision();
        } else {
            precision = 0;
        }
        Identifier implicitName = context.getObjectNameNormalizer().normalizeIdentifierQuoting(context.getBuildingOptions().getImplicitNamingStrategy().determineBasicColumnName(new ImplicitBasicColumnNameSource(){
            final AttributePath attributePath;
            {
                this.attributePath = AttributePath.parse(path);
            }

            @Override
            public AttributePath getAttributePath() {
                return this.attributePath;
            }

            @Override
            public boolean isCollectionElement() {
                return false;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return context;
            }
        }));
        return new ColumnImpl(implicitName.getText(), false, true, true, true, "", "", precision);
    }

    private static Map<String, ColumnTransformer> buildColumnTransformerOverride(XAnnotatedElement element) {
        HashMap<String, ColumnTransformer> columnOverride = new HashMap<String, ColumnTransformer>();
        if (element != null) {
            ColumnTransformer singleOverride = (ColumnTransformer)element.getAnnotation(ColumnTransformer.class);
            ColumnTransformers multipleOverrides = (ColumnTransformers)element.getAnnotation(ColumnTransformers.class);
            ColumnTransformer[] overrides = singleOverride != null ? new ColumnTransformer[]{singleOverride} : (multipleOverrides != null ? multipleOverrides.value() : null);
            if (overrides != null) {
                for (ColumnTransformer depAttr : overrides) {
                    columnOverride.put(depAttr.forColumn(), depAttr);
                }
            }
        }
        return columnOverride;
    }

    private static Map<String, JoinColumn[]> buildJoinColumnOverride(XAnnotatedElement element, String path) {
        AssociationOverride[] overrides;
        HashMap<String, JoinColumn[]> columnOverride = new HashMap<String, JoinColumn[]>();
        if (element != null && (overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path)) != null) {
            for (AssociationOverride depAttr : overrides) {
                columnOverride.put(StringHelper.qualify(path, depAttr.name()), depAttr.joinColumns());
            }
        }
        return columnOverride;
    }

    private static Map<String, ForeignKey> buildForeignKeyOverride(XAnnotatedElement element, String path) {
        AssociationOverride[] overrides;
        HashMap<String, ForeignKey> foreignKeyOverride = new HashMap<String, ForeignKey>();
        if (element != null && (overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path)) != null) {
            for (AssociationOverride depAttr : overrides) {
                foreignKeyOverride.put(StringHelper.qualify(path, depAttr.name()), depAttr.foreignKey());
            }
        }
        return foreignKeyOverride;
    }

    private static AssociationOverride[] buildAssociationOverrides(XAnnotatedElement element, String path) {
        AssociationOverride singleOverride = (AssociationOverride)element.getAnnotation(AssociationOverride.class);
        AssociationOverrides pluralOverrides = (AssociationOverrides)element.getAnnotation(AssociationOverrides.class);
        AssociationOverride[] overrides = singleOverride != null ? new AssociationOverride[]{singleOverride} : (pluralOverrides != null ? pluralOverrides.value() : null);
        return overrides;
    }

    private static Map<String, JoinTable> buildJoinTableOverride(XAnnotatedElement element, String path) {
        AssociationOverride[] overrides;
        HashMap<String, JoinTable> tableOverride = new HashMap<String, JoinTable>();
        if (element != null && (overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path)) != null) {
            for (AssociationOverride depAttr : overrides) {
                if (depAttr.joinColumns().length != 0) continue;
                tableOverride.put(StringHelper.qualify(path, depAttr.name()), depAttr.joinTable());
            }
        }
        return tableOverride;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        throw new AssertionFailure("Setting the parent property to a non component");
    }

    private static class ColumnImpl
    implements Column {
        private final String name;
        private final boolean unique;
        private final boolean nullable;
        private final boolean insertable;
        private final boolean updatable;
        private final String columnDefinition;
        private final String table;
        private final int precision;

        private ColumnImpl(String name, boolean unique, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, String table, int precision) {
            this.name = name;
            this.unique = unique;
            this.nullable = nullable;
            this.insertable = insertable;
            this.updatable = updatable;
            this.columnDefinition = columnDefinition;
            this.table = table;
            this.precision = precision;
        }

        public String name() {
            return this.name;
        }

        public boolean unique() {
            return this.unique;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean insertable() {
            return this.insertable;
        }

        public boolean updatable() {
            return this.updatable;
        }

        public String columnDefinition() {
            return this.columnDefinition;
        }

        public String table() {
            return this.table;
        }

        public int length() {
            return 255;
        }

        public int precision() {
            return this.precision;
        }

        public int scale() {
            return 0;
        }

        public Class<? extends Annotation> annotationType() {
            return Column.class;
        }
    }
}

