/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.ColumnOrderingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedType;

public class ColumnOrderingStrategyStandard
implements ColumnOrderingStrategy {
    public static final ColumnOrderingStrategyStandard INSTANCE = new ColumnOrderingStrategyStandard();
    private static final double DECIMAL_TO_BYTES_QUOTIENT = Math.log(10.0) / Math.log(2.0) * 8.0;

    @Override
    public List<Column> orderTableColumns(Table table, Metadata metadata) {
        return this.orderColumns(table.getColumns(), metadata);
    }

    @Override
    public List<Column> orderUserDefinedTypeColumns(UserDefinedType userDefinedType, Metadata metadata) {
        return this.orderColumns(userDefinedType.getColumns(), metadata);
    }

    @Override
    public List<Column> orderConstraintColumns(Constraint constraint, Metadata metadata) {
        return this.orderColumns(constraint.getColumns(), metadata);
    }

    @Override
    public void orderTemporaryTableColumns(List<TemporaryTableColumn> temporaryTableColumns, Metadata metadata) {
        temporaryTableColumns.sort(new TemporaryTableColumnComparator(metadata));
    }

    protected List<Column> orderColumns(Collection<Column> columns, Metadata metadata) {
        ArrayList<Column> orderedColumns = new ArrayList<Column>(columns);
        orderedColumns.sort(new ColumnComparator(metadata));
        return orderedColumns;
    }

    protected static int physicalSizeInBytes(int sqlTypeCode, Size columnSize, Metadata metadata) {
        switch (sqlTypeCode) {
            case -7: 
            case -6: 
            case 16: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                if (columnSize.getPrecision() != null) {
                    return (int)Math.ceil((double)columnSize.getPrecision().intValue() / DECIMAL_TO_BYTES_QUOTIENT);
                }
            }
            case 4: 
            case 7: {
                return 4;
            }
            case -5: 
            case 8: {
                return 8;
            }
            case 2: 
            case 3: {
                int precision = columnSize.getPrecision() == null ? metadata.getDatabase().getDialect().getDefaultDecimalPrecision() : columnSize.getPrecision().intValue();
                return (int)Math.ceil((double)precision / DECIMAL_TO_BYTES_QUOTIENT);
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 4001: {
                long length = columnSize.getLength() == null ? 255L : columnSize.getLength();
                if (length == 255L) {
                    return metadata.getDatabase().getDialect().getMaxVarcharLength();
                }
                return (int)length;
            }
            case -16: 
            case 4002: {
                long length = columnSize.getLength() == null ? 255L : columnSize.getLength();
                if (length == 255L) {
                    return metadata.getDatabase().getDialect().getMaxNVarcharLength();
                }
                return (int)length;
            }
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                long length = columnSize.getLength() == null ? 255L : columnSize.getLength();
                if (length == 255L) {
                    return metadata.getDatabase().getDialect().getMaxVarbinaryLength();
                }
                return (int)length;
            }
            case 91: 
            case 92: 
            case 2013: {
                return 4;
            }
            case 93: 
            case 2014: 
            case 3003: 
            case 3100: {
                return 8;
            }
            case 3000: {
                return 16;
            }
            case 3002: {
                return 19;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected static class TemporaryTableColumnComparator
    implements Comparator<TemporaryTableColumn> {
        private final Metadata metadata;

        protected TemporaryTableColumnComparator(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int compare(TemporaryTableColumn o1, TemporaryTableColumn o2) {
            int physicalSizeInBytes1 = ColumnOrderingStrategyStandard.physicalSizeInBytes(o1.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode(), o1.getSize(), this.metadata);
            int physicalSizeInBytes2 = ColumnOrderingStrategyStandard.physicalSizeInBytes(o2.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode(), o2.getSize(), this.metadata);
            int cmp = Integer.compare(Integer.max(physicalSizeInBytes1, 4), Integer.max(physicalSizeInBytes2, 4));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Boolean.compare(physicalSizeInBytes1 > 2048, physicalSizeInBytes2 > 2048);
            if (cmp != 0) {
                return cmp;
            }
            return o1.getColumnName().compareTo(o2.getColumnName());
        }
    }

    protected static class ColumnComparator
    implements Comparator<Column> {
        private final Metadata metadata;

        protected ColumnComparator(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int compare(Column o1, Column o2) {
            Dialect dialect = this.metadata.getDatabase().getDialect();
            int physicalSizeInBytes1 = ColumnOrderingStrategyStandard.physicalSizeInBytes(o1.getSqlTypeCode(this.metadata), o1.getColumnSize(dialect, this.metadata), this.metadata);
            int physicalSizeInBytes2 = ColumnOrderingStrategyStandard.physicalSizeInBytes(o2.getSqlTypeCode(this.metadata), o2.getColumnSize(dialect, this.metadata), this.metadata);
            int cmp = Integer.compare(Integer.max(physicalSizeInBytes1, 4), Integer.max(physicalSizeInBytes2, 4));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Boolean.compare(physicalSizeInBytes1 > 2048, physicalSizeInBytes2 > 2048);
            if (cmp != 0) {
                return cmp;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

