/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.BindableType;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicTypeReference;

public class JdbcParameterBindingsImpl
implements JdbcParameterBindings {
    private Map<JdbcParameter, JdbcParameterBinding> bindingMap;

    public JdbcParameterBindingsImpl(int expectedParameterCount) {
        if (expectedParameterCount > 0) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>(expectedParameterCount);
        }
    }

    public JdbcParameterBindingsImpl(QueryParameterBindings queryParameterBindings, List<ParameterOccurrence> parameterOccurrences, List<JdbcParameterBinder> jdbcParameterBinders, SessionFactoryImplementor factory) {
        if (!parameterOccurrences.isEmpty()) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>(parameterOccurrences.size());
            Dialect dialect = factory.getJdbcServices().getDialect();
            boolean paddingEnabled = factory.getSessionFactoryOptions().inClauseParameterPaddingEnabled();
            int inExprLimit = dialect.getInExpressionCountLimit();
            for (ParameterOccurrence occurrence : parameterOccurrences) {
                JdbcMapping jdbcMapping;
                QueryParameterBinding<?> binding;
                QueryParameterImplementor<?> param = occurrence.getParameter();
                BindableType<?> type = this.determineParamType(param, binding = queryParameterBindings.getBinding(param));
                if (type == null) {
                    jdbcMapping = factory.getTypeConfiguration().getBasicTypeForJavaType(Object.class);
                } else if (type instanceof BasicTypeReference) {
                    jdbcMapping = factory.getTypeConfiguration().getBasicTypeRegistry().resolve((BasicTypeReference)type);
                } else if (type instanceof BasicValuedMapping) {
                    jdbcMapping = ((BasicValuedMapping)((Object)type)).getJdbcMapping();
                } else {
                    throw new IllegalArgumentException("Could not resolve NativeQuery parameter type : `" + param + "`");
                }
                if (binding.isMultiValued()) {
                    JdbcParameterImpl jdbcParameter;
                    Collection<?> bindValues = binding.getBindValues();
                    int bindValueCount = bindValues.size();
                    Object lastBindValue = null;
                    for (Object bindValue : bindValues) {
                        jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                        jdbcParameterBinders.add(jdbcParameter);
                        this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, bindValue));
                        lastBindValue = bindValue;
                    }
                    int bindValueMaxCount = NativeQueryImpl.determineBindValueMaxCount(paddingEnabled, inExprLimit, bindValueCount);
                    if (bindValueMaxCount == bindValueCount) continue;
                    for (int i = bindValueCount; i < bindValueMaxCount; ++i) {
                        jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                        jdbcParameterBinders.add(jdbcParameter);
                        this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, lastBindValue));
                    }
                    continue;
                }
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, binding.getBindValue()));
            }
        }
    }

    private BindableType<?> determineParamType(QueryParameterImplementor<?> param, QueryParameterBinding<?> binding) {
        BindableType<Object> type = binding.getBindType();
        if (type == null) {
            type = param.getHibernateType();
        }
        return type;
    }

    @Override
    public void addBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.bindingMap == null) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        this.bindingMap.put(parameter, binding);
    }

    @Override
    public Collection<JdbcParameterBinding> getBindings() {
        return this.bindingMap == null ? Collections.emptyList() : this.bindingMap.values();
    }

    @Override
    public JdbcParameterBinding getBinding(JdbcParameter parameter) {
        if (this.bindingMap == null) {
            return null;
        }
        return this.bindingMap.get(parameter);
    }

    @Override
    public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> action) {
        if (this.bindingMap == null) {
            return;
        }
        for (Map.Entry<JdbcParameter, JdbcParameterBinding> entry : this.bindingMap.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        if (this.bindingMap != null) {
            this.bindingMap.clear();
        }
    }
}

