/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxPollingAgentAdditionalJaxbMappingProducer
implements HibernateSearchOrmMappingProducer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String HIBERNATE_SEARCH = "hibernate-search";
    public static final String HSEARCH_PREFIX = "HSEARCH_";
    public static final String TABLE_NAME = "HSEARCH_AGENT";
    private static final String CLASS_NAME;
    public static final String ENTITY_NAME;
    public static final String ENTITY_DEFINITION;
    private static final ConfigurationProperty<String> AGENT_ENTITY_MAPPING;

    @SuppressForbiddenApis(reason="Strangely, this SPI involves the internal MappingBinder class, and there's nothing we can do about it")
    public Collection<MappingDocument> produceMappings(ConfigurationPropertySource propertySource, MappingBinder mappingBinder, MetadataBuildingContext buildingContext) {
        String entityDefinition = (String)AGENT_ENTITY_MAPPING.get(propertySource);
        log.agentGeneratedEntityMapping(entityDefinition);
        Origin origin = new Origin(SourceType.OTHER, "search");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(entityDefinition.getBytes());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        Binding binding = mappingBinder.bind((InputStream)bufferedInputStream, origin);
        JaxbHbmHibernateMapping root = (JaxbHbmHibernateMapping)binding.getRoot();
        MappingDocument mappingDocument = new MappingDocument(HIBERNATE_SEARCH, root, origin, buildingContext);
        return Collections.singletonList(mappingDocument);
    }

    static {
        ENTITY_NAME = CLASS_NAME = Agent.class.getName();
        ENTITY_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<hibernate-mapping>\n    <class name=\"" + CLASS_NAME + "\" entity-name=\"" + ENTITY_NAME + "\" table=\"" + TABLE_NAME + "\">\n        <id name=\"id\">\n            <generator class=\"org.hibernate.id.enhanced.SequenceStyleGenerator\">\n                <param name=\"sequence_name\">" + TABLE_NAME + "_GENERATOR</param>\n                <param name=\"table_name\">" + TABLE_NAME + "_GENERATOR</param>\n                <param name=\"initial_value\">1</param>\n                <param name=\"increment_size\">1</param>\n            </generator>\n        </id>\n        <property name=\"type\" nullable=\"false\">\n            <type name=\"org.hibernate.type.EnumType\">\n                <param name=\"enumClass\">" + AgentType.class.getName() + "</param>\n            </type>\n        </property>\n        <property name=\"name\" nullable=\"false\" />\n        <property name=\"expiration\" nullable=\"false\" />\n        <property name=\"state\" nullable=\"false\">\n            <type name=\"org.hibernate.type.EnumType\">\n                <param name=\"enumClass\">" + AgentState.class.getName() + "</param>\n            </type>\n        </property>\n        <property name=\"totalShardCount\" nullable=\"true\" />\n        <property name=\"assignedShardIndex\" nullable=\"true\" />\n        <property name=\"payload\" nullable=\"true\" type=\"materialized_blob\">\n                <column length=\"2147483647\" />\n        </property>\n    </class>\n</hibernate-mapping>\n";
        AGENT_ENTITY_MAPPING = ConfigurationProperty.forKey((String)"agent.entity.mapping").asString().withDefault((Object)ENTITY_DEFINITION).build();
    }
}

