/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.NoOpDocumentRouter;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.RoutingBridgeDocumentRouter;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoRootIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.AbstractPojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedTypeManagerBuilder<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String entityName;
    private final PojoRawTypeModel<E> typeModel;
    private final MappedIndexManagerBuilder indexManagerBuilder;
    private final PojoIndexedTypeExtendedMappingCollector extendedMappingCollector;
    private final PojoRootIdentityMappingCollector<E> identityMappingCollector;
    private final BoundRoutingBridge<E> routingBridge;
    private final PojoIndexingProcessorOriginalTypeNodeBuilder<E> processorBuilder;
    private PojoIndexingProcessor<E> preBuiltIndexingProcessor;
    private boolean closed = false;

    PojoIndexedTypeManagerBuilder(String entityName, PojoRawTypeModel<E> typeModel, PojoMappingHelper mappingHelper, MappedIndexManagerBuilder indexManagerBuilder, PojoIndexedTypeExtendedMappingCollector extendedMappingCollector, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, BoundRoutingBridge<E> routingBridge, BeanResolver beanResolver) {
        this.entityName = entityName;
        this.typeModel = typeModel;
        this.indexManagerBuilder = indexManagerBuilder;
        this.extendedMappingCollector = extendedMappingCollector;
        this.identityMappingCollector = new PojoRootIdentityMappingCollector<E>(typeModel, mappingHelper, Optional.of(indexManagerBuilder.rootBindingContext()), providedIdentifierBridge, beanResolver);
        this.routingBridge = routingBridge;
        this.processorBuilder = new PojoIndexingProcessorOriginalTypeNodeBuilder<E>(BoundPojoModelPath.root(typeModel), mappingHelper, (IndexBindingContext)indexManagerBuilder.rootBindingContext(), this.identityMappingCollector, Collections.emptyList());
    }

    void closeOnFailure() {
        if (this.closed) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(AbstractPojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.processorBuilder);
            closer.push(PojoRootIdentityMappingCollector::closeOnFailure, this.identityMappingCollector);
            closer.push(RoutingBridge::close, this.routingBridge, BoundRoutingBridge::getBridge);
            closer.push(BeanHolder::close, this.routingBridge, BoundRoutingBridge::getBridgeHolder);
            closer.push(PojoIndexingProcessor::close, this.preBuiltIndexingProcessor);
            this.closed = true;
        }
    }

    PojoMappingCollectorTypeNode asCollector() {
        return this.processorBuilder;
    }

    void preBuild(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor != null) {
            throw new AssertionFailure("Internal error - preBuild should be called only once");
        }
        PojoIndexingDependencyCollectorTypeNode<E> dependencyCollector = reindexingResolverBuildingHelper.createDependencyCollector(this.typeModel);
        if (this.routingBridge != null) {
            this.routingBridge.contributeDependencies(dependencyCollector);
        }
        this.preBuiltIndexingProcessor = this.processorBuilder.build(dependencyCollector).orElseGet(PojoIndexingProcessor::noOp);
    }

    void buildAndAddTo(PojoIndexedTypeManagerContainer.Builder typeManagersBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor == null) {
            throw new AssertionFailure("Internal error - preBuild should be called before buildAndAddTo");
        }
        IdentifierMappingImplementor<?, E> identifierMapping = this.identityMappingCollector.buildAndContributeTo(this.extendedMappingCollector, IdentityMappingMode.REQUIRED);
        PojoImplicitReindexingResolver<E> reindexingResolver = reindexingResolverBuildingHelper.build(this.typeModel);
        this.extendedMappingCollector.dirtyFilter(reindexingResolver.dirtySelfOrContainingFilter());
        this.extendedMappingCollector.dirtyContainingAssociationFilter(reindexingResolver.associationInverseSideResolver().dirtyContainingAssociationFilter());
        MappedIndexManager indexManager = this.indexManagerBuilder.build();
        this.extendedMappingCollector.indexManager(indexManager);
        PojoIndexedTypeManager typeManager = new PojoIndexedTypeManager(this.entityName, this.typeModel.typeIdentifier(), this.typeModel.caster(), reindexingResolverBuildingHelper.isSingleConcreteTypeInEntityHierarchy(this.typeModel), identifierMapping, this.routingBridge == null ? NoOpDocumentRouter.INSTANCE : new RoutingBridgeDocumentRouter<E>(this.routingBridge.getBridgeHolder()), reindexingResolverBuildingHelper.runtimePathsBuildingHelper(this.typeModel).pathOrdinals(), this.preBuiltIndexingProcessor, indexManager, reindexingResolver);
        log.indexedTypeManager(this.typeModel, typeManager);
        typeManagersBuilder.add(this.typeModel, typeManager);
        this.closed = true;
    }
}

