/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path;

import java.util.Objects;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.util.common.impl.Contracts;

public final class PojoModelPathPropertyNode
extends PojoModelPath {
    private final PojoModelPathValueNode parent;
    private final String propertyName;

    PojoModelPathPropertyNode(PojoModelPathValueNode parent, String propertyName) {
        this.parent = parent;
        Contracts.assertNotNullNorEmpty((String)propertyName, (String)"propertyName");
        this.propertyName = propertyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoModelPathPropertyNode that = (PojoModelPathPropertyNode)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.propertyName, that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.propertyName);
    }

    @Override
    public PojoModelPathValueNode parent() {
        return this.parent;
    }

    public PojoModelPathValueNode value(ContainerExtractorPath extractorPath) {
        return new PojoModelPathValueNode(this, extractorPath);
    }

    public String propertyName() {
        return this.propertyName;
    }

    public String toPropertyString() {
        StringBuilder builder = new StringBuilder();
        PojoModelPathPropertyNode.addPropertyPathsRecursively(builder, this);
        return builder.toString();
    }

    public Optional<PojoModelPathPropertyNode> relativize(PojoModelPathValueNode other) {
        if (this.parent == null) {
            return Optional.empty();
        }
        if (other.equals(this.parent)) {
            return Optional.of(new PojoModelPathPropertyNode(null, this.propertyName));
        }
        return this.parent.relativize(other).map(newParent -> new PojoModelPathPropertyNode((PojoModelPathValueNode)newParent, this.propertyName));
    }

    @Override
    void appendSelfPath(StringBuilder builder) {
        builder.append(".").append(this.propertyName);
    }

    private static void addPropertyPathsRecursively(StringBuilder builder, PojoModelPathPropertyNode propertyNode) {
        PojoModelPathValueNode parentValueNode = propertyNode.parent();
        if (parentValueNode != null) {
            PojoModelPathPropertyNode.addPropertyPathsRecursively(builder, parentValueNode.parent());
            builder.append('.');
        }
        builder.append(propertyNode.propertyName());
    }
}

