/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import io.micrometer.core.instrument.Meter;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;
import org.wildfly.extension.micrometer.metrics.WildFlyMetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

public class MetricRegistration {
    private final List<Runnable> registrationTasks = new ArrayList<Runnable>();
    private final List<Meter.Id> unregistrationTasks = new ArrayList<Meter.Id>();
    private final WildFlyRegistry registry;

    public MetricRegistration(WildFlyRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        WildFlyRegistry wildFlyRegistry = this.registry;
        synchronized (wildFlyRegistry) {
            this.registrationTasks.forEach(t -> t.run());
            this.registrationTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        WildFlyRegistry wildFlyRegistry = this.registry;
        synchronized (wildFlyRegistry) {
            this.unregistrationTasks.forEach(id -> this.registry.remove((Meter.Id)id));
            this.unregistrationTasks.clear();
        }
    }

    public void registerMetric(WildFlyMetric metric, WildFlyMetricMetadata metadata) {
        this.unregistrationTasks.add(this.registry.addMeter(metric, metadata));
    }

    public synchronized void addRegistrationTask(Runnable task) {
        this.registrationTasks.add(task);
    }
}

