/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;

public final class LeafValidators {
    private static final double DEFAULT_DOUBLE_DELTA = 0.001;
    private static final float DEFAULT_FLOAT_DELTA = 0.001f;
    public static final LeafValidator<Object> EQUAL = new LeafValidator<Object>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, Object defaultedExpected, Object defaultedActual, Object actual) {
            if (!Objects.equals(defaultedExpected, defaultedActual)) {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(defaultedExpected, actual));
            }
        }
    };
    public static final LeafValidator<Double> EQUAL_DOUBLE = new LeafValidator<Double>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, Double defaultedExpected, Double defaultedActual, Object actual) {
            if (defaultedExpected == null || defaultedActual == null || Double.compare(defaultedExpected, defaultedActual) != 0 && Math.abs(defaultedExpected - defaultedActual) > 0.001) {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(defaultedExpected, actual));
            }
        }
    };
    public static final LeafValidator<Float> EQUAL_FLOAT = new LeafValidator<Float>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, Float defaultedExpected, Float defaultedActual, Object actual) {
            if (defaultedExpected == null || defaultedActual == null || Float.compare(defaultedExpected.floatValue(), defaultedActual.floatValue()) != 0 && Math.abs(defaultedExpected.floatValue() - defaultedActual.floatValue()) > 0.001f) {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(defaultedExpected, actual));
            }
        }
    };
    public static final LeafValidator<List<String>> FORMAT = new LeafValidator<List<String>>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, List<String> defaultedExpected, List<String> defaultedActual, Object actual) {
            String actualOutputFormat;
            if (defaultedExpected.isEmpty()) {
                return;
            }
            String expectedOutputFormat = defaultedExpected.get(0);
            String string = actualOutputFormat = defaultedActual.isEmpty() ? null : defaultedActual.get(0);
            if (!Objects.equals(expectedOutputFormat, actualOutputFormat)) {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidOutputFormat(expectedOutputFormat, actualOutputFormat));
            }
            ArrayList<String> missingFormats = new ArrayList<String>(defaultedExpected);
            missingFormats.removeAll(defaultedActual);
            ArrayList<String> unexpectedFormats = new ArrayList<String>(defaultedActual);
            unexpectedFormats.removeAll(defaultedExpected);
            if (!missingFormats.isEmpty() || !unexpectedFormats.isEmpty()) {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidFormat(defaultedExpected, defaultedActual, missingFormats, unexpectedFormats));
            }
        }
    };
    private static final LeafValidator<JsonElement> JSON_ELEMENT_AS_DOUBLE_LEAF_VALIDATOR = new LeafValidator<JsonElement>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, JsonElement defaultedExpected, JsonElement defaultedActual, Object actual) {
            if (LeafValidators.areNumbers(defaultedExpected, defaultedActual)) {
                EQUAL_DOUBLE.doValidate(errorCollector, defaultedExpected.getAsDouble(), defaultedActual.getAsDouble(), actual);
            } else {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(defaultedExpected, actual));
            }
        }
    };
    private static final LeafValidator<JsonElement> JSON_ELEMENT_AS_FLOAT_LEAF_VALIDATOR = new LeafValidator<JsonElement>(){

        @Override
        protected void doValidate(ValidationErrorCollector errorCollector, JsonElement defaultedExpected, JsonElement defaultedActual, Object actual) {
            if (LeafValidators.areNumbers(defaultedExpected, defaultedActual)) {
                EQUAL_FLOAT.doValidate(errorCollector, Float.valueOf(defaultedExpected.getAsFloat()), Float.valueOf(defaultedActual.getAsFloat()), actual);
            } else {
                errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(defaultedExpected, actual));
            }
        }
    };

    private LeafValidators() {
    }

    public static LeafValidator<? super JsonElement> jsonElement(String type) {
        String defaultedType;
        switch (defaultedType = type == null ? "object" : type) {
            case "double": {
                return JSON_ELEMENT_AS_DOUBLE_LEAF_VALIDATOR;
            }
            case "float": {
                return JSON_ELEMENT_AS_FLOAT_LEAF_VALIDATOR;
            }
        }
        return EQUAL;
    }

    private static boolean areNumbers(JsonElement expectedValue, JsonElement actualValue) {
        if (!(expectedValue instanceof JsonPrimitive) || !(actualValue instanceof JsonPrimitive)) {
            return false;
        }
        return ((JsonPrimitive)expectedValue).isNumber() && ((JsonPrimitive)actualValue).isNumber();
    }
}

