/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.AbstractServerGroupRolloutTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.wildfly.security.auth.server.SecurityIdentity;

class ConcurrentServerGroupUpdateTask
extends AbstractServerGroupRolloutTask
implements Runnable {
    public ConcurrentServerGroupUpdateTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, SecurityIdentity securityIdentity, InetAddress sourceAddress, BlockingTimeout blockingTimeout) {
        super(tasks, updatePolicy, executor, securityIdentity, sourceAddress, blockingTimeout);
    }

    @Override
    public void execute() {
        HashMap<ServerIdentity, ServerUpdateTask> outstanding = new HashMap<ServerIdentity, ServerUpdateTask>();
        ServerTaskExecutor.ServerOperationListener listener = new ServerTaskExecutor.ServerOperationListener();
        int preparedTimeout = 0;
        for (ServerUpdateTask task : this.tasks) {
            ServerIdentity identity = task.getServerIdentity();
            if (this.updatePolicy.canUpdateServer(identity) && !Thread.currentThread().isInterrupted()) {
                int serverTimeout = this.executor.executeTask((TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation>)listener, task);
                if (serverTimeout <= -1) continue;
                outstanding.put(task.getServerIdentity(), task);
                if (serverTimeout <= preparedTimeout) continue;
                preparedTimeout = serverTimeout;
                continue;
            }
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Skipping server update task for %s", identity);
        }
        boolean interrupted = false;
        long deadline = System.currentTimeMillis() + (long)preparedTimeout;
        long remaining = preparedTimeout;
        while (!interrupted && !outstanding.isEmpty() && remaining > 0L) {
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation(remaining, TimeUnit.MILLISECONDS);
                if (prepared == null) break;
                ServerIdentity identity = ((ServerTaskExecutor.ServerOperation)prepared.getOperation()).getIdentity();
                this.recordPreparedOperation(identity, (TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation>)prepared);
                outstanding.remove(identity);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            remaining = deadline - System.currentTimeMillis();
        }
        if (!outstanding.isEmpty()) {
            if (interrupted) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingPreparedResponse(this.getClass().getSimpleName(), outstanding.keySet());
            } else {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.timedOutAwaitingPreparedResponse(this.getClass().getSimpleName(), preparedTimeout, outstanding.keySet());
            }
            for (Map.Entry entry : outstanding.entrySet()) {
                ServerIdentity identity = (ServerIdentity)entry.getKey();
                this.executor.cancelTask(identity);
                if (interrupted) continue;
                this.handlePreparePhaseTimeout(identity, (ServerUpdateTask)entry.getValue(), preparedTimeout);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

