/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.util.Map;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.DiffBase;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonPatchBuilderImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonPointerUtil;
import org.apache.activemq.artemis.commons.shaded.json.JsonArray;
import org.apache.activemq.artemis.commons.shaded.json.JsonObject;
import org.apache.activemq.artemis.commons.shaded.json.JsonPatch;
import org.apache.activemq.artemis.commons.shaded.json.JsonPatchBuilder;
import org.apache.activemq.artemis.commons.shaded.json.JsonStructure;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;
import org.apache.activemq.artemis.commons.shaded.json.spi.JsonProvider;

class JsonPatchDiff
extends DiffBase {
    private final JsonProvider provider;
    private final JsonStructure source;
    private final JsonStructure target;

    JsonPatchDiff(JsonProvider provider, JsonStructure source, JsonStructure target) {
        this.provider = provider;
        this.source = source;
        this.target = target;
    }

    JsonPatch calculateDiff() {
        JsonPatchBuilderImpl patchBuilder = new JsonPatchBuilderImpl(this.provider);
        this.diff(patchBuilder, "", this.source, this.target);
        return patchBuilder.build();
    }

    private void diff(JsonPatchBuilder patchBuilder, String basePath, JsonValue source, JsonValue target) {
        if (this.isJsonObject(source) && this.isJsonObject(target)) {
            this.diffJsonObjects(patchBuilder, basePath + "/", (JsonObject)source, (JsonObject)target);
        } else if (this.isJsonArray(source) && this.isJsonArray(target)) {
            this.diffJsonArray(patchBuilder, basePath + "/", (JsonArray)source, (JsonArray)target);
        } else if (!source.equals(target)) {
            patchBuilder.replace(basePath, target);
        }
    }

    private void diffJsonArray(JsonPatchBuilder patchBuilder, String basePath, JsonArray source, JsonArray target) {
        int i;
        for (i = 0; i < source.size(); ++i) {
            JsonValue sourceValue = (JsonValue)source.get(i);
            if (target.size() <= i) {
                patchBuilder.remove(basePath + i);
                continue;
            }
            this.diff(patchBuilder, basePath + i, sourceValue, (JsonValue)target.get(i));
        }
        if (target.size() > source.size()) {
            for (i = source.size(); i < target.size(); ++i) {
                patchBuilder.add(basePath + i, (JsonValue)target.get(i));
            }
        }
    }

    private void diffJsonObjects(JsonPatchBuilder patchBuilder, String basePath, JsonObject source, JsonObject target) {
        for (Map.Entry sourceEntry : source.entrySet()) {
            String attributeName = (String)sourceEntry.getKey();
            if (target.containsKey(attributeName)) {
                this.diff(patchBuilder, basePath + JsonPointerUtil.encode(attributeName), (JsonValue)sourceEntry.getValue(), (JsonValue)target.get(attributeName));
                continue;
            }
            patchBuilder.remove(basePath + JsonPointerUtil.encode(attributeName));
        }
        for (Map.Entry targetEntry : target.entrySet()) {
            if (source.containsKey(targetEntry.getKey())) continue;
            patchBuilder.add(basePath + JsonPointerUtil.encode((String)targetEntry.getKey()), (JsonValue)targetEntry.getValue());
        }
    }
}

