/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelRequestHandler;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.output.LoggingFilterOutputStream;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.StandardEnvironment;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.AsyncDataReceiver;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSessionAware;
import org.apache.sshd.server.channel.PipeDataReceiver;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.command.AsyncCommandInputStreamAware;
import org.apache.sshd.server.command.AsyncCommandStreamsAware;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ChannelSession
extends AbstractServerChannel {
    public static final List<ChannelRequestHandler> DEFAULT_HANDLERS = Collections.singletonList(PuttyRequestHandler.INSTANCE);
    protected String type;
    protected ChannelAsyncOutputStream asyncOut;
    protected ChannelAsyncOutputStream asyncErr;
    protected OutputStream out;
    protected OutputStream err;
    protected Command commandInstance;
    protected ChannelDataReceiver receiver;
    protected ChannelDataReceiver extendedDataWriter;
    protected Buffer receiverBuffer;
    protected Buffer extendedDataBuffer;
    protected final AtomicBoolean commandStarted = new AtomicBoolean(false);
    protected final StandardEnvironment env = new StandardEnvironment();
    protected final CloseFuture commandExitFuture = new DefaultCloseFuture((Object)this.getClass().getSimpleName(), this.futureLock);

    public ChannelSession() {
        this(DEFAULT_HANDLERS);
    }

    public ChannelSession(Collection<? extends RequestHandler<Channel>> handlers) {
        super("", handlers, null);
    }

    @Override
    public ServerSession getSession() {
        return (ServerSession)super.getSession();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) throws IOException {
        super.handleWindowAdjust(buffer);
        if (this.asyncOut != null) {
            this.asyncOut.onWindowExpanded();
        }
    }

    @Override
    protected boolean mayWrite() {
        if (this.asyncOut == null) {
            return super.mayWrite();
        }
        return !this.isClosed();
    }

    @Override
    protected org.apache.sshd.common.Closeable getInnerCloseable() {
        return this.builder().close((org.apache.sshd.common.Closeable)new CommandCloseable()).parallel(new org.apache.sshd.common.Closeable[]{this.asyncOut, this.asyncErr}).close(super.getInnerCloseable()).run((Object)this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        IOException e;
        if (this.commandInstance != null) {
            try {
                this.commandInstance.destroy(this);
            }
            catch (Throwable e2) {
                this.warn("doCloseImmediately({}) failed ({}) to destroy command: {}", this, e2.getClass().getSimpleName(), e2.getMessage(), e2);
            }
            finally {
                this.commandInstance = null;
            }
        }
        if ((e = IoUtils.closeQuietly((Closeable[])new Closeable[]{this.getRemoteWindow(), this.out, this.err, this.receiver, this.extendedDataWriter})) != null) {
            this.debug("doCloseImmediately({}) failed ({}) to close resources: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        IOException e = IoUtils.closeQuietly((Closeable[])new Closeable[]{this.receiver, this.extendedDataWriter});
        if (e != null) {
            this.debug("handleEof({}) failed ({}) to close receiver(s): {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    @Override
    protected void doWriteData(byte[] data, int off, long len) throws IOException {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        int reqLen = (int)len;
        if (this.receiver != null) {
            int r = this.receiver.data(this, data, off, reqLen);
            if (r > 0) {
                LocalWindow wLocal = this.getLocalWindow();
                wLocal.release(r);
            }
        } else {
            ValidateUtils.checkTrue((len <= 0x7FFFFFBFL ? 1 : 0) != 0, (String)"Temporary data length exceeds int boundaries: %d", (long)len);
            if (this.receiverBuffer == null) {
                this.receiverBuffer = new ByteArrayBuffer(reqLen + 64, false);
            }
            this.receiverBuffer.putRawBytes(data, off, reqLen);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        int maxBufSize;
        int reqSize;
        ValidateUtils.checkTrue((len <= 0x7FFFFFBFL ? 1 : 0) != 0, (String)"Extended data length exceeds int boundaries: %d", (long)len);
        if (this.extendedDataWriter != null) {
            this.extendedDataWriter.data(this, data, off, (int)len);
            return;
        }
        int curBufSize = this.extendedDataBuffer == null ? 0 : this.extendedDataBuffer.available();
        int totalSize = curBufSize + (reqSize = (int)len);
        if (totalSize > (maxBufSize = ((Integer)CoreModuleProperties.MAX_EXTDATA_BUFSIZE.getRequired((PropertyResolver)this)).intValue())) {
            if (curBufSize <= 0 && maxBufSize <= 0) {
                throw new UnsupportedOperationException("Session channel does not support extended data");
            }
            throw new IndexOutOfBoundsException("Extended data buffer size (" + maxBufSize + ") exceeded");
        }
        if (this.extendedDataBuffer == null) {
            this.extendedDataBuffer = new ByteArrayBuffer(totalSize + 64, false);
        }
        this.extendedDataBuffer.putRawBytes(data, off, reqSize);
    }

    @Override
    protected RequestHandler.Result handleInternalRequest(String requestType, boolean wantReply, Buffer buffer) throws IOException {
        switch (requestType) {
            case "env": {
                return this.handleEnv(buffer, wantReply);
            }
            case "pty-req": {
                return this.handlePtyReq(buffer, wantReply);
            }
            case "window-change": {
                return this.handleWindowChange(buffer, wantReply);
            }
            case "signal": {
                return this.handleSignal(buffer, wantReply);
            }
            case "break": {
                return this.handleBreak(buffer, wantReply);
            }
            case "shell": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleShell(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "exec": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleExec(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "subsystem": {
                if (this.type == null) {
                    RequestHandler.Result r = this.handleSubsystem(requestType, buffer, wantReply);
                    if (RequestHandler.Result.ReplySuccess.equals((Object)r) || RequestHandler.Result.Replied.equals((Object)r)) {
                        this.type = requestType;
                    }
                    return r;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, wantReply, requestType, this.type});
                }
                return RequestHandler.Result.ReplyFailure;
            }
            case "auth-agent-req": 
            case "auth-agent-req@openssh.com": {
                return this.handleAgentForwarding(requestType, buffer, wantReply);
            }
            case "x11-req": {
                return this.handleX11Forwarding(requestType, buffer, wantReply);
            }
        }
        return super.handleInternalRequest(requestType, wantReply, buffer);
    }

    @Override
    protected IoWriteFuture sendResponse(Buffer buffer, String req, RequestHandler.Result result, boolean wantReply) throws IOException {
        IoWriteFuture future = super.sendResponse(buffer, req, result, wantReply);
        if (!RequestHandler.Result.ReplySuccess.equals((Object)result)) {
            return future;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} no pending command", (Object)this, (Object)req);
            }
            return future;
        }
        if (!Objects.equals(this.type, req)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} mismatched channel type: {}", new Object[]{this, req, this.type});
            }
            return future;
        }
        if (this.commandStarted.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} pending command already started", (Object)this, (Object)req);
            }
            return future;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) request={} activate command", (Object)this, (Object)req);
        }
        this.commandInstance.start(this, this.getEnvironment());
        return future;
    }

    protected RequestHandler.Result handleEnv(Buffer buffer, boolean wantReply) throws IOException {
        String name = buffer.getString();
        String value = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleEnv({}): {} = {}", new Object[]{this, name, value});
        }
        return this.handleEnvParsed(name, value);
    }

    protected RequestHandler.Result handleEnvParsed(String name, String value) throws IOException {
        this.addEnvVariable(name, value);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handlePtyReq(Buffer buffer, boolean wantReply) throws IOException {
        String term = buffer.getString();
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        byte[] modes = buffer.getBytes();
        HashMap<PtyMode, Integer> ptyModes = new HashMap<PtyMode, Integer>();
        int i = 0;
        while (i < modes.length && modes[i] != 0) {
            int opcode;
            if ((opcode = modes[i++] & 0xFF) >= 160 && opcode <= 255) {
                this.log.warn("handlePtyReq({}) unknown reserved pty opcode value: {}", (Object)this, (Object)opcode);
                break;
            }
            int val = modes[i++] << 24 & 0xFF000000 | modes[i++] << 16 & 0xFF0000 | modes[i++] << 8 & 0xFF00 | modes[i++] & 0xFF;
            PtyMode mode = PtyMode.fromInt((int)opcode);
            if (mode == null) {
                this.log.warn("handlePtyReq({}) unsupported pty opcode value: {}={}", new Object[]{this, opcode, val});
                continue;
            }
            ptyModes.put(mode, val);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePtyReq({}): term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this, term, tColumns, tRows, tWidth, tHeight, ptyModes});
        }
        return this.handlePtyReqParsed(term, tColumns, tRows, tWidth, tHeight, ptyModes);
    }

    protected RequestHandler.Result handlePtyReqParsed(String term, int tColumns, int tRows, int tWidth, int tHeight, Map<PtyMode, Integer> ptyModes) throws IOException {
        StandardEnvironment environment = this.getEnvironment();
        environment.getPtyModes().putAll(ptyModes);
        this.addEnvVariable("TERM", term);
        this.addEnvVariable("COLUMNS", Integer.toString(tColumns));
        this.addEnvVariable("LINES", Integer.toString(tRows));
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleWindowChange(Buffer buffer, boolean wantReply) throws IOException {
        int tColumns = buffer.getInt();
        int tRows = buffer.getInt();
        int tWidth = buffer.getInt();
        int tHeight = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWindowChange({}): ({} - {}), ({}, {})", new Object[]{this, tColumns, tRows, tWidth, tHeight});
        }
        return this.handleWindowChangeParsed(tColumns, tRows, tWidth, tHeight);
    }

    protected RequestHandler.Result handleWindowChangeParsed(int tColumns, int tRows, int tWidth, int tHeight) throws IOException {
        StandardEnvironment e = this.getEnvironment();
        e.set("COLUMNS", Integer.toString(tColumns));
        e.set("LINES", Integer.toString(tRows));
        e.signal(this, Signal.WINCH);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleSignal(Buffer buffer, boolean wantReply) throws IOException {
        String name = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSignal({}): {}", (Object)this, (Object)name);
        }
        return this.handleSignalParsed(name);
    }

    protected RequestHandler.Result handleSignalParsed(String name) throws IOException {
        Signal signal = Signal.get((String)name);
        if (signal != null) {
            StandardEnvironment environ = this.getEnvironment();
            environ.signal(this, signal);
        } else {
            this.log.warn("handleSignal({}) unknown signal received: {}", (Object)this, (Object)name);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleBreak(Buffer buffer, boolean wantReply) throws IOException {
        long breakLength = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleBreak({}) length={}", (Object)this, (Object)breakLength);
        }
        return this.handleBreakParsed(breakLength);
    }

    protected RequestHandler.Result handleBreakParsed(long breakLength) throws IOException {
        StandardEnvironment environ = this.getEnvironment();
        environ.signal(this, Signal.INT);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleShell(String request, Buffer buffer, boolean wantReply) throws IOException {
        if (this.isClosing()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - closing", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        return this.handleShellParsed(request);
    }

    protected RequestHandler.Result handleShellParsed(String request) throws IOException {
        ServerSession shellSession = Objects.requireNonNull(this.getServerSession(), "No server session");
        ServerFactoryManager manager = Objects.requireNonNull(shellSession.getFactoryManager(), "No server factory manager");
        ShellFactory factory = manager.getShellFactory();
        if (factory == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell factory", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        try {
            this.commandInstance = factory.createShell(this);
        }
        catch (IOException | Error | RuntimeException e) {
            this.warn("handleShell({}) Failed ({}) to create shell: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell command", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result handleExec(String request, Buffer buffer, boolean wantReply) throws IOException {
        if (this.isClosing()) {
            return RequestHandler.Result.ReplyFailure;
        }
        String commandLine = buffer.getString();
        return this.handleExecParsed(request, commandLine);
    }

    protected RequestHandler.Result handleExecParsed(String request, String commandLine) throws IOException {
        ServerSession cmdSession = Objects.requireNonNull(this.getServerSession(), "No server session");
        ServerFactoryManager manager = Objects.requireNonNull(cmdSession.getFactoryManager(), "No server factory manager");
        CommandFactory factory = manager.getCommandFactory();
        if (factory == null) {
            this.log.warn("handleExec({}) No command factory for command: {}", (Object)this, (Object)commandLine);
            return RequestHandler.Result.ReplyFailure;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleExec({}) Executing command: {}", (Object)this, (Object)commandLine);
        }
        try {
            this.commandInstance = factory.createCommand(this, commandLine);
        }
        catch (IOException | Error | RuntimeException e) {
            this.warn("handleExec({}) Failed ({}) to create command for {}: {}", this, e.getClass().getSimpleName(), commandLine, e.getMessage(), e);
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleExec({}) Unsupported command: {}", (Object)this, (Object)commandLine);
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result handleSubsystem(String request, Buffer buffer, boolean wantReply) throws IOException {
        String subsystem = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSubsystem({})[want-reply={}] subsystem={}", new Object[]{this, wantReply, subsystem});
        }
        return this.handleSubsystemParsed(request, subsystem);
    }

    protected RequestHandler.Result handleSubsystemParsed(String request, String subsystem) throws IOException {
        ServerFactoryManager manager = Objects.requireNonNull(this.getServerSession(), "No server session").getFactoryManager();
        List<? extends SubsystemFactory> factories = Objects.requireNonNull(manager, "No server factory manager").getSubsystemFactories();
        if (GenericUtils.isEmpty(factories)) {
            this.log.warn("handleSubsystem({}) No factories for subsystem: {}", (Object)this, (Object)subsystem);
            return RequestHandler.Result.ReplyFailure;
        }
        try {
            this.commandInstance = SubsystemFactory.createSubsystem(this, factories, subsystem);
        }
        catch (IOException | Error | RuntimeException e) {
            this.warn("handleSubsystem({}) Failed ({}) to create command for subsystem={}: {}", this, e.getClass().getSimpleName(), subsystem, e.getMessage(), e);
            return RequestHandler.Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleSubsystem({}) Unsupported subsystem: {}", (Object)this, (Object)subsystem);
            return RequestHandler.Result.ReplyFailure;
        }
        return this.prepareChannelCommand(request, this.commandInstance);
    }

    protected RequestHandler.Result prepareChannelCommand(String request, Command cmd) throws IOException {
        Command command = this.prepareCommand(request, cmd);
        if (command == null) {
            this.log.warn("prepareChannelCommand({})[{}] no command prepared", (Object)this, (Object)request);
            return RequestHandler.Result.ReplyFailure;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (command != cmd) {
            if (debugEnabled) {
                this.log.debug("prepareChannelCommand({})[{}] replaced original command", (Object)this, (Object)request);
            }
            this.commandInstance = command;
        }
        if (debugEnabled) {
            this.log.debug("prepareChannelCommand({})[{}] prepared command", (Object)this, (Object)request);
        }
        return RequestHandler.Result.ReplySuccess;
    }

    public void setDataReceiver(ChannelDataReceiver receiver) {
        this.receiver = receiver;
    }

    public void setExtendedDataWriter(ChannelDataReceiver extendedDataWriter) {
        this.extendedDataWriter = extendedDataWriter;
    }

    protected Command prepareCommand(String requestType, Command command) throws IOException {
        Buffer buffer;
        if (command == null) {
            return null;
        }
        ServerSession session = this.getSession();
        this.addEnvVariable("USER", session.getUsername());
        if (command instanceof ServerSessionAware) {
            ((ServerSessionAware)((Object)command)).setSession(session);
        }
        if (command instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)command)).setChannelSession(this);
        }
        if (command instanceof FileSystemAware) {
            ServerFactoryManager manager = session.getFactoryManager();
            FileSystemFactory factory = manager.getFileSystemFactory();
            ((FileSystemAware)command).setFileSystemFactory(factory, (SessionContext)session);
        }
        if (command instanceof AsyncCommandStreamsAware) {
            this.asyncOut = new ChannelAsyncOutputStream(this, 94);
            this.asyncErr = new ChannelAsyncOutputStream(this, 95);
            ((AsyncCommandStreamsAware)((Object)command)).setIoOutputStream(this.asyncOut);
            ((AsyncCommandStreamsAware)((Object)command)).setIoErrorStream(this.asyncErr);
        } else {
            RemoteWindow wRemote = this.getRemoteWindow();
            this.out = new ChannelOutputStream(this, wRemote, this.log, 94, false);
            this.err = new ChannelOutputStream(this, wRemote, this.log, 95, false);
            if (this.log.isTraceEnabled()) {
                this.out = new LoggingFilterOutputStream(this.out, "OUT(" + this + ")", this.log, (PropertyResolver)this);
                this.err = new LoggingFilterOutputStream(this.err, "ERR(" + this + ")", this.log, (PropertyResolver)this);
            }
            command.setOutputStream(this.out);
            command.setErrorStream(this.err);
        }
        if (this.receiver == null) {
            ChannelDataReceiver recv;
            if (command instanceof AsyncCommandInputStreamAware) {
                recv = new AsyncDataReceiver(this);
                this.setDataReceiver(recv);
                ((AsyncCommandInputStreamAware)((Object)command)).setIoInputStream(((AsyncDataReceiver)recv).getIn());
            } else {
                recv = new PipeDataReceiver(this, this.getLocalWindow());
                this.setDataReceiver(recv);
                command.setInputStream(((PipeDataReceiver)recv).getIn());
            }
        }
        if (this.receiverBuffer != null) {
            buffer = this.receiverBuffer;
            this.receiverBuffer = null;
            this.doWriteData(buffer.array(), buffer.rpos(), buffer.available());
        }
        if (this.extendedDataBuffer != null) {
            if (this.extendedDataWriter == null) {
                throw new UnsupportedOperationException("No extended data writer available though " + this.extendedDataBuffer.available() + " bytes accumulated");
            }
            buffer = this.extendedDataBuffer;
            this.extendedDataBuffer = null;
            this.doWriteExtendedData(buffer.array(), buffer.rpos(), buffer.available());
        }
        command.setExitCallback((exitValue, exitMessage, closeImmediately) -> {
            try {
                this.closeShell(exitValue, closeImmediately);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("onExit({}) code={} message='{}' shell closed", new Object[]{this, exitValue, exitMessage});
                }
            }
            catch (IOException e) {
                this.log.warn("onExit({}) code={} message='{}' {} closing shell: {}", new Object[]{this, exitValue, exitMessage, e.getClass().getSimpleName(), e.getMessage()});
            }
        });
        return command;
    }

    protected int getPtyModeValue(PtyMode mode) {
        Number v = this.getEnvironment().getPtyModes().get(mode);
        return v != null ? v.intValue() : 0;
    }

    protected RequestHandler.Result handleAgentForwarding(String requestType, Buffer buffer, boolean wantReply) throws IOException {
        return this.handleAgentForwardingParsed(requestType);
    }

    protected RequestHandler.Result handleAgentForwardingParsed(String requestType) throws IOException {
        ServerSession session = this.getServerSession();
        PropertyResolverUtils.updateProperty((PropertyResolver)session, (String)"agent-fw-auth-type", (Object)requestType);
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        AgentForwardingFilter filter = manager.getAgentForwardingFilter();
        SshAgentFactory factory = manager.getAgentFactory();
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            if (factory == null || filter == null || !filter.canForwardAgent(session, requestType)) {
                if (debugEnabled) {
                    this.log.debug("handleAgentForwarding({})[haveFactory={},haveFilter={}] filtered out request={}", new Object[]{this, factory != null, filter != null, requestType});
                }
                return RequestHandler.Result.ReplyFailure;
            }
        }
        catch (Error e) {
            this.warn("handleAgentForwarding({}) failed ({}) to consult forwarding filter for '{}': {}", this, e.getClass().getSimpleName(), requestType, e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        AgentForwardSupport agentForward = this.service.getAgentForwardSupport();
        if (agentForward == null) {
            if (debugEnabled) {
                this.log.debug("handleAgentForwarding({}) no agent forward support", (Object)this);
            }
            return RequestHandler.Result.ReplyFailure;
        }
        String authSocket = agentForward.initialize();
        this.addEnvVariable("SSH_AUTH_SOCK", authSocket);
        return RequestHandler.Result.ReplySuccess;
    }

    protected RequestHandler.Result handleX11Forwarding(String requestType, Buffer buffer, boolean wantReply) throws IOException {
        ServerSession session = this.getServerSession();
        boolean singleConnection = buffer.getBoolean();
        String authProtocol = buffer.getString();
        String authCookie = buffer.getString();
        int screenId = buffer.getInt();
        return this.handleX11ForwardingParsed(requestType, session, singleConnection, authProtocol, authCookie, screenId);
    }

    protected RequestHandler.Result handleX11ForwardingParsed(String requestType, ServerSession session, boolean singleConnection, String authProtocol, String authCookie, int screenId) throws IOException {
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        X11ForwardingFilter filter = manager.getX11ForwardingFilter();
        boolean debugEnabled = this.log.isDebugEnabled();
        try {
            if (filter == null || !filter.canForwardX11(session, requestType)) {
                if (debugEnabled) {
                    this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={}, filter={}: filtered request={}", new Object[]{this, singleConnection, authProtocol, authCookie, screenId, filter, requestType});
                }
                return RequestHandler.Result.ReplyFailure;
            }
        }
        catch (Error e) {
            this.warn("handleX11Forwarding({}) failed ({}) to consult forwarding filter for '{}': {}", this, e.getClass().getSimpleName(), requestType, e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        X11ForwardSupport x11Forward = this.service.getX11ForwardSupport();
        if (x11Forward == null) {
            if (debugEnabled) {
                this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - no forwarder'", new Object[]{this, singleConnection, authProtocol, authCookie, screenId});
            }
            return RequestHandler.Result.ReplyFailure;
        }
        String display = x11Forward.createDisplay(singleConnection, authProtocol, authCookie, screenId);
        if (debugEnabled) {
            this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - display='{}'", new Object[]{this, singleConnection, authProtocol, authCookie, screenId, display});
        }
        if (GenericUtils.isEmpty((CharSequence)display)) {
            return RequestHandler.Result.ReplyFailure;
        }
        this.addEnvVariable("DISPLAY", display);
        return RequestHandler.Result.ReplySuccess;
    }

    protected void addEnvVariable(String name, String value) {
        StandardEnvironment e = this.getEnvironment();
        e.set(name, value);
    }

    public StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int exitValue, boolean closeImmediately) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closeShell({}) exit code={}, immediate={}", new Object[]{this, exitValue, closeImmediately});
        }
        if (!this.isClosing()) {
            if (this.out != null) {
                this.out.close();
            }
            this.sendEof();
            this.sendExitStatus(exitValue);
            this.commandExitFuture.setClosed();
            this.close(closeImmediately);
        } else {
            this.commandExitFuture.setClosed();
        }
    }

    public class CommandCloseable
    extends IoBaseCloseable {
        public boolean isClosed() {
            return ChannelSession.this.commandExitFuture.isClosed();
        }

        public boolean isClosing() {
            return this.isClosed();
        }

        public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            ChannelSession.this.commandExitFuture.addListener(listener);
        }

        public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
            ChannelSession.this.commandExitFuture.removeListener(listener);
        }

        public CloseFuture close(boolean immediately) {
            if (immediately || ChannelSession.this.commandInstance == null) {
                ChannelSession.this.commandExitFuture.setClosed();
            } else if (!ChannelSession.this.commandExitFuture.isClosed()) {
                IOException e = IoUtils.closeQuietly((Closeable[])new Closeable[]{ChannelSession.this.receiver, ChannelSession.this.extendedDataWriter});
                boolean debugEnabled = this.log.isDebugEnabled();
                if (e != null && debugEnabled) {
                    this.log.debug("close({})[immediately={}] failed ({}) to close receiver(s): {}", new Object[]{this, immediately, e.getClass().getSimpleName(), e.getMessage()});
                }
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        ChannelSession.this.commandExitFuture.setClosed();
                    }
                };
                ChannelSession channel = ChannelSession.this;
                Duration timeout = (Duration)CoreModuleProperties.COMMAND_EXIT_TIMEOUT.getRequired((PropertyResolver)channel);
                if (debugEnabled) {
                    this.log.debug("Wait {} ms for shell to exit cleanly on {}", (Object)timeout, (Object)channel);
                }
                ServerSession s = channel.getSession();
                FactoryManager manager = Objects.requireNonNull(s.getFactoryManager(), "No factory manager");
                ScheduledExecutorService scheduler = Objects.requireNonNull(manager.getScheduledExecutorService(), "No scheduling service");
                scheduler.schedule(task, timeout.toMillis(), TimeUnit.MILLISECONDS);
                ChannelSession.this.commandExitFuture.addListener(future -> task.cancel());
            }
            return ChannelSession.this.commandExitFuture;
        }
    }
}

