/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.UnknownFieldSetHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.TagWriterImpl;

final class MessageMarshallerDelegate<T>
extends BaseMarshallerDelegate<T> {
    private final MessageMarshaller<T> marshaller;
    private final Descriptor messageDescriptor;
    private final FieldDescriptor[] fieldDescriptors;
    private final UnknownFieldSetHandler<T> unknownFieldSetHandler;
    private static final UnknownFieldSetHandler<Message> legacyUnknownFieldSetHandler = new UnknownFieldSetHandler<Message>(){

        @Override
        public UnknownFieldSet getUnknownFieldSet(Message message) {
            return message.getUnknownFieldSet();
        }

        @Override
        public void setUnknownFieldSet(Message message, UnknownFieldSet unknownFieldSet) {
            message.setUnknownFieldSet(unknownFieldSet);
        }
    };

    MessageMarshallerDelegate(MessageMarshaller<T> marshaller, Descriptor messageDescriptor) {
        this.marshaller = marshaller;
        this.messageDescriptor = messageDescriptor;
        this.fieldDescriptors = messageDescriptor.getFields().toArray(new FieldDescriptor[0]);
        this.unknownFieldSetHandler = marshaller instanceof UnknownFieldSetHandler ? (UnknownFieldSetHandler<Object>)((Object)marshaller) : (Message.class.isAssignableFrom(marshaller.getJavaClass()) ? legacyUnknownFieldSetHandler : null);
    }

    @Override
    public MessageMarshaller<T> getMarshaller() {
        return this.marshaller;
    }

    @Override
    public void marshall(ProtobufTagMarshaller.WriteContext ctx, FieldDescriptor fieldDescriptor, T message) throws IOException {
        UnknownFieldSet unknownFieldSet;
        ProtoStreamWriterImpl writer = ((TagWriterImpl)ctx).getProtoStreamWriter();
        ProtoStreamWriterImpl.WriteMessageContext messageContext = writer.enterContext(fieldDescriptor, this.messageDescriptor, (TagWriterImpl)ctx);
        this.marshaller.writeTo(writer, message);
        UnknownFieldSet unknownFieldSet2 = unknownFieldSet = this.unknownFieldSetHandler != null ? this.unknownFieldSetHandler.getUnknownFieldSet(message) : null;
        if (unknownFieldSet != null && !unknownFieldSet.isEmpty()) {
            for (FieldDescriptor fd : this.fieldDescriptors) {
                if (!unknownFieldSet.hasTag(fd.getWireTag())) continue;
                throw new IOException("Field " + fd.getFullName() + " is a known field so it is illegal to be present in the unknown field set");
            }
            unknownFieldSet.writeTo(messageContext.out);
        }
        for (FieldDescriptor fd : this.fieldDescriptors) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || unknownFieldSet != null && unknownFieldSet.hasTag(fd.getWireTag())) continue;
            throw new IllegalStateException("Required field \"" + fd.getFullName() + "\" should have been written by a calling a suitable method of " + MessageMarshaller.ProtoStreamWriter.class.getCanonicalName());
        }
        writer.exitContext();
    }

    @Override
    public T unmarshall(ProtobufTagMarshaller.ReadContext ctx, FieldDescriptor fieldDescriptor) throws IOException {
        ProtoStreamReaderImpl reader = ((TagReaderImpl)ctx).getProtoStreamReader();
        ProtoStreamReaderImpl.ReadMessageContext messageContext = reader.enterContext(fieldDescriptor, this.messageDescriptor, (TagReaderImpl)ctx);
        T message = this.marshaller.readFrom(reader);
        UnknownFieldSet unknownFieldSet = messageContext.unknownFieldSet;
        unknownFieldSet.readAllFields(ctx.getReader());
        if (this.unknownFieldSetHandler != null && !unknownFieldSet.isEmpty()) {
            this.unknownFieldSetHandler.setUnknownFieldSet(message, unknownFieldSet);
        }
        for (FieldDescriptor fd : this.fieldDescriptors) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || unknownFieldSet.hasTag(fd.getWireTag())) continue;
            throw new IOException("Required field \"" + fd.getFullName() + "\" was not encountered in the stream");
        }
        reader.exitContext();
        return message;
    }
}

