/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import org.hibernate.Session;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingMappingContext;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.avro.impl.EventPayloadSerializationUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventReference;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.util.common.impl.Futures;

final class OutboxEventProcessingPlan {
    private final AutomaticIndexingQueueEventProcessingPlan processingPlan;
    private final FailureHandler failureHandler;
    private final EntityReferenceFactory entityReferenceFactory;
    private final List<OutboxEvent> failedEvents = new ArrayList<OutboxEvent>();
    private List<OutboxEvent> events = new ArrayList<OutboxEvent>();

    public OutboxEventProcessingPlan(AutomaticIndexingMappingContext mapping, Session session) {
        this.processingPlan = mapping.createIndexingQueueEventProcessingPlan(session);
        this.failureHandler = mapping.failureHandler();
        this.entityReferenceFactory = mapping.entityReferenceFactory();
    }

    void processEvents(List<OutboxEvent> events) {
        this.events = events;
        try {
            this.addEventsToThePlan();
            this.reportBackendResult((MultiEntityOperationExecutionReport)Futures.unwrappedExceptionGet((Future)this.processingPlan.executeAndReport(OperationSubmitter.blocking())));
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.reportMapperFailure(throwable);
        }
    }

    List<OutboxEvent> getEvents() {
        return this.events;
    }

    List<OutboxEvent> getFailedEvents() {
        return this.failedEvents;
    }

    EntityReference entityReference(String entityName, String entityId, Throwable throwable) {
        try {
            Object identifier = this.processingPlan.toIdentifier(entityName, entityId);
            return EntityReferenceFactory.safeCreateEntityReference((EntityReferenceFactory)this.entityReferenceFactory, (String)entityName, (Object)identifier, throwable::addSuppressed);
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private void addEventsToThePlan() {
        for (OutboxEvent event : this.events) {
            PojoIndexingQueueEventPayload payload = EventPayloadSerializationUtils.deserialize(event.getPayload());
            this.processingPlan.append(event.getEntityName(), event.getEntityId(), payload);
        }
    }

    private void reportMapperFailure(Throwable throwable) {
        try {
            this.reportAllEventsFailure(throwable);
        }
        catch (Throwable t) {
            throwable.addSuppressed(t);
        }
    }

    private void reportBackendResult(MultiEntityOperationExecutionReport report) {
        Optional throwable = report.throwable();
        if (!throwable.isPresent()) {
            return;
        }
        Map<OutboxEventReference, List<OutboxEvent>> eventsMap = this.getEventsByReferences();
        EntityIndexingFailureContext.Builder builder = EntityIndexingFailureContext.builder();
        builder.throwable((Throwable)throwable.get());
        builder.failingOperation((Object)"Processing an outbox event.");
        for (EntityReference entityReference : report.failingEntityReferences()) {
            OutboxEventReference outboxEventReference = new OutboxEventReference(entityReference.name(), this.extractReferenceOrSuppress(entityReference, (Throwable)throwable.get()));
            builder.failingEntityReference(entityReference);
            this.failedEvents.addAll((Collection<OutboxEvent>)eventsMap.get(outboxEventReference));
        }
        this.failureHandler.handle(builder.build());
    }

    private String extractReferenceOrSuppress(EntityReference entityReference, Throwable throwable) {
        try {
            return this.processingPlan.toSerializedId(entityReference.name(), entityReference.id());
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private void reportAllEventsFailure(Throwable throwable) {
        this.failedEvents.addAll(this.events);
        EntityIndexingFailureContext.Builder builder = EntityIndexingFailureContext.builder();
        builder.throwable(throwable);
        builder.failingOperation((Object)"Processing an outbox event.");
        for (OutboxEvent event : this.events) {
            builder.failingEntityReference(this.entityReference(event.getEntityName(), event.getEntityId(), throwable));
        }
        this.failureHandler.handle(builder.build());
    }

    private Map<OutboxEventReference, List<OutboxEvent>> getEventsByReferences() {
        HashMap<OutboxEventReference, List<OutboxEvent>> eventsMap = new HashMap<OutboxEventReference, List<OutboxEvent>>();
        for (OutboxEvent event : this.events) {
            eventsMap.computeIfAbsent(event.getReference(), key -> new ArrayList());
            ((List)eventsMap.get(event.getReference())).add(event);
        }
        return eventsMap;
    }
}

