/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class UnifiedPortComponentRefMetaData
implements Serializable {
    private static final long serialVersionUID = -152050329082506952L;
    private final String serviceEndpointInterface;
    private final String portComponentLink;
    private final QName portQName;
    private final List<UnifiedStubPropertyMetaData> stubProperties;
    private final String configName;
    private final String configFile;
    private final boolean addressingAnnotationSpecified;
    private final boolean addressingEnabled;
    private final boolean addressingRequired;
    private final String addressingResponses;
    private final boolean mtomEnabled;
    private final int mtomThreshold;
    private final boolean respectBindingAnnotationSpecified;
    private final boolean respectBindingEnabled;

    public UnifiedPortComponentRefMetaData(boolean addressingAnnotationSpecified, boolean addressingEnabled, boolean addressingRequired, String addressingResponses, boolean mtomEnabled, int mtomThreshold, boolean respectBindingAnnotationSpecified, boolean respectBindingEnabled, String portComponentLink, String serviceEndpointInterface, QName portQName, List<UnifiedStubPropertyMetaData> stubProps, String configFile, String configName) {
        this.addressingAnnotationSpecified = addressingAnnotationSpecified;
        this.addressingEnabled = addressingEnabled;
        this.addressingRequired = addressingRequired;
        if (!("ANONYMOUS".equals(addressingResponses) || "NON_ANONYMOUS".equals(addressingResponses) || "ALL".equals(addressingResponses))) {
            throw Messages.MESSAGES.unsupportedAddressingResponseType(addressingResponses);
        }
        this.addressingResponses = addressingResponses;
        this.mtomEnabled = mtomEnabled;
        this.mtomThreshold = mtomThreshold;
        this.respectBindingAnnotationSpecified = respectBindingAnnotationSpecified;
        this.respectBindingEnabled = respectBindingEnabled;
        this.portComponentLink = portComponentLink;
        this.serviceEndpointInterface = serviceEndpointInterface;
        this.portQName = portQName;
        this.stubProperties = stubProps != null && !stubProps.isEmpty() ? Collections.unmodifiableList(stubProps) : Collections.emptyList();
        this.configFile = configFile;
        this.configName = configName;
    }

    public boolean isAddressingAnnotationSpecified() {
        return this.addressingAnnotationSpecified;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public boolean isRespectBindingAnnotationSpecified() {
        return this.respectBindingAnnotationSpecified;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public List<UnifiedStubPropertyMetaData> getStubProperties() {
        return this.stubProperties;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean matches(String seiName, QName portName) {
        if (seiName == null && portName == null) {
            throw Messages.MESSAGES.cannotMatchAgainstNull();
        }
        boolean match = false;
        if (portName != null) {
            match = portName.equals(this.getPortQName());
        }
        if (!match && seiName != null) {
            match = seiName.equals(this.getServiceEndpointInterface());
        }
        return match;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedPortComponentRef");
        str.append("\n serviceEndpointInterface=" + this.serviceEndpointInterface);
        str.append("\n portQName=" + this.portQName);
        str.append("\n addressingAnnotationSpecified=" + this.addressingAnnotationSpecified);
        str.append("\n addressingEnabled=" + this.addressingEnabled);
        str.append("\n addressingRequired=" + this.addressingRequired);
        str.append("\n addressingResponses=" + this.addressingResponses);
        str.append("\n mtomEnabled=" + this.mtomEnabled);
        str.append("\n mtomThreshold=" + this.mtomThreshold);
        str.append("\n respectBindingAnnotationSpecified=" + this.respectBindingAnnotationSpecified);
        str.append("\n respectBindingEnabled=" + this.respectBindingEnabled);
        str.append("\n portComponentLink=" + this.portComponentLink);
        str.append("\n stubProperties=" + this.stubProperties);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        return str.toString();
    }
}

