/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseCreateFunction;
import org.infinispan.counter.impl.function.FunctionHelper;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

public class CreateAndAddFunction<K extends CounterKey>
extends BaseCreateFunction<K, CounterValue> {
    public static final AdvancedExternalizer<CreateAndAddFunction> EXTERNALIZER = new Externalizer();
    private final long delta;

    public CreateAndAddFunction(CounterConfiguration configuration, long delta) {
        super(configuration);
        this.delta = delta;
    }

    @Override
    CounterValue apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, CounterValue currentValue, CounterConfigurationMetaParam metadata) {
        return FunctionHelper.add(entryView, currentValue, metadata, this.delta);
    }

    private static class Externalizer
    implements AdvancedExternalizer<CreateAndAddFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CreateAndAddFunction>> getTypeClasses() {
            return Collections.singleton(CreateAndAddFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.CREATE_ADD_FUNCTION;
        }

        public void writeObject(ObjectOutput output, CreateAndAddFunction object) throws IOException {
            output.writeObject(object.configuration);
            output.writeLong(object.delta);
        }

        public CreateAndAddFunction<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CreateAndAddFunction((CounterConfiguration)input.readObject(), input.readLong());
        }
    }
}

