/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.mapper.orm.common.spi.SessionHelper;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentRepositoryProvider;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.AgentClusterLinkContext;

public class AgentClusterLinkContextProvider {
    private final TransactionHelper transactionHelper;
    private final SessionHelper sessionHelper;
    private final AgentRepositoryProvider agentRepositoryProvider;

    public AgentClusterLinkContextProvider(TransactionHelper transactionHelper, SessionHelper sessionHelper, AgentRepositoryProvider agentRepositoryProvider) {
        this.transactionHelper = transactionHelper;
        this.sessionHelper = sessionHelper;
        this.agentRepositoryProvider = agentRepositoryProvider;
    }

    public final void inTransaction(Consumer<AgentClusterLinkContext> action) {
        this.inTransaction((AgentClusterLinkContext context) -> {
            action.accept((AgentClusterLinkContext)context);
            return null;
        });
    }

    public <T> T inTransaction(Function<AgentClusterLinkContext, T> action) {
        T result;
        AgentClusterLinkContext context = new AgentClusterLinkContext(this.transactionHelper, this.sessionHelper, this.agentRepositoryProvider);
        try {
            context.begin();
            result = action.apply(context);
        }
        catch (Throwable t) {
            context.rollbackLatestTransactionSafely(t);
            throw t;
        }
        context.commit();
        return result;
    }
}

