/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.Runner;
import org.jgroups.util.Util;

public class RingBufferBundlerLockless
extends BaseBundler {
    protected Message[] buf;
    protected int read_index;
    protected volatile int write_index = 0;
    protected final AtomicInteger tmp_write_index = new AtomicInteger(0);
    protected final AtomicInteger write_permits;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final AtomicInteger num_threads = new AtomicInteger(0);
    protected final AtomicLong accumulated_bytes = new AtomicLong(0L);
    protected final AtomicBoolean unparking = new AtomicBoolean(false);
    protected Runner bundler_thread;
    protected static final String THREAD_NAME = "RingBufferBundlerLockless";
    protected final Runnable run_function = this::readMessages;

    public RingBufferBundlerLockless() {
        this(1024);
    }

    public RingBufferBundlerLockless(int capacity) {
        this.buf = new Message[Util.getNextHigherPowerOfTwo(capacity)];
        this.write_permits = new AtomicInteger(this.buf.length);
    }

    public int readIndex() {
        return this.read_index;
    }

    public int writeIndex() {
        return this.write_index;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int getQueueSize() {
        return this.size.get();
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        this.bundler_thread = new Runner(transport.getThreadFactory(), THREAD_NAME, this.run_function, this::reset);
    }

    public void reset() {
        this.write_index = 0;
        this.read_index = 0;
        this.tmp_write_index.set(0);
        this.size.set(0);
    }

    @Override
    public void start() {
        this.bundler_thread.start();
    }

    @Override
    public void stop() {
        this.bundler_thread.stop();
    }

    @Override
    public void send(Message msg) throws Exception {
        boolean unpark;
        if (msg == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        this.num_threads.incrementAndGet();
        int tmp_index = this.getWriteIndex();
        if (tmp_index == -1) {
            this.log.warn("buf is full (num_permits: %d, bundler: %s)\n", this.write_permits.get(), this.toString());
            this.num_threads.decrementAndGet();
            return;
        }
        this.buf[tmp_index] = msg;
        long acc_bytes = this.accumulated_bytes.addAndGet(msg.size());
        int current_threads = this.num_threads.decrementAndGet();
        boolean no_other_threads = current_threads == 0;
        boolean bl = unpark = acc_bytes >= (long)this.max_size && this.accumulated_bytes.compareAndSet(acc_bytes, 0L) || no_other_threads;
        if (unpark && this.unparking.compareAndSet(false, true)) {
            Thread thread;
            int num_advanced = this.advanceWriteIndex();
            this.size.addAndGet(num_advanced);
            if (num_advanced > 0 && (thread = this.bundler_thread.getThread()) != null) {
                LockSupport.unpark(thread);
            }
            this.unparking.set(false);
        }
    }

    protected int getWriteIndex() {
        int permit = this.getPermitToWrite();
        if (permit < 0) {
            return -1;
        }
        int next = this.tmp_write_index.getAndIncrement();
        int next_index = this.index(next);
        this.tmp_write_index.compareAndSet(next, next_index);
        return next_index;
    }

    protected int getPermitToWrite() {
        int remaining = this.write_permits.decrementAndGet();
        if (remaining < 0) {
            this.write_permits.incrementAndGet();
        }
        return remaining;
    }

    protected int advanceWriteIndex() {
        int num = 0;
        int start = this.write_index;
        while (this.buf[start] != null) {
            ++num;
            if ((start = this.index(start + 1)) != this.tmp_write_index.get()) continue;
        }
        this.write_index = start;
        return num;
    }

    protected void readMessages() {
        this._readMessages();
        LockSupport.park();
    }

    protected int sendBundledMessages(Message[] buf, int read_index, int available_msgs) {
        byte[] cluster_name = this.transport.cluster_name.chars();
        int start = read_index;
        int sent_msgs = 0;
        while (available_msgs > 0) {
            Message msg = buf[start];
            if (msg == null) {
                start = this.increment(start);
                --available_msgs;
                continue;
            }
            Address dest = msg.getDest();
            try {
                this.output.position(0);
                Util.writeMessageListHeader(dest, msg.getSrc(), cluster_name, 1, this.output, dest == null);
                int size_pos = this.output.position() - 4;
                int num_msgs = this.marshalMessagesToSameDestination(dest, buf, start, available_msgs, this.max_size);
                sent_msgs += num_msgs;
                if (num_msgs > 1) {
                    int current_pos = this.output.position();
                    this.output.position(size_pos);
                    this.output.writeInt(num_msgs);
                    this.output.position(current_pos);
                }
                this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
                if (this.transport.statsEnabled()) {
                    this.transport.getMessageStats().incrNumBatchesSent(num_msgs);
                }
            }
            catch (Exception ex) {
                this.log.trace("failed to send message(s)", ex);
            }
            --available_msgs;
            start = this.increment(start);
        }
        return sent_msgs;
    }

    public String toString() {
        return String.format("read-index=%d write-index=%d size=%d cap=%d", this.read_index, this.write_index, this.size.get(), this.buf.length);
    }

    public int _readMessages() {
        int available_msgs = this.size.get();
        if (available_msgs > 0) {
            int sent_msgs = this.sendBundledMessages(this.buf, this.read_index, available_msgs);
            this.read_index = this.index(this.read_index + sent_msgs);
            this.size.addAndGet(-sent_msgs);
            this.write_permits.addAndGet(sent_msgs);
            return sent_msgs;
        }
        return 0;
    }

    protected int marshalMessagesToSameDestination(Address dest, Message[] buf, int start_index, int available_msgs, int max_bundle_size) throws Exception {
        int num_msgs = 0;
        int bytes = 0;
        while (available_msgs > 0) {
            Message msg = buf[start_index];
            if (msg != null && Objects.equals(dest, msg.getDest())) {
                int msg_size = msg.size() + 2;
                if (bytes + msg_size > max_bundle_size) break;
                bytes += msg_size;
                ++num_msgs;
                buf[start_index] = null;
                this.output.writeShort(msg.getType());
                msg.writeToNoAddrs(msg.getSrc(), this.output, this.transport.getId());
            }
            --available_msgs;
            start_index = this.increment(start_index);
        }
        return num_msgs;
    }

    protected final int increment(int index) {
        return index + 1 == this.buf.length ? 0 : index + 1;
    }

    protected final int index(int idx) {
        return idx & this.buf.length - 1;
    }

    protected static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

