/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.SessionMarshallerFactory;

public class DistributableWebDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_API = "org.wildfly.clustering.web.api";
    private static final String MARSHALLING_API = "org.wildfly.clustering.marshalling.api";
    private static final String PROTOSTREAM = "org.infinispan.protostream";
    private static final String EL_EXPRESSLY = "org.wildfly.clustering.el.expressly";
    private static final String WELD_CORE = "org.wildfly.clustering.weld.core";
    private static final String WELD_EJB = "org.wildfly.clustering.weld.ejb";
    private static final String WELD_WEB = "org.wildfly.clustering.weld.web";
    private static final String FACES_MOJARRA = "org.wildfly.clustering.faces.mojarra";
    private static final String UNDERTOW = "org.wildfly.clustering.web.undertow";

    /*
     * Unable to fully structure code
     */
    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        unit = context.getDeploymentUnit();
        provider = (DistributableSessionManagementProvider)context.getAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY);
        if (provider != null) {
            unit.putAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY, (Object)provider);
            specification = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
            loader = Module.getBootModuleLoader();
            specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.web.api", false, false, false, false));
            if (provider.getSessionManagementConfiguration().getMarshallerFactory() == SessionMarshallerFactory.PROTOSTREAM) {
                specification.addSystemDependency(new ModuleDependency(loader, "org.infinispan.protostream", false, false, false, false));
                specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.web.undertow", false, false, true, false));
                support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                if (support.hasCapability("org.wildfly.weld")) {
                    try {
                        weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
                        if (!weldCapability.isPartOfWeldDeployment(unit)) ** GOTO lbl26
                        specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.el.expressly", false, false, true, false));
                        specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.weld.core", false, false, true, false));
                        specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.weld.ejb", false, false, true, false));
                        specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.weld.web", false, false, true, false));
                    }
                    catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
                        throw new IllegalStateException(e);
                    }
                }
            } else {
                specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.marshalling.api", false, false, false, false));
            }
lbl26:
            // 4 sources

            if (JsfVersionMarker.getVersion((DeploymentUnit)unit).equals("Mojarra-4.0")) {
                specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.el.expressly", false, false, true, false));
                specification.addSystemDependency(new ModuleDependency(loader, "org.wildfly.clustering.faces.mojarra", false, false, true, false));
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(DistributableSessionManagementProvider.ATTACHMENT_KEY);
    }
}

