/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.deployment.module.ModuleAliasChecker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.security.PermissionFactory;

public class ModuleSpecification
extends SimpleAttachable {
    private final List<ModuleDependency> systemDependencies = new ArrayList<ModuleDependency>();
    private final Set<ModuleIdentifier> systemDependenciesSet = new HashSet<ModuleIdentifier>();
    private final Set<ModuleDependency> localDependencies = new LinkedHashSet<ModuleDependency>();
    private boolean localDependenciesTransitive;
    private final List<ModuleDependency> userDependencies = new ArrayList<ModuleDependency>();
    private final Set<ModuleDependency> userDependenciesSet = new HashSet<ModuleDependency>();
    private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>();
    private final List<String> classTransformers = new ArrayList<String>();
    private volatile List<ModuleDependency> allDependencies = null;
    private final Set<ModuleIdentifier> exclusions = new HashSet<ModuleIdentifier>();
    private final HashMap<ModuleIdentifier, List<ModuleIdentifier>> exclusionsMap = new HashMap();
    private final Set<ModuleIdentifier> excludedDependencies = new HashSet<ModuleIdentifier>();
    private boolean subDeploymentModulesIsolated;
    private boolean exclusionsCascadedToSubDeployments;
    private boolean privateModule;
    private boolean publicModule;
    private boolean localLast;
    private final List<ModuleIdentifier> aliases = new ArrayList<ModuleIdentifier>();
    private final List<DependencySpec> moduleSystemDependencies = new ArrayList<DependencySpec>();
    private final List<PermissionFactory> permissionFactories = new ArrayList<PermissionFactory>();

    public void addSystemDependency(ModuleDependency dependency) {
        if (!this.exclusions.contains(dependency.getIdentifier()) && !this.systemDependenciesSet.contains(dependency.getIdentifier())) {
            this.systemDependencies.add(dependency);
            this.systemDependenciesSet.add(dependency.getIdentifier());
        } else {
            this.excludedDependencies.add(dependency.getIdentifier());
        }
    }

    public void addSystemDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        for (ModuleDependency dependency : dependencies) {
            this.addSystemDependency(dependency);
        }
    }

    public void addUserDependency(ModuleDependency dependency) {
        this.allDependencies = null;
        if (this.userDependenciesSet.add(dependency)) {
            this.userDependencies.add(dependency);
        }
    }

    public void addUserDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        for (ModuleDependency dependency : dependencies) {
            this.addUserDependency(dependency);
        }
    }

    public void addLocalDependency(ModuleDependency dependency) {
        this.allDependencies = null;
        if (!this.exclusions.contains(dependency.getIdentifier())) {
            this.localDependencies.add(dependency);
        } else {
            this.excludedDependencies.add(dependency.getIdentifier());
        }
    }

    public void addLocalDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        for (ModuleDependency dependency : dependencies) {
            this.addLocalDependency(dependency);
        }
    }

    public List<ModuleDependency> getSystemDependencies() {
        return Collections.unmodifiableList(this.systemDependencies);
    }

    public void addExclusion(ModuleIdentifier exclusion) {
        ModuleDependency dep;
        this.allDependencies = null;
        String targetModule = ModuleAliasChecker.getTargetModule(exclusion.toString());
        if (targetModule != null) {
            List<Object> aliases;
            ModuleIdentifier identifier = ModuleIdentifier.create((String)targetModule);
            if (this.exclusionsMap.containsKey(identifier)) {
                aliases = this.exclusionsMap.get(identifier);
            } else {
                aliases = new ArrayList();
                this.exclusionsMap.put(identifier, aliases);
            }
            aliases.add(exclusion);
            this.exclusions.add(identifier);
        } else {
            this.exclusionsMap.putIfAbsent(exclusion, new ArrayList());
        }
        this.exclusions.add(exclusion);
        Iterator<ModuleDependency> it = this.systemDependencies.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getIdentifier().equals(exclusion)) continue;
            it.remove();
        }
        it = this.localDependencies.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getIdentifier().equals(exclusion)) continue;
            it.remove();
        }
    }

    public void addExclusions(Iterable<ModuleIdentifier> exclusions) {
        for (ModuleIdentifier exclusion : exclusions) {
            this.addExclusion(exclusion);
        }
    }

    public List<ModuleDependency> getLocalDependencies() {
        return Collections.unmodifiableList(new ArrayList<ModuleDependency>(this.localDependencies));
    }

    public List<ModuleDependency> getUserDependencies() {
        return Collections.unmodifiableList(this.userDependencies);
    }

    public List<ModuleDependency> getMutableUserDependencies() {
        this.allDependencies = null;
        return this.userDependencies;
    }

    public void addResourceLoader(ResourceLoaderSpec resourceLoader) {
        this.resourceLoaders.add(resourceLoader);
    }

    public List<ResourceLoaderSpec> getResourceLoaders() {
        return Collections.unmodifiableList(this.resourceLoaders);
    }

    public void addClassTransformer(String classTransformer) {
        this.classTransformers.add(classTransformer);
    }

    public List<String> getClassTransformers() {
        return Collections.unmodifiableList(this.classTransformers);
    }

    public boolean isSubDeploymentModulesIsolated() {
        return this.subDeploymentModulesIsolated;
    }

    public void setSubDeploymentModulesIsolated(boolean subDeploymentModulesIsolated) {
        this.subDeploymentModulesIsolated = subDeploymentModulesIsolated;
    }

    public boolean isExclusionsCascadedToSubDeployments() {
        return this.exclusionsCascadedToSubDeployments;
    }

    public void setExclusionsCascadedToSubDeployments(boolean exclusionsCascadedToSubDeployments) {
        this.exclusionsCascadedToSubDeployments = exclusionsCascadedToSubDeployments;
    }

    public boolean isPrivateModule() {
        return this.privateModule;
    }

    public void setPrivateModule(boolean privateModule) {
        this.privateModule = privateModule;
    }

    public boolean isPublicModule() {
        return this.publicModule;
    }

    public void setPublicModule(boolean publicModule) {
        this.publicModule = publicModule;
    }

    public boolean isLocalDependenciesTransitive() {
        return this.localDependenciesTransitive;
    }

    public void setLocalDependenciesTransitive(boolean localDependenciesTransitive) {
        this.localDependenciesTransitive = localDependenciesTransitive;
    }

    public boolean isLocalLast() {
        return this.localLast;
    }

    public void setLocalLast(boolean localLast) {
        this.localLast = localLast;
    }

    public void addAlias(ModuleIdentifier moduleIdentifier) {
        this.aliases.add(moduleIdentifier);
    }

    public void addAliases(Collection<ModuleIdentifier> moduleIdentifiers) {
        this.aliases.addAll(moduleIdentifiers);
    }

    public List<ModuleIdentifier> getAliases() {
        return this.aliases;
    }

    public List<ModuleDependency> getAllDependencies() {
        if (this.allDependencies == null) {
            this.allDependencies = new ArrayList<ModuleDependency>();
            this.allDependencies.addAll(this.systemDependencies);
            this.allDependencies.addAll(this.userDependencies);
            this.allDependencies.addAll(this.localDependencies);
        }
        return this.allDependencies;
    }

    public void addModuleSystemDependencies(List<DependencySpec> systemDependencies) {
        this.moduleSystemDependencies.addAll(systemDependencies);
    }

    public List<DependencySpec> getModuleSystemDependencies() {
        return Collections.unmodifiableList(this.moduleSystemDependencies);
    }

    public void addPermissionFactory(PermissionFactory permissionFactory) {
        this.permissionFactories.add(permissionFactory);
    }

    public List<PermissionFactory> getPermissionFactories() {
        return this.permissionFactories;
    }

    public Set<ModuleIdentifier> getNonexistentExcludedDependencies() {
        HashSet<ModuleIdentifier> unExcludedModuleExclusion = new HashSet<ModuleIdentifier>(this.exclusions);
        block0: for (ModuleIdentifier identifier : this.excludedDependencies) {
            for (Map.Entry<ModuleIdentifier, List<ModuleIdentifier>> entry : this.exclusionsMap.entrySet()) {
                if (!entry.getKey().equals(identifier) && !entry.getValue().contains(identifier)) continue;
                unExcludedModuleExclusion.remove(entry.getKey());
                unExcludedModuleExclusion.removeAll((Collection)entry.getValue());
                continue block0;
            }
        }
        return unExcludedModuleExclusion;
    }
}

