/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class DB2TableManager<K, V>
extends AbstractTableManager<K, V> {
    private static final Log log = (Log)LogFactory.getLog(DB2TableManager.class, Log.class);

    DB2TableManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    protected String initInsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("INSERT INTO %s (%s,%s,%s) VALUES (?,?,?)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName());
        }
        return String.format("INSERT INTO %s (%s,%s,%s,%s) VALUES (?,?,?,?)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.segmentColumnName());
    }

    @Override
    protected String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s AS t USING (SELECT * FROM TABLE (VALUES (?,?,?))) AS tmp(%4$s, %3$s, %2$s) ON t.%4$s = tmp.%4$s WHEN MATCHED THEN UPDATE SET (t.%2$s, t.%3$s) = (tmp.%2$s, tmp.%3$s) WHEN NOT MATCHED THEN INSERT (t.%4$s, t.%3$s, t.%2$s) VALUES (tmp.%4$s, tmp.%3$s, tmp.%2$s)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE INTO %1$s AS t USING (SELECT * FROM TABLE (VALUES (?,?,?,?))) AS tmp(%4$s, %3$s, %2$s, %5$s) ON t.%4$s = tmp.%4$s WHEN MATCHED THEN UPDATE SET (t.%2$s, t.%3$s, t.%5$s) = (tmp.%2$s, tmp.%3$s, tmp.%5$s) WHEN NOT MATCHED THEN INSERT (t.%4$s, t.%3$s, t.%2$s, t.%5$s) VALUES (tmp.%4$s, tmp.%3$s, tmp.%2$s, tmp.%5$s)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    protected void prepareValueStatement(PreparedStatement ps, int segment, String keyStr, ByteBuffer valueBytes, long expiryTime) throws SQLException {
        ps.setString(1, keyStr);
        ps.setLong(2, expiryTime);
        ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(valueBytes.getBuf(), valueBytes.getOffset(), valueBytes.getLength()), valueBytes.getLength());
        if (!this.dbMetadata.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }

    @Override
    protected String getDropTimestampSql(String indexName) {
        return String.format("DROP INDEX %s", this.getIndexName(this.dbMetadata.getMaxTableNameLength(), true, indexName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema();
            if (schemaPattern == null) {
                schemaPattern = this.getCurrentSchema(connection);
            }
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose((ResultSet)rs);
            return bl;
        }
        catch (SQLException e) {
            if (log.isTraceEnabled()) {
                log.tracef((Throwable)e, "SQLException occurs while checking the table %s", (Object)tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getCurrentSchema(Connection connection) {
        try (Statement statement = connection.createStatement();){
            String string;
            block18: {
                ResultSet rs;
                block16: {
                    String string2;
                    block17: {
                        rs = statement.executeQuery("VALUES CURRENT SCHEMA");
                        try {
                            if (!rs.next()) break block16;
                            string2 = rs.getString(1);
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = null;
                if (rs == null) break block18;
                rs.close();
            }
            return string;
        }
        catch (SQLException e) {
            log.debug((Object)"Couldn't obtain the current schema, no schema will be specified during table existence check.", (Throwable)e);
            return null;
        }
    }
}

