/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.OneToOneSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;

public class ToOneBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ToOneBinder.class);

    static void bindManyToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder, boolean forcePersist) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getAnnotation(jakarta.persistence.ManyToOne.class);
        if (property.isAnnotationPresent(Column.class) || property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@ManyToOne' association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@ManyToOne' association and cannot be used as identifier");
        }
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        ToOneBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, manyToOne.fetch());
        OnDelete onDelete = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable joinTable = propertyHolder.getJoinTable(property);
        if (joinTable != null) {
            Join join = propertyHolder.addJoin(joinTable, false);
            for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        ToOneBinder.bindManyToOne(BinderHelper.getCascadeStrategy(manyToOne.cascade(), hibernateCascade, false, forcePersist), joinColumns, !ToOneBinder.isMandatory(manyToOne.optional(), property, notFoundAction), notFoundAction, onDelete == null ? null : onDelete.action(), ToOneBinder.getTargetEntity(inferredData, context), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static boolean isIdentifier(PropertyHolder propertyHolder, PropertyBinder propertyBinder, boolean isIdentifierMapper) {
        return propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass() || isIdentifierMapper;
    }

    private static boolean isMandatory(boolean optional, XProperty property, NotFoundAction notFoundAction) {
        return !optional || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(MapsId.class) && notFoundAction != NotFoundAction.IGNORE;
    }

    private static void bindManyToOne(String cascadeStrategy, AnnotatedJoinColumns joinColumns, boolean optional, NotFoundAction notFoundAction, OnDeleteAction onDeleteAction, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        ManyToOne value = new ManyToOne(context, joinColumns.getTable());
        if (unique) {
            value.markAsLogicalOneToOne();
        }
        value.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntity, context));
        XProperty property = inferredData.getProperty();
        ToOneBinder.defineFetchingStrategy(value, property, inferredData, propertyHolder);
        value.setNotFoundAction(notFoundAction);
        value.setOnDeleteAction(onDeleteAction);
        if (!optional) {
            for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
                column.setNullable(false);
            }
        }
        if (property.isAnnotationPresent(MapsId.class)) {
            for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
                column.setInsertable(false);
                column.setUpdatable(false);
            }
        }
        boolean hasSpecjManyToOne = ToOneBinder.handleSpecjSyntax(joinColumns, inferredData, context, property);
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String fullPath = StringHelper.qualify(propertyHolder.getPath(), propertyName);
        ToOneBinder.bindForeignKeyNameAndDefinition(value, property, propertyHolder.getOverriddenForeignKey(fullPath), context);
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, joinColumns, unique, propertyHolder.getPersistentClass(), fullPath, context);
        if (inSecondPass) {
            secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
        } else {
            context.getMetadataCollector().addSecondPass(secondPass);
        }
        ToOneBinder.processManyToOneProperty(cascadeStrategy, joinColumns, optional, inferredData, isIdentifierMapper, propertyBinder, value, property, hasSpecjManyToOne, propertyName);
    }

    private static boolean handleSpecjSyntax(AnnotatedJoinColumns columns, PropertyData inferredData, MetadataBuildingContext context, XProperty property) {
        boolean hasSpecjManyToOne = false;
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled()) {
            JoinColumn joinColumn = (JoinColumn)property.getAnnotation(JoinColumn.class);
            String columnName = "";
            for (XProperty prop : inferredData.getDeclaringClass().getDeclaredProperties(AccessType.FIELD.getType())) {
                if (prop.isAnnotationPresent(Id.class) && prop.isAnnotationPresent(Column.class)) {
                    columnName = ((Column)prop.getAnnotation(Column.class)).name();
                }
                if (!property.isAnnotationPresent(jakarta.persistence.ManyToOne.class) || joinColumn == null || joinColumn.name().isEmpty() || !joinColumn.name().equals(columnName) || property.isAnnotationPresent(MapsId.class)) continue;
                hasSpecjManyToOne = true;
                for (AnnotatedJoinColumn column : columns.getJoinColumns()) {
                    column.setInsertable(false);
                    column.setUpdatable(false);
                }
            }
        }
        return hasSpecjManyToOne;
    }

    private static void processManyToOneProperty(String cascadeStrategy, AnnotatedJoinColumns columns, boolean optional, PropertyData inferredData, boolean isIdentifierMapper, PropertyBinder propertyBinder, ManyToOne value, XProperty property, boolean hasSpecjManyToOne, String propertyName) {
        columns.checkPropertyConsistency();
        propertyBinder.setName(propertyName);
        propertyBinder.setValue(value);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else if (hasSpecjManyToOne) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setColumns(columns);
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setCascade(cascadeStrategy);
        propertyBinder.setProperty(property);
        propertyBinder.setToMany(true);
        JoinColumn joinColumn = (JoinColumn)property.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)property.getAnnotation(JoinColumns.class);
        propertyBinder.makePropertyAndBind().setOptional(optional && ToOneBinder.isNullable(joinColumns, joinColumn));
    }

    private static boolean isNullable(JoinColumns joinColumns, JoinColumn joinColumn) {
        if (joinColumn != null) {
            return joinColumn.nullable();
        }
        if (joinColumns != null) {
            for (JoinColumn column : joinColumns.value()) {
                if (!column.nullable()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static void defineFetchingStrategy(ToOne toOne, XProperty property, PropertyData inferredData, PropertyHolder propertyHolder) {
        ToOneBinder.handleLazy(toOne, property, inferredData, propertyHolder);
        ToOneBinder.handleFetch(toOne, property);
    }

    private static void handleFetch(ToOne toOne, XProperty property) {
        if (property.isAnnotationPresent(Fetch.class)) {
            ToOneBinder.handleHibernateFetchMode(toOne, property);
        } else {
            toOne.setFetchMode(BinderHelper.getFetchMode(ToOneBinder.getJpaFetchType(property)));
        }
    }

    private static void handleLazy(ToOne toOne, XProperty property, PropertyData inferredData, PropertyHolder propertyHolder) {
        if (property.isAnnotationPresent(NotFound.class)) {
            toOne.setLazy(false);
            toOne.setUnwrapProxy(true);
        } else {
            boolean eager = ToOneBinder.isEager(property, inferredData, propertyHolder);
            toOne.setLazy(!eager);
            toOne.setUnwrapProxy(eager);
            toOne.setUnwrapProxyImplicit(true);
        }
    }

    private static void handleHibernateFetchMode(ToOne toOne, XProperty property) {
        switch (((Fetch)property.getAnnotation(Fetch.class)).value()) {
            case JOIN: {
                toOne.setFetchMode(FetchMode.JOIN);
                toOne.setLazy(false);
                toOne.setUnwrapProxy(false);
                break;
            }
            case SELECT: {
                toOne.setFetchMode(FetchMode.SELECT);
                break;
            }
            case SUBSELECT: {
                throw new AnnotationException("Association '" + property.getName() + "' is annotated '@Fetch(SUBSELECT)' but is not many-valued");
            }
            default: {
                throw new AssertionFailure("unknown fetch type");
            }
        }
    }

    private static boolean isEager(XProperty property, PropertyData inferredData, PropertyHolder propertyHolder) {
        FetchType fetchType = ToOneBinder.getJpaFetchType(property);
        if (property.isAnnotationPresent(LazyToOne.class)) {
            boolean eager;
            LazyToOne lazy = (LazyToOne)property.getAnnotation(LazyToOne.class);
            boolean bl = eager = lazy.value() == LazyToOneOption.FALSE;
            if (eager && fetchType == FetchType.LAZY) {
                throw new AnnotationException("Association '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is marked 'fetch=LAZY' and '@LazyToOne(FALSE)'");
            }
            return eager;
        }
        return fetchType == FetchType.EAGER;
    }

    private static FetchType getJpaFetchType(XProperty property) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getAnnotation(jakarta.persistence.ManyToOne.class);
        OneToOne oneToOne = (OneToOne)property.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            return manyToOne.fetch();
        }
        if (oneToOne != null) {
            return oneToOne.fetch();
        }
        throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
    }

    static void bindOneToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder, boolean forcePersist) {
        OneToOne oneToOne = (OneToOne)property.getAnnotation(OneToOne.class);
        if (property.isAnnotationPresent(Column.class) || property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@OneToOne' association and may not use '@Column' to specify column mappings (use '@PrimaryKeyJoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@OneToOne' association and cannot be used as identifier");
        }
        boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        boolean mandatory = ToOneBinder.isMandatory(oneToOne.optional(), property, notFoundAction);
        ToOneBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, oneToOne.fetch());
        OnDelete onDelete = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable joinTable = propertyHolder.getJoinTable(property);
        if (joinTable != null) {
            Join join = propertyHolder.addJoin(joinTable, false);
            if (notFoundAction != null) {
                join.disableForeignKeyCreation();
            }
            for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        ToOneBinder.bindOneToOne(BinderHelper.getCascadeStrategy(oneToOne.cascade(), hibernateCascade, oneToOne.orphanRemoval(), forcePersist), joinColumns, !mandatory, BinderHelper.getFetchMode(oneToOne.fetch()), notFoundAction, onDelete == null ? null : onDelete.action(), ToOneBinder.getTargetEntity(inferredData, context), propertyHolder, inferredData, StringHelper.nullIfEmpty(oneToOne.mappedBy()), trueOneToOne, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static void bindOneToOne(String cascadeStrategy, AnnotatedJoinColumns joinColumns, boolean optional, FetchMode fetchMode, NotFoundAction notFoundAction, OnDeleteAction cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        String propertyName = inferredData.getPropertyName();
        LOG.tracev("Fetching {0} with {1}", propertyName, (Object)fetchMode);
        if (ToOneBinder.isMapToPK(joinColumns, propertyHolder, trueOneToOne) || mappedBy != null) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyName, propertyHolder, inferredData, targetEntity, notFoundAction, cascadeOnDelete, optional, cascadeStrategy, joinColumns, context);
            if (inSecondPass) {
                secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
            } else {
                context.getMetadataCollector().addSecondPass(secondPass, mappedBy == null);
            }
        } else {
            ToOneBinder.bindManyToOne(cascadeStrategy, joinColumns, optional, notFoundAction, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, propertyBinder, context);
        }
    }

    private static boolean isMapToPK(AnnotatedJoinColumns joinColumns, PropertyHolder propertyHolder, boolean trueOneToOne) {
        if (trueOneToOne) {
            return true;
        }
        KeyValue identifier = propertyHolder.getIdentifier();
        if (identifier == null) {
            return false;
        }
        ArrayList<String> idColumnNames = new ArrayList<String>();
        List<AnnotatedJoinColumn> columns = joinColumns.getJoinColumns();
        if (identifier.getColumnSpan() != columns.size()) {
            return false;
        }
        for (org.hibernate.mapping.Column currentColumn : identifier.getColumns()) {
            idColumnNames.add(currentColumn.getName());
        }
        for (AnnotatedJoinColumn column : columns) {
            if (idColumnNames.contains(column.getMappingColumn().getName())) continue;
            return false;
        }
        return true;
    }

    public static void bindForeignKeyNameAndDefinition(SimpleValue value, XProperty property, ForeignKey foreignKey, MetadataBuildingContext context) {
        if (property.getAnnotation(NotFound.class) != null) {
            value.disableForeignKey();
        } else {
            JoinColumn joinColumn = (JoinColumn)property.getAnnotation(JoinColumn.class);
            JoinColumns joinColumns = (JoinColumns)property.getAnnotation(JoinColumns.class);
            if (joinColumn != null && ToOneBinder.noConstraint(joinColumn.foreignKey(), context) || joinColumns != null && ToOneBinder.noConstraint(joinColumns.foreignKey(), context)) {
                value.disableForeignKey();
            } else {
                org.hibernate.annotations.ForeignKey fk = (org.hibernate.annotations.ForeignKey)property.getAnnotation(org.hibernate.annotations.ForeignKey.class);
                if (fk != null && StringHelper.isNotEmpty(fk.name())) {
                    value.setForeignKeyName(fk.name());
                } else if (ToOneBinder.noConstraint(foreignKey, context)) {
                    value.disableForeignKey();
                } else if (foreignKey != null) {
                    value.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                } else if (joinColumns != null) {
                    value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumns.foreignKey().name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumns.foreignKey().foreignKeyDefinition()));
                } else if (joinColumn != null) {
                    value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumn.foreignKey().name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumn.foreignKey().foreignKeyDefinition()));
                }
            }
        }
    }

    private static boolean noConstraint(ForeignKey joinColumns, MetadataBuildingContext context) {
        if (joinColumns == null) {
            return false;
        }
        ConstraintMode mode = joinColumns.value();
        return mode == ConstraintMode.NO_CONSTRAINT || mode == ConstraintMode.PROVIDER_DEFAULT && context.getBuildingOptions().isNoConstraintByDefault();
    }

    public static String getReferenceEntityName(PropertyData propertyData, XClass targetEntity, MetadataBuildingContext context) {
        return BinderHelper.isDefault(targetEntity, context) ? propertyData.getClassOrElementName() : targetEntity.getName();
    }

    public static String getReferenceEntityName(PropertyData propertyData, MetadataBuildingContext context) {
        XClass targetEntity = ToOneBinder.getTargetEntity(propertyData, context);
        return BinderHelper.isDefault(targetEntity, context) ? propertyData.getClassOrElementName() : targetEntity.getName();
    }

    public static XClass getTargetEntity(PropertyData propertyData, MetadataBuildingContext context) {
        return context.getBootstrapContext().getReflectionManager().toXClass(ToOneBinder.getTargetEntityClass(propertyData.getProperty()));
    }

    private static Class<?> getTargetEntityClass(XProperty property) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getAnnotation(jakarta.persistence.ManyToOne.class);
        if (manyToOne != null) {
            return manyToOne.targetEntity();
        }
        OneToOne oneToOne = (OneToOne)property.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            return oneToOne.targetEntity();
        }
        throw new AssertionFailure("Unexpected discovery of a targetEntity: " + property.getName());
    }

    private static void matchIgnoreNotFoundWithFetchType(String entity, String association, NotFoundAction notFoundAction, FetchType fetchType) {
        if (notFoundAction != null && fetchType == FetchType.LAZY) {
            LOG.ignoreNotFoundWithFetchTypeLazy(entity, association);
        }
    }
}

