/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class ElasticsearchIndexWorkspace
implements IndexWorkspace {
    private final ElasticsearchWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchParallelWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final Set<String> tenantIds;

    public ElasticsearchIndexWorkspace(ElasticsearchWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchParallelWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, Set<String> tenantIds) {
        this.workFactory = workFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexManagerContext.getElasticsearchIndexWriteName();
        this.tenantIds = tenantIds;
    }

    public CompletableFuture<?> mergeSegments(OperationSubmitter operationSubmitter) {
        return this.orchestrator.submit(this.workFactory.mergeSegments().index(this.indexName).build(), operationSubmitter);
    }

    public CompletableFuture<?> purge(Set<String> routingKeys, OperationSubmitter operationSubmitter) {
        JsonArray filters = new JsonArray();
        JsonObject filter = this.multiTenancyStrategy.filterOrNull(this.tenantIds);
        if (filter != null) {
            filters.add((JsonElement)filter);
        }
        if (!routingKeys.isEmpty()) {
            filters.add((JsonElement)Queries.anyTerm("_routing", routingKeys));
        }
        JsonObject payload = new JsonObject();
        payload.add("query", (JsonElement)Queries.boolFilter(Queries.matchAll(), filters));
        return this.orchestrator.submit(this.workFactory.deleteByQuery(this.indexName, payload).routingKeys(routingKeys).build(), operationSubmitter);
    }

    public CompletableFuture<?> flush(OperationSubmitter operationSubmitter) {
        return this.orchestrator.submit(this.workFactory.flush().index(this.indexName).build(), operationSubmitter);
    }

    public CompletableFuture<?> refresh(OperationSubmitter operationSubmitter) {
        return this.orchestrator.submit(this.workFactory.refresh().index(this.indexName).build(), operationSubmitter);
    }
}

