/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractNonAggregatedIdentifierMappingInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer,
ValueAccess {
    private final NavigablePath navigablePath;
    private final NonAggregatedIdentifierMapping embedded;
    private final EmbeddableMappingType representationEmbeddable;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final FetchParentAccess fetchParentAccess;
    private final SessionFactoryImplementor sessionFactory;
    private final DomainResultAssembler<?>[] assemblers;
    private final boolean hasIdClass;
    private final Object[] virtualIdState;
    private final Object[] idClassState;
    private State state = State.INITIAL;
    protected Object compositeInstance;

    public AbstractNonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess fetchParentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = (NonAggregatedIdentifierMapping)resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        EmbeddableMappingType virtualIdEmbeddable = this.embedded.getEmbeddableTypeDescriptor();
        this.representationEmbeddable = this.embedded.getMappedIdEmbeddableTypeDescriptor();
        this.representationStrategy = this.representationEmbeddable.getRepresentationStrategy();
        this.hasIdClass = this.embedded.hasContainingClass() && virtualIdEmbeddable != this.representationEmbeddable;
        int size = virtualIdEmbeddable.getNumberOfFetchables();
        this.virtualIdState = new Object[size];
        this.idClassState = new Object[size];
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = AbstractNonAggregatedIdentifierMappingInitializer.createAssemblers(this, resultDescriptor, creationState, virtualIdEmbeddable);
    }

    protected static DomainResultAssembler<?>[] createAssemblers(FetchParentAccess parentAccess, EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] assemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = resultDescriptor.findFetch(stateArrayContributor);
            assemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(parentAccess, creationState);
        }
        return assemblers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance;
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        if (this.fetchParentAccess == null) {
            return null;
        }
        return this.fetchParentAccess.findFirstEntityDescriptorAccess();
    }

    @Override
    public EntityInitializer findFirstEntityInitializer() {
        FetchParentAccess firstEntityDescriptorAccess = this.findFirstEntityDescriptorAccess();
        if (firstEntityDescriptorAccess == null) {
            return null;
        }
        return firstEntityDescriptorAccess.findFirstEntityInitializer();
    }

    @Override
    public void resolveKey(RowProcessingState processingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState processingState) {
    }

    @Override
    public void initializeInstance(RowProcessingState processingState) {
        EmbeddableLoadingLogger.EMBEDDED_LOAD_LOGGER.debugf("Initializing composite instance [%s]", (Object)this.navigablePath);
        switch (this.state) {
            case NULL: {
                return;
            }
            case INITIAL: {
                if (this.isFindByIdLookup(processingState)) {
                    this.compositeInstance = processingState.getEntityId();
                    this.state = State.INJECTED;
                    return;
                }
                processingState = this.wrapProcessingState(processingState);
                this.extractRowState(processingState);
                if (this.state == State.NULL) {
                    return;
                }
                this.compositeInstance = this.representationStrategy.getInstantiator().instantiate(this, this.sessionFactory);
            }
            case EXTRACTED: {
                Object parentInstance;
                if (this.fetchParentAccess == null || (parentInstance = this.fetchParentAccess.getInitializedInstance()) == null) break;
                this.notifyResolutionListeners(this.compositeInstance);
                LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(parentInstance);
                if (lazyInitializer != null) {
                    Initializer parentInitializer = processingState.resolveInitializer(this.navigablePath.getParent());
                    if (parentInitializer != this) {
                        ((FetchParentAccess)parentInitializer).registerResolutionListener(entity -> {
                            this.embedded.getVirtualIdEmbeddable().setValues(entity, this.virtualIdState);
                            this.state = State.INJECTED;
                        });
                        break;
                    }
                    assert (false);
                    Object target = this.representationStrategy.getInstantiator().instantiate(this, this.sessionFactory);
                    this.state = State.INJECTED;
                    lazyInitializer.setImplementation(target);
                    break;
                }
                this.embedded.getVirtualIdEmbeddable().setValues(parentInstance, this.virtualIdState);
                this.state = State.INJECTED;
            }
        }
    }

    private boolean isFindByIdLookup(RowProcessingState processingState) {
        return !this.hasIdClass && processingState.getEntityId() != null && this.navigablePath.getParent().getParent() == null && this.navigablePath instanceof EntityIdentifierNavigablePath;
    }

    private void extractRowState(RowProcessingState processingState) {
        this.state = State.NULL;
        for (int i = 0; i < this.assemblers.length; ++i) {
            Object associationKey;
            DomainResultAssembler<?> assembler = this.assemblers[i];
            Object contributorValue = assembler.assemble(processingState, processingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            if (contributorValue == null) {
                return;
            }
            if (contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY) {
                this.virtualIdState[i] = null;
                this.idClassState[i] = null;
                continue;
            }
            this.virtualIdState[i] = contributorValue;
            this.idClassState[i] = contributorValue;
            if (!this.hasIdClass) continue;
            AttributeMapping virtualIdAttribute = this.embedded.getEmbeddableTypeDescriptor().getAttributeMapping(i);
            AttributeMapping mappedIdAttribute = this.representationEmbeddable.getAttributeMapping(i);
            if (!(virtualIdAttribute instanceof ToOneAttributeMapping) || mappedIdAttribute instanceof ToOneAttributeMapping) continue;
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
            ForeignKeyDescriptor fkDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
            this.idClassState[i] = associationKey = fkDescriptor.getAssociationKeyFromSide(this.virtualIdState[i], toOneAttributeMapping.getSideNature().inverse(), processingState.getSession());
        }
        this.state = State.EXTRACTED;
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        if (!this.isFindByIdLookup(rowProcessingState)) {
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                assembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    public Object[] getValues() {
        return this.state == State.NULL ? null : this.idClassState;
    }

    @Override
    public <T> T getValue(int i, Class<T> clazz) {
        return this.state == State.NULL ? null : (T)clazz.cast(this.idClassState[i]);
    }

    @Override
    public Object getOwner() {
        return this.fetchParentAccess.getInitializedInstance();
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.state = State.INITIAL;
        this.clearResolutionListeners();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    static enum State {
        INITIAL,
        EXTRACTED,
        NULL,
        INJECTED;

    }
}

