/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.api;

import io.narayana.lra.Current;
import io.narayana.lra.LRAConstants;
import io.narayana.lra.LRAData;
import io.narayana.lra.coordinator.api.RecoveryCoordinator;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.logging.LRALogger;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.openapi.annotations.Components;
import org.eclipse.microprofile.openapi.annotations.OpenAPIDefinition;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.headers.Header;
import org.eclipse.microprofile.openapi.annotations.info.Contact;
import org.eclipse.microprofile.openapi.annotations.info.Info;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

@ApplicationScoped
@ApplicationPath(value="/")
@Path(value="lra-coordinator")
@OpenAPIDefinition(info=@Info(title="LRA Coordinator", version="1.1", contact=@Contact(name="Narayana", url="https://narayana.io")), tags={@Tag(name="LRA Coordinator")}, components=@Components(schemas={@Schema(name="LRAApiVersionSchema", description="Format is `major.minor`, both components are required, they are to be numbers", type=SchemaType.STRING, pattern="^\\d+\\.\\d+$", example="1.0")}, parameters={@Parameter(name="Narayana-LRA-API-version", in=ParameterIn.HEADER, description="Narayana LRA API version", schema=@Schema(ref="LRAApiVersionSchema"))}, headers={@Header(name="Narayana-LRA-API-version", description="Narayana LRA API version", schema=@Schema(ref="LRAApiVersionSchema"))}))
@Tag(name="LRA Coordinator", description="Operations to work with active LRAs (to start, to get a status, to finish, etc.)")
public class Coordinator
extends Application {
    @Context
    private UriInfo context;
    private static final boolean allowParticipantData = Coordinator.initAllowParticipantData();
    private final LRAService lraService = LRARecoveryModule.getService();
    private final RecoveryCoordinator recoveryCoordinator = new RecoveryCoordinator();

    @Path(value="recovery")
    public RecoveryCoordinator getRecoveryCoordinator() {
        return this.recoveryCoordinator;
    }

    private static boolean initAllowParticipantData() {
        try {
            return (Boolean)ConfigProvider.getConfig().getValue("lra.participant.data", Boolean.class);
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isAllowParticipantData(String version) {
        return version == null || allowParticipantData && !version.equals("1.0");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(summary="Returns all LRAs", description="Gets both active and recovering LRAs")
    @APIResponses(value={@APIResponse(responseCode="200", description="The LRAData json array which is known to coordinator", content={@Content(schema=@Schema(type=SchemaType.ARRAY, implementation=LRAData.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="400", description="Provided Status is not recognized as a valid LRA status value", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getAllLRAs(@Parameter(name="Status", description="Filter the returned LRAs to only those in the give state (see CompensatorStatus)") @QueryParam(value="Status") @DefaultValue(value="") String state, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version) {
        LRAStatus requestedLRAStatus = null;
        if (!state.isEmpty()) {
            try {
                requestedLRAStatus = LRAStatus.valueOf((String)state);
            }
            catch (IllegalArgumentException e) {
                String errorMsg = "Status " + state + " is not a valid LRAStatus value";
                LRALogger.logger.debugf(errorMsg, new Object[0]);
                throw new WebApplicationException(errorMsg, (Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Narayana-LRA-API-version", (Object)version).entity((Object)errorMsg).build());
            }
        }
        List<LRAData> lras = this.lraService.getAll(requestedLRAStatus);
        return Response.ok().entity(lras).header("Narayana-LRA-API-version", (Object)version).build();
    }

    @GET
    @Path(value="{LraId}/status")
    @Produces(value={"text/plain"})
    @Operation(summary="Obtain the status of an LRA as a string")
    @APIResponses(value={@APIResponse(responseCode="200", description="The LRA exists. The status is reported in the content body.", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getLRAStatus(@Parameter(name="LraId", description="The unique identifier of the LRA.Expecting to be a valid URL where the participant can be contacted at. If not in URL format it will be considered to be an id which will be declared to exist at URL where coordinator is deployed at.", required=true) @PathParam(value="LraId") String lraId, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version) throws NotFoundException {
        LongRunningAction transaction = this.lraService.getTransaction(this.toURI(lraId));
        LRAStatus status = transaction.getLRAStatus();
        if (status == null) {
            status = LRAStatus.Active;
        }
        return Response.ok().entity((Object)status.name()).header("Narayana-LRA-API-version", (Object)version).build();
    }

    @GET
    @Path(value="{LraId}")
    @Produces(value={"application/json"})
    @Operation(summary="Obtain the information about an LRA as a JSON structure")
    @APIResponses(value={@APIResponse(responseCode="200", description="The LRA exists and the information is packed as JSON in the content body.", content={@Content(schema=@Schema(implementation=LRAData.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response getLRAInfo(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version) {
        URI lraIdURI = this.toURI(lraId);
        LRAData lraData = this.lraService.getLRA(lraIdURI);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)lraData).header("Narayana-LRA-API-version", (Object)version).build();
    }

    @POST
    @Path(value="start")
    @Produces(value={"text/plain"})
    @Bulkhead
    @Operation(summary="Start a new LRA", description="The LRA model uses a presumed nothing protocol: the coordinator must communicate with Compensators in order to inform them of the LRA activity. Every time a Compensator is enrolled with an LRA, the coordinator must make information about it durable so that the Compensator can be contacted when the LRA terminates, even in the event of subsequent failures. Compensators, clients and coordinators cannot make any presumption about the state of the global transaction without consulting the coordinator and all compensators, respectively.")
    @APIResponses(value={@APIResponse(responseCode="201", description="The request was successful and the response body contains the id of the new LRA", content={@Content(schema=@Schema(description="An URI of the new LRA", implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="Parent LRA id cannot be joint to the started LRA", content={@Content(schema=@Schema(description="Message containing problematic LRA id", implementation=String.class))}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="500", description="A new LRA could not be started. Coordinator internal error.", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response startLRA(@Parameter(name="ClientID", description="Each client is expected to have a unique identity (which can be a URL).", required=true) @QueryParam(value="ClientID") @DefaultValue(value="") String clientId, @Parameter(name="TimeLimit", description="Specifies the maximum time in milli seconds that the LRA will exist for.\nIf the LRA is terminated because of a timeout, the LRA URL is deleted.\nAll further invocations on the URL will return 404.\nThe invoker can assume this was equivalent to a compensate operation.") @QueryParam(value="TimeLimit") @DefaultValue(value="0") Long timelimit, @Parameter(name="ParentLRA", description="The enclosing LRA if this new LRA is nested") @QueryParam(value="ParentLRA") @DefaultValue(value="") String parentLRA, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version) throws WebApplicationException {
        URI parentId = parentLRA == null || parentLRA.trim().isEmpty() ? null : this.toURI(parentLRA);
        String coordinatorUrl = String.format("%s%s", this.context.getBaseUri(), "lra-coordinator");
        LongRunningAction lra = this.lraService.startLRA(coordinatorUrl, parentId, clientId, timelimit);
        URI lraId = lra.getId();
        if (parentId != null) {
            String compensatorUrl = String.format("%s/nested/%s", coordinatorUrl, LRAConstants.getLRAUid((URI)lraId));
            if (!this.lraService.hasTransaction(parentId)) {
                Response response = null;
                try (Client client = null;){
                    client = ClientBuilder.newClient();
                    response = (Response)client.target(parentId).request().header("Narayana-LRA-API-version", (Object)"1.1").async().put(Entity.text((Object)compensatorUrl)).get(2L, TimeUnit.SECONDS);
                    if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                        String errMessage = String.format("The coordinator at %s returned an unexpected response: %dwhen the LRA '%s' tried to join the parent LRA '%s'", parentId, response.getStatus(), lraId, parentLRA);
                        Response response2 = Response.status((int)response.getStatus()).entity((Object)errMessage).build();
                        return response2;
                    }
                }
            }
        }
        Current.push((URI)lraId);
        return Response.created((URI)lraId).entity((Object)lraId).header("Long-Running-Action", (Object)Current.getContexts()).header("Narayana-LRA-API-version", (Object)version).build();
    }

    @PUT
    @Path(value="{LraId}/renew")
    @Operation(summary="Update the TimeLimit for an existing LRA", description="LRAs can be automatically cancelled if they aren't closed or cancelled before the TimeLimit specified at creation time is reached. The time limit can be updated.")
    @APIResponses(value={@APIResponse(responseCode="200", description="If the LRA time limit has been updated", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA or the LRA is not longer active (ie the complete or compensate messages have been sent", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response renewTimeLimit(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(name="TimeLimit", description="The new time limit for the LRA", required=true) @QueryParam(value="TimeLimit") @DefaultValue(value="0") Long timeLimit, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version) {
        return Response.status((int)this.lraService.renewTimeLimit(this.toURI(lraId), timeLimit)).header("Narayana-LRA-API-version", (Object)version).entity((Object)lraId).build();
    }

    @GET
    @Path(value="nested/{NestedLraId}/status")
    public Response getNestedLRAStatus(@PathParam(value="NestedLraId") String nestedLraId) {
        if (!this.lraService.hasTransaction(nestedLraId)) {
            return Response.ok((Object)ParticipantStatus.Compensated.name()).build();
        }
        LongRunningAction lra = this.lraService.getTransaction(this.toURI(nestedLraId));
        LRAStatus status = lra.getLRAStatus();
        if (status == null || lra.getLRAStatus() == null) {
            String logMsg = LRALogger.i18nLogger.error_cannotGetStatusOfNestedLraURI(nestedLraId, lra.getId());
            LRALogger.logger.debug((Object)logMsg);
            throw new WebApplicationException(logMsg, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)logMsg).build());
        }
        return Response.ok((Object)this.mapToParticipantStatus(lra.getLRAStatus()).name()).build();
    }

    private ParticipantStatus mapToParticipantStatus(LRAStatus lraStatus) {
        switch (lraStatus) {
            case Active: {
                return ParticipantStatus.Active;
            }
            case Closed: {
                return ParticipantStatus.Completed;
            }
            case Cancelled: {
                return ParticipantStatus.Compensated;
            }
            case Closing: {
                return ParticipantStatus.Completing;
            }
            case Cancelling: {
                return ParticipantStatus.Compensating;
            }
            case FailedToClose: {
                return ParticipantStatus.FailedToComplete;
            }
            case FailedToCancel: {
                return ParticipantStatus.FailedToCompensate;
            }
        }
        return null;
    }

    @PUT
    @Path(value="nested/{NestedLraId}/complete")
    public Response completeNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        return Response.ok((Object)this.mapToParticipantStatus(this.endLRA(this.toURI(nestedLraId), false, true, null, null)).name()).build();
    }

    @PUT
    @Path(value="nested/{NestedLraId}/compensate")
    public Response compensateNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        return Response.ok((Object)this.mapToParticipantStatus(this.endLRA(this.toURI(nestedLraId), true, true, null, null)).name()).build();
    }

    @PUT
    @Path(value="nested/{NestedLraId}/forget")
    public Response forgetNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        this.lraService.remove(this.toURI(nestedLraId));
        return Response.ok().build();
    }

    @PUT
    @Path(value="{LraId}/close")
    @Produces(value={"text/plain"})
    @Operation(summary="Attempt to close an LRA", description="Trigger the successful completion of the LRA. All compensators will be dropped by the coordinator. The complete message will be sent to the compensators. Upon termination, the URL is implicitly deleted. The invoker cannot know for sure whether the lra completed or compensated without enlisting a participant.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The complete message was sent to all coordinators", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response closeLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String txId, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version, @HeaderParam(value="Narayana-LRA-Participant-Link") @DefaultValue(value="") String compensator, @HeaderParam(value="Narayana-LRA-Participant-Data") @DefaultValue(value="") String userData) {
        return Response.ok((Object)this.endLRA(this.toURI(txId), false, false, compensator, userData).name()).header("Narayana-LRA-API-version", (Object)version).build();
    }

    @PUT
    @Path(value="{LraId}/cancel")
    @Produces(value={"application/json"})
    @Operation(summary="Attempt to cancel an LRA", description=" Trigger the compensation of the LRA. All compensators will be triggered by the coordinator (ie the compensate message will be sent to each compensators). Upon termination, the URL is implicitly deleted. The invoker cannot know for sure whether the lra completed or compensated without enlisting a participant.")
    @APIResponses(value={@APIResponse(responseCode="200", description="The compensate message was sent to all coordinators", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response cancelLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version, @HeaderParam(value="Narayana-LRA-Participant-Link") @DefaultValue(value="") String compensator, @HeaderParam(value="Narayana-LRA-Participant-Data") @DefaultValue(value="") String userData) throws NotFoundException {
        return Response.ok((Object)this.endLRA(this.toURI(lraId), true, false, compensator, userData).name()).header("Narayana-LRA-API-version", (Object)version).build();
    }

    private LRAStatus endLRA(URI lraId, boolean compensate, boolean fromHierarchy, String compensator, String userData) throws NotFoundException {
        LRAData lraData = this.lraService.endLRA(lraId, compensate, fromHierarchy, compensator, userData);
        return lraData.getStatus();
    }

    @PUT
    @Path(value="{LraId}")
    @Produces(value={"application/json"})
    @Operation(summary="A Compensator can join with the LRA at any time prior to the completion of an activity")
    @APIResponses(value={@APIResponse(responseCode="200", description="The participant was successfully registered with the LRA", content={@Content(schema=@Schema(description="A URI representing the recovery id of this join request", implementation=String.class))}, headers={@Header(name="Long-Running-Action-Recovery", description="It contains a unique resource reference for that participant:\n - HTTP GET on the reference returns the original participant URL;\n - HTTP PUT on the reference will overwrite the old participant URL with the new one supplied.", schema=@Schema(implementation=String.class)), @Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="400", description="Link does not contain all required fields for joining the LRA. Probably no compensator or after 'rel' is available.", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="412", description="The LRA is not longer active (ie the complete or compensate message has been sent), or wrong format of compensator data", content={@Content(schema=@Schema(implementation=String.class))}, headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="500", description="Format of the compensator data (e.g. Link format) could not be processed", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response joinLRAViaBody(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(name="TimeLimit", description="The time limit in milliseconds that the Compensator can guarantee that it can compensate the work performed by the service. After this time period has elapsed, it may no longer be possible to undo the work within the scope of this (or any enclosing) LRA. It may therefore be necessary for the application or service to start other activities to explicitly try to compensate this work. The application or coordinator may use this information to control the lifecycle of an LRA.") @QueryParam(value="TimeLimit") @DefaultValue(value="0") long timeLimit, @Parameter(name="Link", description="The resource paths that the coordinator will use to complete or compensate and to request the status of the participant. The link rel names are complete, compensate and status.") @HeaderParam(value="Link") @DefaultValue(value="") String compensatorLink, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version, @HeaderParam(value="Narayana-LRA-Participant-Data") @DefaultValue(value="") String userData, @RequestBody(name="Compensator data", description="A compensator can also register with an LRA by putting the compensator end points in the body of request as a link header. This feature is deprecated and undocumented and will be removed in a later version of the protocol") String compensatorURL) throws NotFoundException {
        if (userData != null && !userData.isEmpty() && !this.isAllowParticipantData(version)) {
            String logMsg = LRALogger.i18nLogger.error_participant_data_disallowed(lraId);
            LRALogger.logger.error((Object)logMsg);
            throw new WebApplicationException(logMsg, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)logMsg).header("Narayana-LRA-API-version", (Object)version).build());
        }
        boolean isLink = this.isLink((String)compensatorURL);
        if (compensatorLink != null && !compensatorLink.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            if (userData != null) {
                sb.append(userData);
            }
            return this.joinLRA(this.toURI(lraId), timeLimit, null, compensatorLink, sb, version);
        }
        if (!isLink && !((String)compensatorURL).isEmpty()) {
            compensatorURL = (String)compensatorURL + "/";
            HashMap<String, String> terminateURIs = new HashMap<String, String>();
            try {
                terminateURIs.put("compensate", new URL((String)compensatorURL + "compensate").toExternalForm());
                terminateURIs.put("complete", new URL((String)compensatorURL + "complete").toExternalForm());
                terminateURIs.put("status", new URL((String)compensatorURL + "status").toExternalForm());
            }
            catch (MalformedURLException e) {
                String errorMsg = String.format("Cannot join to LRA id '%s' with body as compensator url '%s' is invalid", lraId, compensatorURL);
                if (LRALogger.logger.isTraceEnabled()) {
                    LRALogger.logger.trace((Object)errorMsg, (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).header("Narayana-LRA-API-version", (Object)version).entity((Object)errorMsg).build();
            }
            StringBuilder linkHeaderValue = new StringBuilder();
            terminateURIs.forEach((k, v) -> Coordinator.makeLink(linkHeaderValue, "", k, v));
            compensatorURL = linkHeaderValue.toString();
        }
        return this.joinLRA(this.toURI(lraId), timeLimit, null, (String)compensatorURL, null, version);
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private boolean isLink(String linkString) {
        try {
            Link.valueOf((String)linkString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Response joinLRA(URI lraId, long timeLimit, String compensatorUrl, String linkHeader, StringBuilder userData, String version) throws NotFoundException {
        String recoveryUrlBase = String.format("%s%s/%s", this.context.getBaseUri().toASCIIString(), "lra-coordinator", "recovery");
        if (userData == null) {
            userData = new StringBuilder();
        }
        StringBuilder recoveryUrl = new StringBuilder();
        int status = this.lraService.joinLRA(recoveryUrl, lraId, timeLimit, compensatorUrl, linkHeader, recoveryUrlBase, userData);
        try {
            return Response.status((int)status).entity((Object)recoveryUrl.toString()).location(new URI(recoveryUrl.toString())).header("Long-Running-Action-Recovery", (Object)recoveryUrl).header("Narayana-LRA-Participant-Data", (Object)userData).header("Narayana-LRA-API-version", (Object)version).build();
        }
        catch (URISyntaxException e) {
            String logMsg = LRALogger.i18nLogger.error_invalidRecoveryUrlToJoinLRAURI(recoveryUrl.toString(), lraId);
            LRALogger.logger.error((Object)logMsg);
            throw new WebApplicationException(logMsg, (Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)logMsg).header("Narayana-LRA-API-version", (Object)version).build());
        }
    }

    @PUT
    @Path(value="{LraId}/remove")
    @Produces(value={"application/json"})
    @Operation(summary="A Compensator can resign from the LRA at any time prior to the completion of an activity")
    @APIResponses(value={@APIResponse(responseCode="200", description="If the participant was successfully removed from the LRA", headers={@Header(ref="Narayana-LRA-API-version")}), @APIResponse(responseCode="400", description="The coordinator has no knowledge of this participant compensator URL", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=String.class))}), @APIResponse(responseCode="412", description="The LRA is not longer active (ie in the complete or compensate messages have been sent"), @APIResponse(responseCode="417", description="The requested version provided in HTTP Header is not supported by this end point", content={@Content(schema=@Schema(implementation=String.class))})})
    public Response leaveLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(ref="Narayana-LRA-API-version") @HeaderParam(value="Narayana-LRA-API-version") @DefaultValue(value="1.1") String version, String participantCompensatorUrl) throws NotFoundException {
        int status = this.lraService.leave(this.toURI(lraId), participantCompensatorUrl);
        return Response.status((int)status).header("Narayana-LRA-API-version", (Object)version).build();
    }

    private URI toURI(String lraId) {
        URL url;
        try {
            url = new URL(lraId);
            url.toURI();
        }
        catch (Exception e) {
            try {
                url = new URL(String.format("%s%s/%s", this.context.getBaseUri(), "lra-coordinator", lraId));
            }
            catch (MalformedURLException e1) {
                String logMsg = LRALogger.i18nLogger.error_invalidStringFormatOfUrl(lraId, (Throwable)e1);
                LRALogger.logger.error((Object)logMsg);
                throw new WebApplicationException(logMsg, (Throwable)e1, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)logMsg).build());
            }
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            String logMsg = LRALogger.i18nLogger.error_invalidStringFormatOfUrl(lraId, (Throwable)e);
            LRALogger.logger.error((Object)logMsg);
            throw new WebApplicationException(logMsg, (Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)logMsg).build());
        }
    }
}

