/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConsumerThread;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import picocli.CommandLine;

@CommandLine.Command(name="consumer", description={"Consume messages from a queue."})
public class Consumer
extends DestAbstract {
    @CommandLine.Option(names={"--durable"}, description={"Whether the consumer's subscription will be durable."})
    boolean durable = false;
    @CommandLine.Option(names={"--break-on-null"}, description={"Stop consuming when a null message is received."})
    boolean breakOnNull = false;
    @CommandLine.Option(names={"--receive-timeout"}, description={"Timeout for receiving messages (in milliseconds)."})
    int receiveTimeout = 3000;
    @CommandLine.Option(names={"--filter"}, description={"The message filter."})
    String filter;
    @CommandLine.Option(names={"--data"}, description={"Serialize the messages to the specified file as they are consumed."})
    String file;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        context.out.println("Consumer:: filter = " + this.filter);
        SerialiserMessageListener listener = null;
        MessageSerializer serializer = null;
        if (this.file != null) {
            FileOutputStream out;
            serializer = this.getMessageSerializer();
            if (serializer == null) {
                System.err.println("Error. Unable to instantiate serializer class: " + this.serializer);
                return null;
            }
            try {
                out = new FileOutputStream(this.file);
            }
            catch (Exception e) {
                System.err.println("Error: Unable to open file for writing\n" + e.getMessage());
                return null;
            }
            listener = new SerialiserMessageListener(serializer, out);
            serializer.start();
        }
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            void object;
            ConsumerThread[] threadsArray = new ConsumerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                Session session = this.txBatchSize > 0 ? connection.createSession(true, 0) : connection.createSession(false, 1);
                Destination destination = this.getDestination(session);
                threadsArray[i] = new ConsumerThread(session, destination, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setDurable(this.durable).setBatchSize(this.txBatchSize).setBreakOnNull(this.breakOnNull).setMessageCount(this.messageCount).setReceiveTimeOut(this.receiveTimeout).setFilter(this.filter).setBrowse(false).setListener(listener);
            }
            ConsumerThread[] i = threadsArray;
            int n = i.length;
            boolean bl = false;
            while (object < n) {
                ConsumerThread thread = i[object];
                thread.start();
                ++object;
            }
            connection.start();
            long received = 0L;
            for (ConsumerThread thread : threadsArray) {
                thread.join();
                received += (long)thread.getReceived();
            }
            if (serializer != null) {
                serializer.stop();
            }
            Long l = received;
            return l;
        }
    }

    public boolean isDurable() {
        return this.durable;
    }

    public Consumer setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public boolean isBreakOnNull() {
        return this.breakOnNull;
    }

    public Consumer setBreakOnNull(boolean breakOnNull) {
        this.breakOnNull = breakOnNull;
        return this;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Consumer setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public Consumer setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public Consumer setFile(String file) {
        this.file = file;
        return this;
    }

    private class SerialiserMessageListener
    implements MessageListener {
        private MessageSerializer messageSerializer;

        SerialiserMessageListener(MessageSerializer messageSerializer, OutputStream outputStream) throws Exception {
            this.messageSerializer = messageSerializer;
            this.messageSerializer.setOutput(outputStream);
        }

        public void onMessage(Message message) {
            this.messageSerializer.write(message);
        }
    }
}

