/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import org.HdrHistogram.SingleWriterRecorder;
import org.apache.activemq.artemis.cli.commands.messages.perf.AsyncJms2ProducerFacade;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerLoadGenerator;

public abstract class SkeletalProducerLoadGenerator
implements CompletionListener,
ProducerLoadGenerator {
    protected final AsyncJms2ProducerFacade producer;
    private final OrderedEventExecutor executor;
    protected final BooleanSupplier keepOnSending;
    protected final MicrosTimeProvider timeProvider;
    private final String group;
    private final byte[] messageContent;
    private BytesMessage messageToSend;
    protected boolean closed;
    protected volatile boolean stopLoad;
    private final SingleWriterRecorder waitLatencies;
    private final SingleWriterRecorder sendCompletedLatencies;
    private final AtomicLong unprocessedCompletions;
    private final AtomicBoolean scheduledProcessingCompletions;
    private volatile Exception fatalException;
    private boolean stopHandlingCompletions;

    public SkeletalProducerLoadGenerator(AsyncJms2ProducerFacade producer, OrderedEventExecutor executor, MicrosTimeProvider timeProvider, BooleanSupplier keepOnSending, String group, byte[] msgContent, SingleWriterRecorder sendCompletedLatencies, SingleWriterRecorder waitLatencies) {
        this.sendCompletedLatencies = sendCompletedLatencies;
        this.waitLatencies = waitLatencies;
        this.producer = producer;
        this.executor = executor;
        this.timeProvider = timeProvider;
        this.keepOnSending = keepOnSending;
        this.group = group;
        this.messageContent = msgContent;
        this.messageToSend = null;
        this.closed = false;
        this.stopLoad = false;
        this.unprocessedCompletions = new AtomicLong();
        this.scheduledProcessingCompletions = new AtomicBoolean();
        this.fatalException = null;
        this.stopHandlingCompletions = false;
    }

    @Override
    public Exception getFatalException() {
        return this.fatalException;
    }

    @Override
    public SingleWriterRecorder getSendCompletedLatencies() {
        return this.sendCompletedLatencies;
    }

    @Override
    public SingleWriterRecorder getWaitLatencies() {
        return this.waitLatencies;
    }

    @Override
    public AsyncJms2ProducerFacade getProducer() {
        return this.producer;
    }

    @Override
    public boolean isCompleted() {
        if (this.stopLoad && this.fatalException != null) {
            return true;
        }
        return this.stopLoad && this.producer.getMessageCompleted() == this.producer.getMessageSent();
    }

    @Override
    public OrderedEventExecutor getExecutor() {
        return this.executor;
    }

    protected final void asyncContinue() {
        this.asyncContinue(0L);
    }

    protected final void asyncContinue(long usDelay) {
        if (usDelay == 0L) {
            this.executor.execute((Runnable)this);
        } else {
            this.executor.schedule((Runnable)this, usDelay, TimeUnit.MICROSECONDS);
        }
    }

    protected final boolean trySend(long sendTime) {
        return this.trySend(sendTime, sendTime);
    }

    protected final boolean trySend(long expectedSendTime, long sendTime) {
        assert (this.executor.inEventLoop());
        assert (!this.closed);
        try {
            AsyncJms2ProducerFacade.SendAttemptResult result;
            if (this.messageToSend == null) {
                this.messageToSend = this.producer.createBytesMessage();
                this.messageToSend.writeBytes(this.messageContent);
            }
            this.messageToSend.setLongProperty("time", sendTime);
            if (this.group != null) {
                this.messageToSend.setStringProperty("JMSXGroupID", this.group);
            }
            if ((result = this.producer.trySend((Message)this.messageToSend, this, this)) != AsyncJms2ProducerFacade.SendAttemptResult.NotAvailable) {
                this.messageToSend = null;
                if (result == AsyncJms2ProducerFacade.SendAttemptResult.Success && this.waitLatencies != null) {
                    this.waitLatencies.recordValue(sendTime - expectedSendTime);
                }
            }
            return result == AsyncJms2ProducerFacade.SendAttemptResult.Success;
        }
        catch (JMSException e) {
            this.onSendErrored((Exception)((Object)e));
            return false;
        }
    }

    public void onCompletion(Message message) {
        this.asyncOnSendCompleted(message, null);
    }

    public void onException(Message message, Exception exception) {
        this.asyncOnSendCompleted(message, exception);
    }

    private void asyncOnSendCompleted(Message message, Exception completionError) {
        if (this.stopHandlingCompletions) {
            return;
        }
        if (completionError == null) {
            try {
                this.recordSendCompletionLatency(message);
                this.unprocessedCompletions.incrementAndGet();
                this.scheduleProcessingCompletions();
            }
            catch (JMSException jmsException) {
                completionError = jmsException;
            }
        }
        if (completionError != null) {
            this.stopHandlingCompletions = true;
            Throwable fatal = completionError;
            this.executor.execute(() -> this.lambda$asyncOnSendCompleted$0((Exception)fatal));
        }
    }

    private void onSendErrored(Exception fatal) {
        assert (this.executor.inEventLoop());
        if (this.fatalException != null) {
            return;
        }
        this.producer.onSendErrored();
        this.fatalException = fatal;
        this.stopLoad = true;
        this.closed = true;
    }

    private void scheduleProcessingCompletions() {
        if (this.unprocessedCompletions.get() > 0L && this.scheduledProcessingCompletions.compareAndSet(false, true)) {
            this.executor.execute(this::processCompletions);
        }
    }

    private void processCompletions() {
        assert (this.executor.inEventLoop());
        assert (this.scheduledProcessingCompletions.get());
        if (this.fatalException != null) {
            return;
        }
        long completions = this.unprocessedCompletions.getAndSet(0L);
        for (long i = 0L; i < completions; ++i) {
            JMSException completionException = this.producer.onSendCompleted();
            if (completionException == null) continue;
            this.fatalException = completionException;
            return;
        }
        this.scheduledProcessingCompletions.set(false);
        this.scheduleProcessingCompletions();
    }

    private void recordSendCompletionLatency(Message message) throws JMSException {
        long time = message.getLongProperty("time");
        long elapsedMicros = this.timeProvider.now() - time;
        this.sendCompletedLatencies.recordValue(elapsedMicros);
    }

    @Override
    public Future<?> asyncClose(Runnable onClosed) {
        return this.executor.submit(() -> this.onClose(onClosed));
    }

    private void onClose(Runnable onClosed) {
        assert (this.executor.inEventLoop());
        if (this.closed) {
            onClosed.run();
            return;
        }
        this.closed = true;
        this.messageToSend = null;
        this.producer.requestClose(onClosed);
    }

    private /* synthetic */ void lambda$asyncOnSendCompleted$0(Exception fatal) {
        this.onSendErrored(fatal);
    }
}

