/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.impl;

import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleTargetRequest<T>
extends AbstractRequest<T> {
    private static final Log log = LogFactory.getLog(SingleTargetRequest.class);
    private Address target;

    public SingleTargetRequest(ResponseCollector<T> wrapper, long requestId, RequestRepository repository, Address target) {
        super(requestId, wrapper, repository);
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Address sender, Response response) {
        try {
            T result;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                if (this.target != null && !this.target.equals(sender)) {
                    log.tracef("Received unexpected response to request %d from %s, target is %s", this.requestId, sender, this.target);
                }
                result = this.addResponse(sender, response);
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewView(Set<Address> members) {
        try {
            T result;
            ResponseCollector responseCollector = this.responseCollector;
            synchronized (responseCollector) {
                boolean targetIsMissing;
                boolean bl = targetIsMissing = this.target != null && !members.contains(this.target);
                if (!targetIsMissing) {
                    return false;
                }
                result = this.addResponse(this.target, CacheNotFoundResponse.INSTANCE);
            }
            this.complete(result);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return true;
    }

    @GuardedBy(value="responseCollector")
    private T addResponse(Address sender, Response response) {
        this.target = null;
        Object result = this.responseCollector.addResponse(sender, response);
        if (result == null) {
            result = this.responseCollector.finish();
        }
        return result;
    }

    @Override
    protected void onTimeout() {
        String targetString = Objects.toString(this.target);
        this.completeExceptionally((Throwable)((Object)Log.CLUSTER.requestTimedOut(this.requestId, targetString, Util.prettyPrintTime((long)this.getTimeoutMs()))));
    }
}

