/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl;

import jakarta.persistence.Transient;
import java.time.Instant;
import java.util.UUID;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.event.impl.OutboxEventReference;

public final class OutboxEvent {
    private UUID id;
    private String entityName;
    private String entityId;
    private int entityIdHash;
    private byte[] payload;
    private int retries = 0;
    private Instant processAfter;
    private Status status = Status.PENDING;
    @Transient
    private Object originalEntityId;

    protected OutboxEvent() {
    }

    public OutboxEvent(String entityName, String entityId, int entityIdHash, byte[] payload, Object originalEntityId) {
        this.entityName = entityName;
        this.entityId = entityId;
        this.entityIdHash = entityIdHash;
        this.payload = payload;
        this.processAfter = Instant.now();
        this.originalEntityId = originalEntityId;
    }

    public String toString() {
        return "OutboxEvent{id=" + this.id + ", entityName='" + this.entityName + '\'' + ", entityId='" + this.entityId + '\'' + ", entityIdHash='" + this.entityIdHash + '\'' + ", retries=" + this.retries + ", processAfter=" + this.processAfter + ", status=" + (Object)((Object)this.status) + ", originalEntityId=" + this.originalEntityId + '}';
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public int getEntityIdHash() {
        return this.entityIdHash;
    }

    public void setEntityIdHash(int entityIdHash) {
        this.entityIdHash = entityIdHash;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public Instant getProcessAfter() {
        return this.processAfter;
    }

    public void setProcessAfter(Instant processAfter) {
        this.processAfter = processAfter;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Object getOriginalEntityId() {
        return this.originalEntityId;
    }

    public void setOriginalEntityId(Object originalEntityId) {
        this.originalEntityId = originalEntityId;
    }

    OutboxEventReference getReference() {
        return new OutboxEventReference(this.getEntityName(), this.getEntityId());
    }

    public static enum Status {
        PENDING,
        ABORTED;

    }
}

