/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.sso;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.sso.AuthenticationEntry;
import org.wildfly.clustering.web.cache.sso.CompositeSSO;
import org.wildfly.clustering.web.cache.sso.SSOFactory;
import org.wildfly.clustering.web.cache.sso.SessionsFactory;
import org.wildfly.clustering.web.hotrod.logging.Logger;
import org.wildfly.clustering.web.hotrod.sso.AuthenticationKey;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class HotRodSSOFactory<AV, SV, A, D, S, L>
implements SSOFactory<Map.Entry<A, AtomicReference<L>>, SV, A, D, S, L> {
    private final SessionsFactory<SV, D, S> sessionsFactory;
    private final RemoteCache<AuthenticationKey, AuthenticationEntry<AV, L>> cache;
    private final Flag[] ignoreReturnFlags;
    private final Marshaller<A, AV> marshaller;
    private final Supplier<L> localContextFactory;

    public HotRodSSOFactory(HotRodConfiguration configuration, Marshaller<A, AV> marshaller, Supplier<L> localContextFactory, SessionsFactory<SV, D, S> sessionsFactory) {
        this.cache = configuration.getCache();
        this.ignoreReturnFlags = configuration.getIgnoreReturnFlags();
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
        this.sessionsFactory = sessionsFactory;
    }

    public SSO<A, D, S, L> createSSO(String id, Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> value) {
        Map.Entry<A, AtomicReference<L>> authenticationEntry = value.getKey();
        Sessions sessions = this.sessionsFactory.createSessions(id, value.getValue());
        return new CompositeSSO(id, authenticationEntry.getKey(), sessions, authenticationEntry.getValue(), this.localContextFactory, (Remover)this);
    }

    public Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> createValue(String id, A authentication) {
        try {
            AuthenticationEntry entry = new AuthenticationEntry(this.marshaller.write(authentication));
            this.cache.withFlags(this.ignoreReturnFlags).put((Object)new AuthenticationKey(id), (Object)entry);
            Object sessions = this.sessionsFactory.createValue((Object)id, null);
            return new AbstractMap.SimpleImmutableEntry<AbstractMap.SimpleImmutableEntry<A, AtomicReference>, Object>(new AbstractMap.SimpleImmutableEntry<A, AtomicReference>(authentication, entry.getLocalContext()), sessions);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map.Entry<Map.Entry<A, AtomicReference<L>>, SV> findValue(String id) {
        Object sessions;
        AuthenticationEntry entry = (AuthenticationEntry)this.cache.get((Object)new AuthenticationKey(id));
        if (entry != null && (sessions = this.sessionsFactory.findValue((Object)id)) != null) {
            try {
                Object authentication = this.marshaller.read(entry.getAuthentication());
                return new AbstractMap.SimpleImmutableEntry<AbstractMap.SimpleImmutableEntry<Object, AtomicReference>, Object>(new AbstractMap.SimpleImmutableEntry<Object, AtomicReference>(authentication, entry.getLocalContext()), sessions);
            }
            catch (IOException e) {
                Logger.ROOT_LOGGER.failedToActivateAuthentication(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public boolean remove(String id) {
        this.cache.withFlags(this.ignoreReturnFlags).remove((Object)new AuthenticationKey(id));
        this.sessionsFactory.remove((Object)id);
        return true;
    }

    public SessionsFactory<SV, D, S> getSessionsFactory() {
        return this.sessionsFactory;
    }
}

