/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.IOException;
import java.util.Map;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;

public interface ProcessMessageHandler {
    public void handleProcessAdded(ProcessControllerClient var1, String var2);

    public void handleProcessStarted(ProcessControllerClient var1, String var2);

    public void handleProcessStopped(ProcessControllerClient var1, String var2, long var3);

    public void handleProcessRemoved(ProcessControllerClient var1, String var2);

    public void handleProcessInventory(ProcessControllerClient var1, Map<String, ProcessInfo> var2);

    public void handleConnectionShutdown(ProcessControllerClient var1);

    public void handleConnectionFailure(ProcessControllerClient var1, IOException var2);

    public void handleConnectionFinished(ProcessControllerClient var1);

    public void handleOperationFailed(ProcessControllerClient var1, OperationType var2, String var3);

    public static enum OperationType {
        ADD(16),
        INVENTORY(21),
        REMOVE(19),
        RECONNECT(22),
        SEND_STDIN(20),
        START(17),
        STOP(18);

        final int code;

        private OperationType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static OperationType fromCode(int code) {
            for (OperationType type : OperationType.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return null;
        }
    }
}

