/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.group;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.infinispan.protostream.descriptors.WireType;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Writable;
import org.wildfly.clustering.server.infinispan.group.AddressMarshaller;
import org.wildfly.clustering.server.infinispan.group.AddressableNode;

public class AddressableNodeMarshaller
implements ProtoStreamMarshaller<AddressableNode> {
    private static final int ADDRESS_INDEX = 1;
    private static final int NAME_INDEX = AddressMarshaller.INSTANCE.nextIndex(1);
    private static final int SOCKET_ADDRESS_INDEX = NAME_INDEX + 1;

    public AddressableNode readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader addressReader = reader.createFieldSetReader((FieldReadable)AddressMarshaller.INSTANCE, 1);
        Address address = null;
        String name = null;
        InetSocketAddress socketAddress = null;
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (addressReader.contains(index)) {
                address = (Address)addressReader.readField(address);
                continue;
            }
            if (index == NAME_INDEX) {
                name = reader.readString();
                continue;
            }
            if (index == SOCKET_ADDRESS_INDEX) {
                IpAddress ipAddress = (IpAddress)reader.readObject(IpAddress.class);
                socketAddress = new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort());
                continue;
            }
            reader.skipField(tag);
        }
        return address instanceof IpAddress ? new AddressableNode((IpAddress)address, name) : new AddressableNode(address, name, socketAddress);
    }

    public void writeTo(ProtoStreamWriter writer, AddressableNode member) throws IOException {
        Address address = member.getAddress();
        writer.createFieldSetWriter((Writable)AddressMarshaller.INSTANCE, 1).writeFields((Object)address);
        writer.writeString(NAME_INDEX, member.getName());
        if (!(address instanceof IpAddress)) {
            writer.writeObject(SOCKET_ADDRESS_INDEX, (Object)new IpAddress(member.getSocketAddress()));
        }
    }

    public Class<? extends AddressableNode> getJavaClass() {
        return AddressableNode.class;
    }
}

