/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Reflections;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.util.cache.ComputingCache;

public class WeldClassFileInfo
implements ClassFileInfo {
    private static final DotName DOT_NAME_INJECT = DotName.createSimple((String)Inject.class.getName());
    private static final DotName DOT_NAME_VETOED = DotName.createSimple((String)Vetoed.class.getName());
    private static final DotName OBJECT_NAME = DotName.createSimple((String)Object.class.getName());
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final String PACKAGE_INFO_NAME = "package-info";
    private final ClassInfo classInfo;
    private final CompositeIndex index;
    private final boolean isVetoed;
    private final boolean hasCdiConstructor;
    private final ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader classLoader;

    public WeldClassFileInfo(String className, CompositeIndex index, ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache, ClassLoader classLoader) {
        this.index = index;
        this.annotationClassAnnotationsCache = annotationClassAnnotationsCache;
        this.classInfo = index.getClassByName(DotName.createSimple((String)className));
        if (this.classInfo == null) {
            throw WeldLogger.ROOT_LOGGER.nameNotFoundInIndex(className);
        }
        this.isVetoed = this.isVetoedTypeOrPackage();
        this.hasCdiConstructor = this.classInfo.hasNoArgsConstructor() || this.hasInjectConstructor();
        this.classLoader = classLoader;
    }

    public String getClassName() {
        return this.classInfo.name().toString();
    }

    public boolean isAnnotationDeclared(Class<? extends Annotation> annotation) {
        return this.isAnnotationDeclared(this.classInfo, annotation);
    }

    public boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return this.containsAnnotation(this.classInfo, DotName.createSimple((String)annotation.getName()), annotation);
    }

    public int getModifiers() {
        return this.classInfo.flags();
    }

    public boolean hasCdiConstructor() {
        return this.hasCdiConstructor;
    }

    public boolean isAssignableFrom(Class<?> fromClass) {
        return this.isAssignableFrom(this.getClassName(), fromClass);
    }

    public boolean isAssignableTo(Class<?> toClass) {
        return this.isAssignableTo(this.classInfo.name(), toClass);
    }

    public boolean isVetoed() {
        return this.isVetoed;
    }

    public ClassFileInfo.NestingType getNestingType() {
        ClassFileInfo.NestingType result = null;
        switch (this.classInfo.nestingType()) {
            case ANONYMOUS: {
                result = ClassFileInfo.NestingType.NESTED_ANONYMOUS;
                break;
            }
            case TOP_LEVEL: {
                result = ClassFileInfo.NestingType.TOP_LEVEL;
                break;
            }
            case LOCAL: {
                result = ClassFileInfo.NestingType.NESTED_LOCAL;
                break;
            }
            case INNER: {
                if (Modifier.isStatic(this.classInfo.flags())) {
                    result = ClassFileInfo.NestingType.NESTED_STATIC;
                    break;
                }
                result = ClassFileInfo.NestingType.NESTED_INNER;
                break;
            }
        }
        return result;
    }

    public String getSuperclassName() {
        return this.classInfo.superName().toString();
    }

    private boolean isVetoedTypeOrPackage() {
        if (this.isAnnotationDeclared(this.classInfo, DOT_NAME_VETOED)) {
            return true;
        }
        DotName packageInfoName = DotName.createComponentized((DotName)this.getPackageName(this.classInfo.name()), (String)PACKAGE_INFO_NAME);
        ClassInfo packageInfo = this.index.getClassByName(packageInfoName);
        return packageInfo != null && this.isAnnotationDeclared(packageInfo, DOT_NAME_VETOED);
    }

    private boolean isAnnotationDeclared(ClassInfo classInfo, Class<? extends Annotation> annotation) {
        return this.isAnnotationDeclared(classInfo, DotName.createSimple((String)annotation.getName()));
    }

    private boolean isAnnotationDeclared(ClassInfo classInfo, DotName requiredAnnotationName) {
        List annotations = (List)classInfo.annotationsMap().get(requiredAnnotationName);
        if (annotations != null) {
            for (AnnotationInstance annotationInstance : annotations) {
                if (!annotationInstance.target().equals(classInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasInjectConstructor() {
        List annotationInstances = (List)this.classInfo.annotationsMap().get(DOT_NAME_INJECT);
        if (annotationInstances != null) {
            for (AnnotationInstance instance : annotationInstances) {
                MethodInfo methodInfo;
                AnnotationTarget target = instance.target();
                if (!(target instanceof MethodInfo) || !(methodInfo = (MethodInfo)target).name().equals(CONSTRUCTOR_METHOD_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    private DotName getPackageName(DotName name) {
        if (name.isComponentized()) {
            while (name.isInner()) {
                if ((name = name.prefix()) != null) continue;
                throw new IllegalStateException("Could not determine package from corrupted class name");
            }
            return name.prefix();
        }
        int lastIndex = name.local().lastIndexOf(".");
        if (lastIndex == -1) {
            return name;
        }
        return DotName.createSimple((String)name.local().substring(0, name.local().lastIndexOf(".")));
    }

    private boolean isAssignableFrom(String className, Class<?> fromClass) {
        if (className.equals(fromClass.getName())) {
            return true;
        }
        if (Object.class.equals(fromClass)) {
            return false;
        }
        Class<?> superClass = fromClass.getSuperclass();
        if (superClass != null && this.isAssignableFrom(className, superClass)) {
            return true;
        }
        for (Class<?> interfaceClass : fromClass.getInterfaces()) {
            if (!this.isAssignableFrom(className, interfaceClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableTo(DotName name, Class<?> to) {
        if (to.getName().equals(name.toString())) {
            return true;
        }
        if (OBJECT_NAME.equals((Object)name)) {
            return false;
        }
        ClassInfo fromClassInfo = this.index.getClassByName(name);
        if (fromClassInfo == null) {
            Class<?> clazz = this.loadClass(name.toString());
            return to.isAssignableFrom(clazz);
        }
        DotName superName = fromClassInfo.superName();
        if (superName != null && this.isAssignableTo(superName, to)) {
            return true;
        }
        for (DotName interfaceName : fromClassInfo.interfaceNames()) {
            if (!this.isAssignableTo(interfaceName, to)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnnotation(ClassInfo classInfo, DotName requiredAnnotationName, Class<? extends Annotation> requiredAnnotation) {
        if (classInfo.annotationsMap().containsKey(requiredAnnotationName)) {
            return true;
        }
        for (DotName annotation : classInfo.annotationsMap().keySet()) {
            if (!((Set)this.annotationClassAnnotationsCache.getValue((Object)annotation)).contains(requiredAnnotationName.toString())) continue;
            return true;
        }
        DotName superName = classInfo.superName();
        if (superName != null && !OBJECT_NAME.equals((Object)superName)) {
            ClassInfo superClassInfo = this.index.getClassByName(superName);
            if (superClassInfo == null) {
                return Reflections.containsAnnotation(this.loadClass(superName.toString()), requiredAnnotation);
            }
            if (this.containsAnnotation(superClassInfo, requiredAnnotationName, requiredAnnotation)) {
                return true;
            }
        }
        for (DotName interfaceName : classInfo.interfaceNames()) {
            ClassInfo interfaceInfo = this.index.getClassByName(interfaceName);
            if (interfaceInfo == null) {
                Class<?> interfaceClass = this.loadClass(interfaceName.toString());
                for (Method method : interfaceClass.getDeclaredMethods()) {
                    if (!method.isDefault() || !Reflections.containsAnnotations((Annotation[])method.getAnnotations(), requiredAnnotation)) continue;
                    return true;
                }
                continue;
            }
            for (MethodInfo method : interfaceInfo.methods()) {
                if (!this.isNonAbstractPublicInstanceMethod(method)) continue;
                if (method.hasAnnotation(requiredAnnotationName)) {
                    return true;
                }
                for (AnnotationInstance annotation : method.annotations()) {
                    if (!((Set)this.annotationClassAnnotationsCache.getValue((Object)annotation.name())).contains(requiredAnnotationName.toString())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNonAbstractPublicInstanceMethod(MethodInfo method) {
        return (method.flags() & 0x409) == 1;
    }

    private Class<?> loadClass(String className) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("Falling back to reflection for %s", (Object)className);
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw WeldLogger.ROOT_LOGGER.cannotLoadClass(className, (Throwable)e);
        }
    }

    public String toString() {
        return this.classInfo.toString();
    }
}

