/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cfg.HibernateOrmMapperOutboxPollingSettings;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cfg.impl.UuidDataTypeUtils;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.cluster.impl.AgentType;
import org.hibernate.search.mapper.orm.coordination.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxPollingAgentAdditionalJaxbMappingProducer
implements HibernateSearchOrmMappingProducer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String HIBERNATE_SEARCH = "hibernate-search";
    public static final String CLASS_NAME;
    public static final String ENTITY_NAME;
    private static final String ENTITY_DEFINITION_TEMPLATE;
    public static final String ENTITY_DEFINITION;
    private static final OptionalConfigurationProperty<String> AGENT_ENTITY_MAPPING;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_SCHEMA;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_CATALOG;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_TABLE;
    private static final OptionalConfigurationProperty<UuidGenerationStrategy> ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_UUID_TYPE;

    @SuppressForbiddenApis(reason="Strangely, this SPI involves the internal MappingBinder class, and there's nothing we can do about it")
    public Collection<MappingDocument> produceMappings(ConfigurationPropertySource propertySource, Dialect dialect, MappingBinder mappingBinder, MetadataBuildingContext buildingContext) {
        Optional mapping = (Optional)AGENT_ENTITY_MAPPING.get(propertySource);
        Optional schema = (Optional)ENTITY_MAPPING_AGENT_SCHEMA.get(propertySource);
        Optional catalog = (Optional)ENTITY_MAPPING_AGENT_CATALOG.get(propertySource);
        Optional table = (Optional)ENTITY_MAPPING_AGENT_TABLE.get(propertySource);
        Optional uuidStrategy = (Optional)ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.get(propertySource);
        Optional uuidType = (Optional)ENTITY_MAPPING_AGENT_UUID_TYPE.get(propertySource);
        if (mapping.isPresent() && (schema.isPresent() || catalog.isPresent() || table.isPresent() || uuidStrategy.isPresent() || uuidType.isPresent())) {
            throw log.agentConfigurationPropertyConflict(AGENT_ENTITY_MAPPING.resolveOrRaw(propertySource), new String[]{ENTITY_MAPPING_AGENT_SCHEMA.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_CATALOG.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_TABLE.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_TYPE.resolveOrRaw(propertySource)});
        }
        String resolvedUuidType = UuidDataTypeUtils.uuidType(uuidType.orElse("default"), dialect);
        String entityDefinition = mapping.orElseGet(() -> String.format(Locale.ROOT, ENTITY_DEFINITION_TEMPLATE, schema.orElse(""), catalog.orElse(""), table.orElse("HSEARCH_AGENT"), uuidStrategy.orElse(HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY).strategy(), resolvedUuidType));
        log.agentGeneratedEntityMapping(entityDefinition);
        Origin origin = new Origin(SourceType.OTHER, "search");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(entityDefinition.getBytes());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        Binding binding = mappingBinder.bind((InputStream)bufferedInputStream, origin);
        JaxbHbmHibernateMapping root = (JaxbHbmHibernateMapping)binding.getRoot();
        MappingDocument mappingDocument = new MappingDocument(HIBERNATE_SEARCH, root, origin, buildingContext);
        return Collections.singletonList(mappingDocument);
    }

    static {
        ENTITY_NAME = CLASS_NAME = Agent.class.getName();
        ENTITY_DEFINITION_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<hibernate-mapping schema=\"%1$s\" catalog=\"%2$s\">\n    <class name=\"" + CLASS_NAME + "\" entity-name=\"" + ENTITY_NAME + "\" table=\"%3$s\">\n        <id name=\"id\" type=\"%5$s\">\n            <generator class=\"org.hibernate.id.UUIDGenerator\">\n                <param name=\"uuid_gen_strategy_class\">%4$s</param>\n            </generator>\n        </id>\n        <property name=\"type\" nullable=\"false\">\n            <type name=\"org.hibernate.type.EnumType\">\n                <param name=\"enumClass\">" + AgentType.class.getName() + "</param>\n            </type>\n        </property>\n        <property name=\"name\" nullable=\"false\" />\n        <property name=\"expiration\" nullable=\"false\" />\n        <property name=\"state\" nullable=\"false\">\n            <type name=\"org.hibernate.type.EnumType\">\n                <param name=\"enumClass\">" + AgentState.class.getName() + "</param>\n            </type>\n        </property>\n        <property name=\"totalShardCount\" nullable=\"true\" />\n        <property name=\"assignedShardIndex\" nullable=\"true\" />\n        <property name=\"payload\" nullable=\"true\" type=\"materialized_blob\">\n                <column length=\"2147483647\" />\n        </property>\n    </class>\n</hibernate-mapping>\n";
        ENTITY_DEFINITION = String.format(Locale.ROOT, ENTITY_DEFINITION_TEMPLATE, new Object[]{"", "", "HSEARCH_AGENT", HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY, "uuid-char"});
        AGENT_ENTITY_MAPPING = ConfigurationProperty.forKey((String)"agent.entity.mapping").asString().build();
        ENTITY_MAPPING_AGENT_SCHEMA = ConfigurationProperty.forKey((String)"entity.mapping.agent.schema").asString().build();
        ENTITY_MAPPING_AGENT_CATALOG = ConfigurationProperty.forKey((String)"entity.mapping.agent.catalog").asString().build();
        ENTITY_MAPPING_AGENT_TABLE = ConfigurationProperty.forKey((String)"entity.mapping.agent.table").asString().build();
        ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY = ConfigurationProperty.forKey((String)"entity.mapping.agent.uuid_gen_strategy").as(UuidGenerationStrategy.class, UuidGenerationStrategy::of).build();
        ENTITY_MAPPING_AGENT_UUID_TYPE = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.uuid_type").asString().build();
    }
}

