/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.cli.command.aesh.CLICompleterInvocation;
import org.wildfly.core.cli.command.aesh.activator.AbstractOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DomainOptionActivator;
import org.wildfly.core.instmgr.cli.CandidatesProviders;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="abstract-inst-mgr-cmd", description="", activator=InstMgrActivator.class)
public abstract class AbstractInstMgrCommand
implements Command<CLICommandInvocation> {
    static final PathElement CORE_SERVICE_INSTALLER = PathElement.pathElement((String)"core-service", (String)"installer");
    @Option(name="host", completer=HostsCompleter.class, activator=HostsActivator.class)
    protected String host;

    protected ModelNode executeOp(CommandContext ctx, String host) throws CommandException {
        ModelNode response;
        if (host != null && !ctx.isDomainMode()) {
            throw new CommandException("The --host option is not available in the current context. Connection to the controller might be unavailable or not running in domain mode.");
        }
        if (host == null && ctx.isDomainMode()) {
            throw new CommandException("The --host option must be used in domain mode.");
        }
        PathAddress address = ctx.isDomainMode() ? AbstractInstMgrCommand.createHost(host, ctx.getModelControllerClient()) : AbstractInstMgrCommand.createStandalone();
        Operation request = this.buildOperation();
        request.getOperation().get("address").set(address.toModelNode());
        try {
            response = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException ex) {
            throw new CommandException("Failed to execute the Operation " + request.getOperation().asString(), (Throwable)ex);
        }
        finally {
            try {
                request.close();
            }
            catch (Throwable t) {
                throw new CommandException("Failed to close the operation resource.", t);
            }
        }
        if (!Util.isSuccess((ModelNode)response)) {
            throw new CommandException(Util.getFailureDescription((ModelNode)response));
        }
        return response;
    }

    protected abstract Operation buildOperation() throws CommandException;

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        throw new CommandException("Command action is missing.");
    }

    private static PathAddress createStandalone() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{CORE_SERVICE_INSTALLER});
    }

    private static PathAddress createHost(String hostName, ModelControllerClient client) {
        PathElement host = PathElement.pathElement((String)"host", (String)hostName);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{host, CORE_SERVICE_INSTALLER});
        return address;
    }

    static void addRepositoriesToModelNode(ModelNode op, List<String> repositories) throws CommandException {
        if (repositories == null || repositories.isEmpty()) {
            return;
        }
        ModelNode repositoriesMn = new ModelNode().addEmptyList();
        for (int i = 0; i < repositories.size(); ++i) {
            String repoStr = repositories.get(i);
            ModelNode repositoryMn = new ModelNode();
            String[] split = repoStr.split("::");
            try {
                String urlStr;
                Object idStr;
                if (split.length == 1) {
                    new URL(repoStr);
                    idStr = "id" + i;
                    urlStr = repoStr;
                } else if (split.length == 2) {
                    idStr = split[0];
                    urlStr = split[1];
                } else {
                    throw new IllegalArgumentException();
                }
                repositoryMn.get("id").set((String)idStr);
                repositoryMn.get("url").set(urlStr);
                repositoriesMn.add(repositoryMn);
                continue;
            }
            catch (Exception w) {
                throw new CommandException("Invalid Repository URL. Valid values are either URLs or ID::URL");
            }
        }
        op.get("repositories").set(repositoriesMn);
    }

    static void addManifestToModelNode(ModelNode modelNode, String manifest) {
        if (manifest == null || "".equals(manifest)) {
            return;
        }
        try {
            ModelNode manifestMn = new ModelNode();
            if (AbstractInstMgrCommand.isValidUrl(manifest)) {
                manifestMn.get("url").set(manifest);
            } else if (AbstractInstMgrCommand.isValidCoordinate(manifest)) {
                manifestMn.get("gav").set(manifest);
            } else {
                String validUrlFromPath = AbstractInstMgrCommand.isValidUrlFromPath(manifest);
                if (validUrlFromPath != null) {
                    manifestMn.get("url").set(validUrlFromPath);
                } else {
                    throw new IllegalArgumentException("Invalid manifest format. It can be an URL, Maven GAV or path");
                }
            }
            modelNode.get("manifest").set(manifestMn);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid manifest format. It can be an URL, Maven GAV or path");
        }
    }

    static boolean isValidUrl(String urlGavOrPath) {
        try {
            new URL(urlGavOrPath);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    static String isValidUrlFromPath(String urlGavOrPath) {
        try {
            return Paths.get(urlGavOrPath, new String[0]).toUri().toURL().toString();
        }
        catch (MalformedURLException | InvalidPathException e) {
            return null;
        }
    }

    static boolean isValidCoordinate(String gav) {
        String[] parts;
        if (gav.contains("\\") || gav.contains("/")) {
            return false;
        }
        for (String part : parts = gav.split(":")) {
            if (part != null && !"".equals(part)) continue;
            return false;
        }
        return parts.length == 2 || parts.length == 3;
    }

    public static class HostsCompleter
    implements OptionCompleter<CLICompleterInvocation> {
        public void complete(CLICompleterInvocation completerInvocation) {
            ArrayList<String> values = new ArrayList<String>();
            Collection<String> candidates = this.getCandidates(completerInvocation.getCommandContext());
            String opBuffer = completerInvocation.getGivenCompleteValue();
            if (opBuffer.isEmpty()) {
                values.addAll(candidates);
            } else {
                for (String name : candidates) {
                    if (!name.startsWith(opBuffer)) continue;
                    values.add(name);
                }
                Collections.sort(values);
            }
            completerInvocation.addAllCompleterValues(values);
        }

        private Collection<String> getCandidates(CommandContext ctx) {
            return CandidatesProviders.HOSTS.getAllCandidates(ctx);
        }
    }

    public static class ConfirmActivator
    extends AbstractRejectOptionActivator {
        public ConfirmActivator() {
            super(new String[]{"dry-run"});
        }
    }

    public static class DryRunActivator
    extends AbstractRejectOptionActivator {
        public DryRunActivator() {
            super(new String[]{"confirm"});
        }
    }

    public static class HostsActivator
    extends AbstractOptionActivator
    implements DomainOptionActivator {
        public boolean isActivated(ParsedCommand processedCommand) {
            return this.getCommandContext().getModelControllerClient() != null && this.getCommandContext().isDomainMode();
        }
    }
}

