/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.BaseRequest;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.DeleteShareSnapshotsOption;
import com.microsoft.azure.storage.file.FileDirectoryProperties;
import com.microsoft.azure.storage.file.FileProperties;
import com.microsoft.azure.storage.file.FileRange;
import com.microsoft.azure.storage.file.FileRangeOperationType;
import com.microsoft.azure.storage.file.FileRequestOptions;
import com.microsoft.azure.storage.file.FileShareProperties;
import com.microsoft.azure.storage.file.NtfsAttributes;
import com.microsoft.azure.storage.file.ShareListingDetails;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;

final class FileRequest {
    private static final String RANGE_QUERY_ELEMENT_NAME = "range";
    private static final String RANGE_LIST_QUERY_ELEMENT_NAME = "rangelist";
    private static final String SNAPSHOTS_QUERY_ELEMENT_NAME = "snapshots";

    public static HttpURLConnection abortCopy(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String copyId) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "copy");
        builder.add("copyid", copyId);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-action", "abort");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static void addMetadata(HttpURLConnection request, Map<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    private static void addProperties(HttpURLConnection request, FileProperties properties) {
        BaseRequest.addOptionalHeader(request, "x-ms-cache-control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "x-ms-content-disposition", properties.getContentDisposition());
        BaseRequest.addOptionalHeader(request, "x-ms-content-encoding", properties.getContentEncoding());
        BaseRequest.addOptionalHeader(request, "x-ms-content-language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "x-ms-content-md5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "x-ms-content-type", properties.getContentType());
    }

    private static void addFilePermissionOrFilePermissionKey(HttpURLConnection request, String filePermissionKey, String filePermission, String defaultFilePermission) {
        if (filePermission == null && filePermissionKey == null) {
            request.setRequestProperty("x-ms-file-permission", defaultFilePermission);
        } else if (filePermission != null) {
            request.setRequestProperty("x-ms-file-permission", filePermission);
        } else {
            request.setRequestProperty("x-ms-file-permission-key", filePermissionKey);
        }
    }

    private static void setHeaderValueOrDefault(HttpURLConnection request, String headerKey, String value, String defaultValue) {
        if (value != null && !value.equals("")) {
            request.setRequestProperty(headerKey, value);
        } else {
            request.setRequestProperty(headerKey, defaultValue);
        }
    }

    public static void addShareSnapshot(UriQueryBuilder builder, String snapshotVersion) throws StorageException {
        if (snapshotVersion != null) {
            builder.add("sharesnapshot", snapshotVersion);
        }
    }

    public static HttpURLConnection copyFrom(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, String source) throws StorageException, IOException, URISyntaxException {
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, null, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-source", source);
        if (sourceAccessCondition != null) {
            sourceAccessCondition.applyConditionToRequest(request);
        }
        if (destinationAccessCondition != null) {
            destinationAccessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    private static void addProperties(HttpURLConnection request, FileShareProperties properties) {
        Integer shareQuota = properties.getShareQuota();
        BaseRequest.addOptionalHeader(request, "x-ms-share-quota", shareQuota == null ? null : shareQuota.toString());
    }

    public static HttpURLConnection createShare(URI uri, FileRequestOptions fileOptions, OperationContext opContext, FileShareProperties properties) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder shareBuilder = FileRequest.getShareUriQueryBuilder();
        HttpURLConnection request = BaseRequest.create(uri, fileOptions, shareBuilder, opContext);
        FileRequest.addProperties(request, properties);
        return request;
    }

    public static HttpURLConnection deleteFile(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        HttpURLConnection request = BaseRequest.delete(uri, fileOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection deleteShare(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion, DeleteShareSnapshotsOption deleteSnapshotsOption) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder shareBuilder = FileRequest.getShareUriQueryBuilder();
        FileRequest.addShareSnapshot(shareBuilder, snapshotVersion);
        HttpURLConnection request = BaseRequest.delete(uri, fileOptions, shareBuilder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        switch (deleteSnapshotsOption) {
            case NONE: {
                break;
            }
            case INCLUDE_SNAPSHOTS: {
                request.setRequestProperty("x-ms-delete-snapshots", "include");
                break;
            }
        }
        return request;
    }

    public static HttpURLConnection getAcl(URI uri, FileRequestOptions fileOptions, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = FileRequest.getShareUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getFile(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion, Long offset, Long count, boolean requestRangeContentMD5) throws IOException, URISyntaxException, StorageException {
        if (offset != null && requestRangeContentMD5) {
            Utility.assertNotNull("count", count);
            Utility.assertInBounds("count", count, 1L, Constants.MAX_RANGE_CONTENT_MD5);
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (offset != null) {
            long rangeStart = offset;
            if (count != null) {
                long rangeEnd = offset + count - 1L;
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-%d", rangeStart, rangeEnd));
            } else {
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-", rangeStart));
            }
        }
        if (offset != null && requestRangeContentMD5) {
            request.setRequestProperty("x-ms-range-get-content-md5", "true");
        }
        return request;
    }

    public static HttpURLConnection getFileProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        return FileRequest.getProperties(uri, fileOptions, opContext, accessCondition, builder, snapshotVersion);
    }

    public static HttpURLConnection getFileRanges(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        builder.add("comp", RANGE_LIST_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getShareProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder shareBuilder = FileRequest.getShareUriQueryBuilder();
        return FileRequest.getProperties(uri, fileOptions, opContext, accessCondition, shareBuilder, snapshotVersion);
    }

    public static HttpURLConnection getShareStats(URI uri, FileRequestOptions options, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder shareBuilder = FileRequest.getShareUriQueryBuilder();
        shareBuilder.add("comp", "stats");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(uri, options, shareBuilder, opContext);
        retConnection.setRequestMethod("GET");
        return retConnection;
    }

    private static UriQueryBuilder getShareUriQueryBuilder() throws StorageException {
        UriQueryBuilder uriBuilder = new UriQueryBuilder();
        try {
            uriBuilder.add("restype", "share");
        }
        catch (IllegalArgumentException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        return uriBuilder;
    }

    private static UriQueryBuilder getDirectoryUriQueryBuilder() throws StorageException {
        UriQueryBuilder uriBuilder = new UriQueryBuilder();
        try {
            uriBuilder.add("restype", "directory");
        }
        catch (IllegalArgumentException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        return uriBuilder;
    }

    private static HttpURLConnection getProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, UriQueryBuilder builder, String snapshotVersion) throws IOException, URISyntaxException, StorageException {
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.getProperties(uri, fileOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection listShares(URI uri, FileRequestOptions fileOptions, OperationContext opContext, ListingContext listingContext, EnumSet<ShareListingDetails> detailsIncluded) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = BaseRequest.getListUriQueryBuilder(listingContext);
        if (detailsIncluded != null && detailsIncluded.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean started = false;
            if (detailsIncluded.contains((Object)ShareListingDetails.SNAPSHOTS)) {
                started = true;
                sb.append(SNAPSHOTS_QUERY_ELEMENT_NAME);
            }
            if (detailsIncluded.contains((Object)ShareListingDetails.METADATA)) {
                if (started) {
                    sb.append(",");
                }
                sb.append("metadata");
            }
            builder.add("include", sb.toString());
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setShareMetadata(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder shareBuilder = FileRequest.getShareUriQueryBuilder();
        return FileRequest.setMetadata(uri, fileOptions, opContext, accessCondition, shareBuilder);
    }

    public static HttpURLConnection setDirectoryMetadata(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder directoryBuilder = FileRequest.getDirectoryUriQueryBuilder();
        return FileRequest.setMetadata(uri, fileOptions, opContext, accessCondition, directoryBuilder);
    }

    public static HttpURLConnection createDirectory(URI uri, FileRequestOptions fileOptions, OperationContext opContext, FileDirectoryProperties properties, String filePermission) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder directoryBuilder = FileRequest.getDirectoryUriQueryBuilder();
        HttpURLConnection request = BaseRequest.create(uri, fileOptions, directoryBuilder, opContext);
        if (properties != null) {
            FileRequest.addFilePermissionOrFilePermissionKey(request, properties.filePermissionKeyToSet, filePermission, "Inherit");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-attributes", NtfsAttributes.toString(properties.ntfsAttributesToSet), "None");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-creation-time", properties.creationTimeToSet, "Now");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-last-write-time", properties.lastWriteTimeToSet, "Now");
        }
        return request;
    }

    public static HttpURLConnection deleteDirectory(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder directoryBuilder = FileRequest.getDirectoryUriQueryBuilder();
        HttpURLConnection request = BaseRequest.delete(uri, fileOptions, directoryBuilder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getDirectoryProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder directoryBuilder = FileRequest.getDirectoryUriQueryBuilder();
        return FileRequest.getProperties(uri, fileOptions, opContext, accessCondition, directoryBuilder, snapshotVersion);
    }

    public static HttpURLConnection listFilesAndDirectories(URI uri, FileRequestOptions fileOptions, OperationContext opContext, ListingContext listingContext, String snapshotVersion) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = FileRequest.getDirectoryUriQueryBuilder();
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix().toString());
            }
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection putFile(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, FileProperties properties, long fileSize, String filePermission) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, null, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (properties != null) {
            FileRequest.addProperties(request, properties);
            FileRequest.addFilePermissionOrFilePermissionKey(request, properties.filePermissionKeyToSet, filePermission, "Inherit");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-attributes", NtfsAttributes.toString(properties.ntfsAttributesToSet), "None");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-creation-time", properties.creationTimeToSet, "Now");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-last-write-time", properties.lastWriteTimeToSet, "Now");
        }
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("Content-Length", "0");
        request.setRequestProperty("x-ms-type", "File");
        request.setRequestProperty("x-ms-content-length", String.valueOf(fileSize));
        properties.setLength(fileSize);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putRange(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, FileRange range, FileRangeOperationType operationType) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", RANGE_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (operationType == FileRangeOperationType.CLEAR) {
            request.setFixedLengthStreamingMode(0);
        }
        request.setRequestProperty("x-ms-write", operationType.toString());
        request.setRequestProperty("x-ms-range", range.toString());
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putRangeFromURL(URI uri, FileRequestOptions fileOptions, OperationContext opContext, FileRange range, URI sourceUri, FileRange sourceRange) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", RANGE_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-write", FileRangeOperationType.UPDATE.toString());
        request.setRequestProperty("x-ms-range", range.toString());
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("Content-Length", "0");
        request.setRequestProperty("x-ms-copy-source", sourceUri.toString());
        request.setRequestProperty("x-ms-source-range", sourceRange.toString());
        return request;
    }

    public static HttpURLConnection setShareProperties(URI uri, FileRequestOptions options, OperationContext opContext, AccessCondition accessCondition, FileShareProperties properties) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = FileRequest.getShareUriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, options, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (properties != null) {
            FileRequest.addProperties(request, properties);
        }
        return request;
    }

    public static HttpURLConnection resize(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, Long newFileSize) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = FileRequest.setFileProperties(uri, fileOptions, opContext, accessCondition, null, null);
        if (newFileSize != null) {
            request.setRequestProperty("x-ms-content-length", newFileSize.toString());
        }
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = FileRequest.getShareUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestMethod("PUT");
        request.setDoOutput(true);
        if (accessCondition != null && !Utility.isNullOrEmpty(accessCondition.getLeaseID())) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    private static HttpURLConnection setMetadata(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, UriQueryBuilder builder) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.setMetadata(uri, fileOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setFileMetadata(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        return FileRequest.setMetadata(uri, fileOptions, opContext, accessCondition, null);
    }

    public static HttpURLConnection snapshotShare(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("restype", "share");
        builder.add("comp", "snapshot");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setFileProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, FileProperties properties, String filePermission) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (properties != null) {
            FileRequest.addProperties(request, properties);
            FileRequest.addFilePermissionOrFilePermissionKey(request, properties.filePermissionKeyToSet, filePermission, "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-attributes", NtfsAttributes.toString(properties.ntfsAttributesToSet), "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-creation-time", properties.creationTimeToSet, "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-last-write-time", properties.lastWriteTimeToSet, "Preserve");
        } else {
            request.setRequestProperty("x-ms-file-permission", "Preserve");
            request.setRequestProperty("x-ms-file-attributes", "Preserve");
            request.setRequestProperty("x-ms-file-creation-time", "Preserve");
            request.setRequestProperty("x-ms-file-last-write-time", "Preserve");
        }
        return request;
    }

    public static HttpURLConnection listHandles(URI uri, FileRequestOptions fileOptions, OperationContext opContext, ListingContext listingContext, Boolean recursive, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        builder.add("comp", "listhandles");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        if (recursive != null && recursive.booleanValue()) {
            request.setRequestProperty("x-ms-recursive", "true");
        }
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection closeHandles(URI uri, FileRequestOptions fileOptions, OperationContext opContext, ListingContext listingContext, String handleID, Boolean recursive, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        FileRequest.addShareSnapshot(builder, snapshotVersion);
        builder.add("comp", "forceclosehandles");
        if (listingContext != null && !Utility.isNullOrEmpty(listingContext.getMarker())) {
            builder.add("marker", listingContext.getMarker());
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        if (recursive != null && recursive.booleanValue()) {
            request.setRequestProperty("x-ms-recursive", "true");
        }
        request.setRequestProperty("x-ms-handle-id", handleID);
        request.setDoOutput(true);
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("Content-Length", "0");
        request.setRequestMethod("PUT");
        return request;
    }

    private FileRequest() {
    }

    public static HttpURLConnection createFilePermission(URI uri, FileRequestOptions fileOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("restype", "share");
        builder.add("comp", "filepermission");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestProperty("Content-Type", "application/json");
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        return request;
    }

    public static HttpURLConnection getFilePermission(URI uri, String filePermissionKey, FileRequestOptions fileOptions, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("restype", "share");
        builder.add("comp", "filepermission");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setRequestProperty("x-ms-file-permission-key", filePermissionKey);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection setDirectoryProperties(URI uri, FileRequestOptions fileOptions, OperationContext opContext, AccessCondition accessCondition, FileDirectoryProperties properties, String filePermission) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("restype", "directory");
        builder.add("comp", "properties");
        HttpURLConnection request = BaseRequest.createURLConnection(uri, fileOptions, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (properties != null) {
            FileRequest.addFilePermissionOrFilePermissionKey(request, properties.filePermissionKeyToSet, filePermission, "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-attributes", NtfsAttributes.toString(properties.ntfsAttributesToSet), "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-creation-time", properties.creationTimeToSet, "Preserve");
            FileRequest.setHeaderValueOrDefault(request, "x-ms-file-last-write-time", properties.lastWriteTimeToSet, "Preserve");
        }
        return request;
    }
}

