/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import jakarta.ejb.EJBException;
import jakarta.ejb.NoSuchObjectLocalException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TransactionManagementType;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentResourceDefinition;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.TimerResourceDefinition;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.dmr.ModelNode;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractEJBComponentRuntimeHandler<T extends EJBComponent>
extends AbstractRuntimeOnlyHandler {
    private final Map<PathAddress, ServiceName> componentConfigs = Collections.synchronizedMap(new HashMap());
    private final Class<T> componentClass;
    private final EJBComponentType componentType;

    protected AbstractEJBComponentRuntimeHandler(EJBComponentType componentType, Class<T> componentClass) {
        this.componentType = componentType;
        this.componentClass = componentClass;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String opName = operation.require("operation").asString();
        boolean forWrite = this.isForWrite(opName);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = this.getComponentConfiguration(context, address);
        T component = this.getComponent(serviceName, address, context, forWrite);
        if ("read-attribute".equals(opName)) {
            String attributeName = operation.require("name").asString();
            this.executeReadAttribute(attributeName, context, component, address);
        } else if ("write-attribute".equals(opName)) {
            String attributeName = operation.require("name").asString();
            this.executeWriteAttribute(attributeName, context, operation, component, address);
        } else {
            this.executeAgainstComponent(context, operation, component, opName, address);
        }
    }

    public void registerComponent(PathAddress address, ServiceName serviceName) {
        this.componentConfigs.put(address, serviceName);
    }

    public void unregisterComponent(PathAddress address) {
        this.componentConfigs.remove(address);
    }

    protected void executeReadAttribute(String attributeName, OperationContext context, T component, PathAddress address) {
        boolean hasPool = this.componentType.hasPool();
        ModelNode result = context.getResult();
        EJBComponentDescription componentDescription = ((EJBComponent)((Object)component)).getComponentDescription();
        if (AbstractEJBComponentResourceDefinition.COMPONENT_CLASS_NAME.getName().equals(attributeName)) {
            result.set(component.getComponentClass().getName());
        } else if (AbstractEJBComponentResourceDefinition.JNDI_NAMES.getName().equals(attributeName)) {
            for (ViewDescription view : componentDescription.getViews()) {
                for (String binding : view.getBindingNames()) {
                    result.add(binding);
                }
            }
        } else if (AbstractEJBComponentResourceDefinition.BUSINESS_LOCAL.getName().equals(attributeName)) {
            for (ViewDescription view : componentDescription.getViews()) {
                EJBViewDescription ejbViewDescription = (EJBViewDescription)view;
                if (ejbViewDescription.isEjb2xView() || ejbViewDescription.getMethodIntf() != MethodInterfaceType.Local) continue;
                result.add(ejbViewDescription.getViewClassName());
            }
        } else if (AbstractEJBComponentResourceDefinition.BUSINESS_REMOTE.getName().equals(attributeName)) {
            for (ViewDescription view : componentDescription.getViews()) {
                EJBViewDescription ejbViewDescription = (EJBViewDescription)view;
                if (ejbViewDescription.isEjb2xView() || ejbViewDescription.getMethodIntf() != MethodInterfaceType.Remote) continue;
                result.add(ejbViewDescription.getViewClassName());
            }
        } else if (AbstractEJBComponentResourceDefinition.TIMEOUT_METHOD.getName().equals(attributeName)) {
            Method timeoutMethod = ((EJBComponent)((Object)component)).getTimeoutMethod();
            if (timeoutMethod != null) {
                result.set(timeoutMethod.toString());
            }
        } else if (AbstractEJBComponentResourceDefinition.ASYNC_METHODS.getName().equals(attributeName)) {
            SessionBeanComponentDescription sessionBeanComponentDescription = (SessionBeanComponentDescription)componentDescription;
            Set<MethodIdentifier> asynchronousMethods = sessionBeanComponentDescription.getAsynchronousMethods();
            for (MethodIdentifier m : asynchronousMethods) {
                result.add(m.getReturnType() + " " + m.getName() + "(" + String.join((CharSequence)", ", m.getParameterTypes()) + ")");
            }
        } else if (AbstractEJBComponentResourceDefinition.TRANSACTION_TYPE.getName().equals(attributeName)) {
            result.set(((EJBComponent)((Object)component)).isBeanManagedTransaction() ? TransactionManagementType.BEAN.name() : TransactionManagementType.CONTAINER.name());
        } else if (AbstractEJBComponentResourceDefinition.SECURITY_DOMAIN.getName().equals(attributeName)) {
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null && md.getSecurityDomainName() != null) {
                result.set(md.getSecurityDomainName());
            }
        } else if (AbstractEJBComponentResourceDefinition.RUN_AS_ROLE.getName().equals(attributeName)) {
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null && md.getRunAs() != null) {
                result.set(md.getRunAs());
            }
        } else if (AbstractEJBComponentResourceDefinition.DECLARED_ROLES.getName().equals(attributeName)) {
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null) {
                result.setEmptyList();
                Set<String> roles = md.getDeclaredRoles();
                if (roles != null) {
                    for (String role : roles) {
                        result.add(role);
                    }
                }
            }
        } else if (this.componentType.hasTimer() && AbstractEJBComponentResourceDefinition.TIMERS.getName().equals(attributeName)) {
            AbstractEJBComponentRuntimeHandler.addTimers(component, result);
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_AVAILABLE_COUNT.getName().equals(attributeName)) {
            Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
            if (pool != null) {
                result.set(pool.getAvailableCount());
            }
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_CREATE_COUNT.getName().equals(attributeName)) {
            Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
            if (pool != null) {
                result.set(pool.getCreateCount());
            }
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_NAME.getName().equals(attributeName)) {
            String poolName = this.componentType.pooledComponent((EJBComponent)((Object)component)).getPoolName();
            if (poolName != null) {
                result.set(poolName);
            }
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_REMOVE_COUNT.getName().equals(attributeName)) {
            Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
            if (pool != null) {
                result.set(pool.getRemoveCount());
            }
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_CURRENT_SIZE.getName().equals(attributeName)) {
            Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
            if (pool != null) {
                result.set(pool.getCurrentSize());
            }
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.getName().equals(attributeName)) {
            Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
            if (pool != null) {
                result.set(pool.getMaxSize());
            }
        } else {
            throw EjbLogger.ROOT_LOGGER.unknownAttribute(attributeName);
        }
    }

    protected void executeWriteAttribute(String attributeName, OperationContext context, ModelNode operation, T component, PathAddress address) throws OperationFailedException {
        if (!this.componentType.hasPool() || !AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.getName().equals(attributeName)) {
            throw EjbLogger.ROOT_LOGGER.unknownAttribute(attributeName);
        }
        int newSize = AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.resolveValue(context, operation.get("value")).asInt();
        final Pool<?> pool = this.componentType.getPool((EJBComponent)((Object)component));
        final int oldSize = pool.getMaxSize();
        this.componentType.getPool((EJBComponent)((Object)component)).setMaxSize(newSize);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                pool.setMaxSize(oldSize);
            }
        });
    }

    protected void executeAgainstComponent(OperationContext context, ModelNode operation, T component, String opName, PathAddress address) throws OperationFailedException {
        throw AbstractEJBComponentRuntimeHandler.unknownOperation(opName);
    }

    protected boolean isOperationReadOnly(String opName) {
        throw AbstractEJBComponentRuntimeHandler.unknownOperation(opName);
    }

    private static IllegalStateException unknownOperation(String opName) {
        throw EjbLogger.ROOT_LOGGER.unknownOperations(opName);
    }

    private boolean isForWrite(String opName) {
        if ("write-attribute".equals(opName)) {
            return true;
        }
        if ("read-attribute".equals(opName)) {
            return false;
        }
        return !this.isOperationReadOnly(opName);
    }

    private ServiceName getComponentConfiguration(OperationContext context, PathAddress operationAddress) throws OperationFailedException {
        PathAddress pa;
        ServiceName config;
        ArrayList<PathElement> relativeAddress = new ArrayList<PathElement>();
        String typeKey = this.componentType.getResourceType();
        boolean skip = true;
        for (int i = operationAddress.size() - 1; i >= 0; --i) {
            PathElement pe = operationAddress.getElement(i);
            if (skip && !pe.getKey().equals(typeKey)) continue;
            skip = false;
            if ("deployment".equals(pe.getKey())) {
                String runtimName = this.resolveRuntimeName(context, pe);
                PathElement realPe = PathElement.pathElement((String)pe.getKey(), (String)runtimName);
                relativeAddress.add(0, realPe);
                break;
            }
            relativeAddress.add(0, pe);
        }
        if ((config = this.componentConfigs.get(pa = PathAddress.pathAddress(relativeAddress))) == null) {
            String exceptionMessage = EjbLogger.ROOT_LOGGER.noComponentRegisteredForAddress(operationAddress);
            throw new OperationFailedException(exceptionMessage);
        }
        return config;
    }

    private T getComponent(ServiceName serviceName, PathAddress operationAddress, OperationContext context, boolean forWrite) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(forWrite);
        ServiceController controller = registry.getService(serviceName);
        if (controller == null) {
            String exceptionMessage = EjbLogger.ROOT_LOGGER.noComponentAvailableForAddress(operationAddress);
            throw new OperationFailedException(exceptionMessage);
        }
        ServiceController.State controllerState = controller.getState();
        if (controllerState != ServiceController.State.UP) {
            String exceptionMessage = EjbLogger.ROOT_LOGGER.invalidComponentState(operationAddress, controllerState, ServiceController.State.UP);
            throw new OperationFailedException(exceptionMessage);
        }
        return (T)((Object)((EJBComponent)((Object)this.componentClass.cast(controller.getValue()))));
    }

    T getComponent(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = this.getComponentConfiguration(context, address);
        T component = this.getComponent(serviceName, address, context, false);
        return component;
    }

    protected String resolveRuntimeName(OperationContext context, PathElement address) {
        ModelNode runtimeName = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{address}), false).getModel().get("runtime-name");
        return runtimeName.asString();
    }

    private static void addTimers(EJBComponent ejb, ModelNode response) {
        response.setEmptyList();
        String name = ejb.getComponentName();
        ManagedTimerService ts = ejb.getTimerService();
        if (ts != null) {
            for (Timer timer : ts.getTimers()) {
                ModelNode timerNode = response.add();
                AbstractEJBComponentRuntimeHandler.addTimeRemaining(timer, timerNode, name);
                AbstractEJBComponentRuntimeHandler.addNextTimeout(timer, timerNode, name);
                AbstractEJBComponentRuntimeHandler.addCalendarTimer(timer, timerNode, name);
                AbstractEJBComponentRuntimeHandler.addPersistent(timer, timerNode, name);
                AbstractEJBComponentRuntimeHandler.addInfo(timer, timerNode, name);
                AbstractEJBComponentRuntimeHandler.addSchedule(timer, timerNode, name);
            }
        }
    }

    private static void addTimeRemaining(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(TimerResourceDefinition.TIME_REMAINING.getName());
            long time = timer.getTimeRemaining();
            detailNode.set(time);
        }
        catch (IllegalStateException detailNode) {
        }
        catch (NoSuchObjectLocalException detailNode) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addNextTimeout(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(TimerResourceDefinition.NEXT_TIMEOUT.getName());
            Date d = timer.getNextTimeout();
            if (d != null) {
                detailNode.set(d.getTime());
            }
        }
        catch (IllegalStateException detailNode) {
        }
        catch (NoSuchObjectLocalException detailNode) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addSchedule(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode schedNode = timerNode.get(TimerResourceDefinition.SCHEDULE.getName());
            ScheduleExpression sched = timer.getSchedule();
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getYear(), TimerResourceDefinition.YEAR.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getMonth(), TimerResourceDefinition.MONTH.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getDayOfMonth(), TimerResourceDefinition.DAY_OF_MONTH.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getDayOfWeek(), TimerResourceDefinition.DAY_OF_WEEK.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getHour(), TimerResourceDefinition.HOUR.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getMinute(), TimerResourceDefinition.MINUTE.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getSecond(), TimerResourceDefinition.SECOND.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailString(schedNode, sched.getTimezone(), TimerResourceDefinition.TIMEZONE.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailDate(schedNode, sched.getStart(), TimerResourceDefinition.START.getName());
            AbstractEJBComponentRuntimeHandler.addScheduleDetailDate(schedNode, sched.getEnd(), TimerResourceDefinition.END.getName());
        }
        catch (IllegalStateException schedNode) {
        }
        catch (NoSuchObjectLocalException schedNode) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addCalendarTimer(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(TimerResourceDefinition.CALENDAR_TIMER.getName());
            boolean b = timer.isCalendarTimer();
            detailNode.set(b);
        }
        catch (IllegalStateException detailNode) {
        }
        catch (NoSuchObjectLocalException detailNode) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addPersistent(Timer timer, ModelNode timerNode, String componentName) {
        try {
            ModelNode detailNode = timerNode.get(TimerResourceDefinition.PERSISTENT.getName());
            boolean b = timer.isPersistent();
            detailNode.set(b);
        }
        catch (IllegalStateException detailNode) {
        }
        catch (NoSuchObjectLocalException detailNode) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addInfo(Timer timer, ModelNode timerNode, String componentName) {
        try {
            Serializable info;
            Serializable serializable = info = timer instanceof TimerImpl ? ((TimerImpl)timer).getCachedTimerInfo() : timer.getInfo();
            if (info != null) {
                ModelNode detailNode = timerNode.get(TimerResourceDefinition.INFO.getName());
                detailNode.set(info.toString());
            }
        }
        catch (IllegalStateException info) {
        }
        catch (NoSuchObjectLocalException info) {
        }
        catch (EJBException e) {
            AbstractEJBComponentRuntimeHandler.logTimerFailure(componentName, e);
        }
    }

    private static void addScheduleDetailString(ModelNode schedNode, String value, String detailName) {
        ModelNode node = schedNode.get(detailName);
        if (value != null) {
            node.set(value);
        }
    }

    private static void addScheduleDetailDate(ModelNode schedNode, Date value, String detailName) {
        ModelNode node = schedNode.get(detailName);
        if (value != null) {
            node.set(value.getTime());
        }
    }

    private static void logTimerFailure(String componentName, EJBException e) {
        EjbLogger.ROOT_LOGGER.failToReadTimerInformation(componentName, e);
    }
}

